/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.network.UpdateMetadataNetworkRequest;
import org.json.JSONException;

class UpdateMetadataTask
implements Runnable {
    private static final String TAG = "UpdateMetadataTask";
    private final StorageReference mStorageRef;
    private final TaskCompletionSource<StorageMetadata> mPendingResult;
    private final StorageMetadata mNewMetadata;
    private StorageMetadata mResultMetadata = null;
    private ExponentialBackoffSender mSender;

    public UpdateMetadataTask(@NonNull StorageReference storageRef, @NonNull TaskCompletionSource<StorageMetadata> pendingResult, @NonNull StorageMetadata newMetadata) {
        this.mStorageRef = storageRef;
        this.mPendingResult = pendingResult;
        this.mNewMetadata = newMetadata;
        this.mSender = new ExponentialBackoffSender(this.mStorageRef.getApp(), this.mStorageRef.getStorage().getMaxOperationRetryTimeMillis());
    }

    @Override
    public void run() {
        UpdateMetadataNetworkRequest request;
        try {
            request = new UpdateMetadataNetworkRequest(this.mStorageRef.getStorageUri(), this.mStorageRef.getApp(), this.mNewMetadata.createJSONObject());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Unable to create the request from metadata.", (Throwable)e);
            this.mPendingResult.setException((Exception)((Object)StorageException.fromException(e)));
            return;
        }
        this.mSender.sendWithExponentialBackoff(request);
        if (request.isResultSuccess()) {
            try {
                this.mResultMetadata = new StorageMetadata.Builder(request.getResultBody(), this.mStorageRef).build();
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("Unable to parse a valid JSON object from resulting metadata:" + request.getRawResult()), (Throwable)e);
                this.mPendingResult.setException((Exception)((Object)StorageException.fromException(e)));
                return;
            }
        }
        if (this.mPendingResult != null) {
            request.completeTask(this.mPendingResult, this.mResultMetadata);
        }
    }
}

