/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.storage.DeleteStorageTask;
import com.google.firebase.storage.FileDownloadTask;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.GetDownloadUrlTask;
import com.google.firebase.storage.GetMetadataTask;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageTaskManager;
import com.google.firebase.storage.StorageTaskScheduler;
import com.google.firebase.storage.StreamDownloadTask;
import com.google.firebase.storage.UpdateMetadataTask;
import com.google.firebase.storage.UploadTask;
import com.google.firebase.storage.internal.SlashUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

@PublicApi
public class StorageReference {
    private static final String TAG = "StorageReference";
    private final Uri mStorageUri;
    private final FirebaseStorage mFirebaseStorage;

    StorageReference(@NonNull Uri storageUri, @NonNull FirebaseStorage firebaseStorage) {
        Preconditions.checkArgument((storageUri != null ? 1 : 0) != 0, (Object)"storageUri cannot be null");
        Preconditions.checkArgument((firebaseStorage != null ? 1 : 0) != 0, (Object)"FirebaseApp cannot be null");
        this.mStorageUri = storageUri;
        this.mFirebaseStorage = firebaseStorage;
    }

    @NonNull
    @PublicApi
    public StorageReference child(@NonNull String pathString) {
        Uri child;
        Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)pathString) ? 1 : 0) != 0, (Object)"childName cannot be null or empty");
        pathString = SlashUtil.normalizeSlashes(pathString);
        try {
            child = this.mStorageUri.buildUpon().appendEncodedPath(SlashUtil.preserveSlashEncode(pathString)).build();
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("Unable to create a valid default Uri. " + pathString), (Throwable)e);
            throw new IllegalArgumentException("childName");
        }
        return new StorageReference(child, this.mFirebaseStorage);
    }

    @Nullable
    @PublicApi
    public StorageReference getParent() {
        String path = this.mStorageUri.getPath();
        if (TextUtils.isEmpty((CharSequence)path) || path.equals("/")) {
            return null;
        }
        int childIndex = path.lastIndexOf(47);
        path = childIndex == -1 ? "/" : path.substring(0, childIndex);
        Uri child = this.mStorageUri.buildUpon().path(path).build();
        return new StorageReference(child, this.mFirebaseStorage);
    }

    @NonNull
    @PublicApi
    public StorageReference getRoot() {
        Uri child = this.mStorageUri.buildUpon().path("").build();
        return new StorageReference(child, this.mFirebaseStorage);
    }

    @NonNull
    @PublicApi
    public String getName() {
        String path = this.mStorageUri.getPath();
        assert (path != null);
        int lastIndex = path.lastIndexOf(47);
        if (lastIndex != -1) {
            return path.substring(lastIndex + 1);
        }
        return path;
    }

    @NonNull
    @PublicApi
    public String getPath() {
        String path = this.mStorageUri.getPath();
        assert (path != null);
        return path;
    }

    @NonNull
    @PublicApi
    public String getBucket() {
        return this.mStorageUri.getAuthority();
    }

    @NonNull
    @PublicApi
    public FirebaseStorage getStorage() {
        return this.mFirebaseStorage;
    }

    @NonNull
    FirebaseApp getApp() {
        return this.getStorage().getApp();
    }

    @NonNull
    @PublicApi
    public UploadTask putBytes(@NonNull byte[] bytes) {
        Preconditions.checkArgument((bytes != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        UploadTask task = new UploadTask(this, null, bytes);
        task.queue();
        return task;
    }

    @NonNull
    @PublicApi
    public UploadTask putBytes(@NonNull byte[] bytes, @NonNull StorageMetadata metadata) {
        Preconditions.checkArgument((bytes != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask task = new UploadTask(this, metadata, bytes);
        task.queue();
        return task;
    }

    @NonNull
    @PublicApi
    public UploadTask putFile(@NonNull Uri uri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        UploadTask task = new UploadTask(this, null, uri, null);
        task.queue();
        return task;
    }

    @NonNull
    @PublicApi
    public UploadTask putFile(@NonNull Uri uri, @NonNull StorageMetadata metadata) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask task = new UploadTask(this, metadata, uri, null);
        task.queue();
        return task;
    }

    @NonNull
    @PublicApi
    public UploadTask putFile(@NonNull Uri uri, @Nullable StorageMetadata metadata, @Nullable Uri existingUploadUri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask task = new UploadTask(this, metadata, uri, existingUploadUri);
        task.queue();
        return task;
    }

    @NonNull
    @PublicApi
    public UploadTask putStream(@NonNull InputStream stream) {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        UploadTask task = new UploadTask(this, null, stream);
        task.queue();
        return task;
    }

    @NonNull
    @PublicApi
    public UploadTask putStream(@NonNull InputStream stream, @NonNull StorageMetadata metadata) {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask task = new UploadTask(this, metadata, stream);
        task.queue();
        return task;
    }

    @NonNull
    @PublicApi
    public List<UploadTask> getActiveUploadTasks() {
        return StorageTaskManager.getInstance().getUploadTasksUnder(this);
    }

    @NonNull
    @PublicApi
    public List<FileDownloadTask> getActiveDownloadTasks() {
        return StorageTaskManager.getInstance().getDownloadTasksUnder(this);
    }

    @NonNull
    @PublicApi
    public Task<StorageMetadata> getMetadata() {
        TaskCompletionSource pendingResult = new TaskCompletionSource();
        StorageTaskScheduler.getInstance().scheduleCommand(new GetMetadataTask(this, (TaskCompletionSource<StorageMetadata>)pendingResult));
        return pendingResult.getTask();
    }

    @NonNull
    @PublicApi
    public Task<Uri> getDownloadUrl() {
        TaskCompletionSource pendingResult = new TaskCompletionSource();
        StorageTaskScheduler.getInstance().scheduleCommand(new GetDownloadUrlTask(this, (TaskCompletionSource<Uri>)pendingResult));
        return pendingResult.getTask();
    }

    @NonNull
    @PublicApi
    public Task<StorageMetadata> updateMetadata(@NonNull StorageMetadata metadata) {
        Preconditions.checkNotNull((Object)metadata);
        TaskCompletionSource pendingResult = new TaskCompletionSource();
        StorageTaskScheduler.getInstance().scheduleCommand(new UpdateMetadataTask(this, (TaskCompletionSource<StorageMetadata>)pendingResult, metadata));
        return pendingResult.getTask();
    }

    @NonNull
    @PublicApi
    public Task<byte[]> getBytes(final long maxDownloadSizeBytes) {
        final TaskCompletionSource pendingResult = new TaskCompletionSource();
        StreamDownloadTask task = new StreamDownloadTask(this);
        task.setStreamProcessor(new StreamDownloadTask.StreamProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @PublicApi
            public void doInBackground(StreamDownloadTask.TaskSnapshot state, InputStream stream) throws IOException {
                try {
                    int nRead;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    int totalRead = 0;
                    byte[] data = new byte[16384];
                    while ((nRead = stream.read(data, 0, data.length)) != -1) {
                        if ((long)(totalRead += nRead) > maxDownloadSizeBytes) {
                            Log.e((String)StorageReference.TAG, (String)"the maximum allowed buffer size was exceeded.");
                            throw new IndexOutOfBoundsException("the maximum allowed buffer size was exceeded.");
                        }
                        buffer.write(data, 0, nRead);
                    }
                    buffer.flush();
                    pendingResult.setResult((Object)buffer.toByteArray());
                }
                finally {
                    stream.close();
                }
            }
        }).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<StreamDownloadTask.TaskSnapshot>(){

            @PublicApi
            public void onSuccess(StreamDownloadTask.TaskSnapshot state) {
                if (!pendingResult.getTask().isComplete()) {
                    Log.e((String)StorageReference.TAG, (String)"getBytes 'succeeded', but failed to set a Result.");
                    pendingResult.setException((Exception)((Object)StorageException.fromErrorStatus(Status.RESULT_INTERNAL_ERROR)));
                }
            }
        }).addOnFailureListener(new OnFailureListener(){

            @PublicApi
            public void onFailure(@NonNull Exception e) {
                StorageException se = StorageException.fromExceptionAndHttpCode(e, 0);
                assert (se != null);
                pendingResult.setException((Exception)((Object)se));
            }
        });
        task.queue();
        return pendingResult.getTask();
    }

    @NonNull
    @PublicApi
    public FileDownloadTask getFile(@NonNull Uri destinationUri) {
        FileDownloadTask task = new FileDownloadTask(this, destinationUri);
        task.queue();
        return task;
    }

    @NonNull
    @PublicApi
    public FileDownloadTask getFile(@NonNull File destinationFile) {
        return this.getFile(Uri.fromFile((File)destinationFile));
    }

    @NonNull
    @PublicApi
    public StreamDownloadTask getStream() {
        StreamDownloadTask task = new StreamDownloadTask(this);
        task.queue();
        return task;
    }

    @NonNull
    @PublicApi
    public StreamDownloadTask getStream(@NonNull StreamDownloadTask.StreamProcessor processor) {
        StreamDownloadTask task = new StreamDownloadTask(this);
        task.setStreamProcessor(processor);
        task.queue();
        return task;
    }

    @PublicApi
    public Task<Void> delete() {
        TaskCompletionSource pendingResult = new TaskCompletionSource();
        StorageTaskScheduler.getInstance().scheduleCommand(new DeleteStorageTask(this, (TaskCompletionSource<Void>)pendingResult));
        return pendingResult.getTask();
    }

    @NonNull
    Uri getStorageUri() {
        return this.mStorageUri;
    }

    public String toString() {
        return "gs://" + this.mStorageUri.getAuthority() + this.mStorageUri.getEncodedPath();
    }

    public boolean equals(Object other) {
        if (!(other instanceof StorageReference)) {
            return false;
        }
        StorageReference otherStorage = (StorageReference)other;
        return otherStorage.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

