/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzfbd;
import com.google.android.gms.internal.zzfbm;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.FileDownloadTask;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.StreamDownloadTask;
import com.google.firebase.storage.UploadTask;
import com.google.firebase.storage.zzac;
import com.google.firebase.storage.zzb;
import com.google.firebase.storage.zzc;
import com.google.firebase.storage.zze;
import com.google.firebase.storage.zzf;
import com.google.firebase.storage.zzg;
import com.google.firebase.storage.zzh;
import com.google.firebase.storage.zzi;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzu;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class StorageReference {
    private final Uri zzoux;
    private final FirebaseStorage zzouy;

    StorageReference(@NonNull Uri uri, @NonNull FirebaseStorage firebaseStorage) {
        zzbq.checkArgument((uri != null ? 1 : 0) != 0, (Object)"storageUri cannot be null");
        zzbq.checkArgument((firebaseStorage != null ? 1 : 0) != 0, (Object)"FirebaseApp cannot be null");
        this.zzoux = uri;
        this.zzouy = firebaseStorage;
    }

    @NonNull
    public StorageReference child(@NonNull String string) {
        Uri uri;
        zzbq.checkArgument((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"childName cannot be null or empty");
        string = zzfbd.zzsp((String)string);
        try {
            uri = this.zzoux.buildUpon().appendEncodedPath(zzfbd.zzsn((String)string)).build();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = String.valueOf(string);
            Log.e((String)"StorageReference", (String)(string2.length() != 0 ? "Unable to create a valid default Uri. ".concat(string2) : new String("Unable to create a valid default Uri. ")), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException("childName");
        }
        return new StorageReference(uri, this.zzouy);
    }

    @Nullable
    public StorageReference getParent() {
        String string = this.zzoux.getPath();
        if (TextUtils.isEmpty((CharSequence)string) || string.equals("/")) {
            return null;
        }
        int n = string.lastIndexOf(47);
        string = n == -1 ? "/" : string.substring(0, n);
        Uri uri = this.zzoux.buildUpon().path(string).build();
        return new StorageReference(uri, this.zzouy);
    }

    @NonNull
    public StorageReference getRoot() {
        Uri uri = this.zzoux.buildUpon().path("").build();
        return new StorageReference(uri, this.zzouy);
    }

    @NonNull
    public String getName() {
        String string = this.zzoux.getPath();
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @NonNull
    public String getPath() {
        return this.zzoux.getPath();
    }

    @NonNull
    public String getBucket() {
        return this.zzoux.getAuthority();
    }

    @NonNull
    public FirebaseStorage getStorage() {
        return this.zzouy;
    }

    @NonNull
    final zzfbm zzcnw() throws RemoteException {
        return zzfbm.zzi(this.getStorage().getApp());
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] byArray) {
        zzbq.checkArgument((byArray != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, byArray);
        uploadTask.zzcny();
        return uploadTask;
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] byArray, @NonNull StorageMetadata storageMetadata) {
        zzbq.checkArgument((byArray != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        zzbq.checkArgument((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, byArray);
        uploadTask.zzcny();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri) {
        zzbq.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, uri, null);
        uploadTask.zzcny();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @NonNull StorageMetadata storageMetadata) {
        zzbq.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        zzbq.checkArgument((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, uri, null);
        uploadTask.zzcny();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @Nullable StorageMetadata storageMetadata, @Nullable Uri uri2) {
        zzbq.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        zzbq.checkArgument((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, uri, uri2);
        uploadTask.zzcny();
        return uploadTask;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream inputStream) {
        zzbq.checkArgument((inputStream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, inputStream);
        uploadTask.zzcny();
        return uploadTask;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream inputStream, @NonNull StorageMetadata storageMetadata) {
        zzbq.checkArgument((inputStream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        zzbq.checkArgument((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, inputStream);
        uploadTask.zzcny();
        return uploadTask;
    }

    @NonNull
    public List<UploadTask> getActiveUploadTasks() {
        return zzt.zzcod().zza(this);
    }

    @NonNull
    public List<FileDownloadTask> getActiveDownloadTasks() {
        return zzt.zzcod().zzb(this);
    }

    @NonNull
    public Task<StorageMetadata> getMetadata() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzu.zzt(new zzc(this, (TaskCompletionSource<StorageMetadata>)taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<Uri> getDownloadUrl() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Task<StorageMetadata> task = this.getMetadata();
        task.addOnSuccessListener((OnSuccessListener)new zze(this, taskCompletionSource));
        task.addOnFailureListener((OnFailureListener)new zzf(this, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<StorageMetadata> updateMetadata(@NonNull StorageMetadata storageMetadata) {
        zzbq.checkNotNull((Object)storageMetadata);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzu.zzt(new zzac(this, (TaskCompletionSource<StorageMetadata>)taskCompletionSource, storageMetadata));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<byte[]> getBytes(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        ((StorageTask)streamDownloadTask.zza(new zzi(this, l, taskCompletionSource)).addOnSuccessListener(new zzh(this, taskCompletionSource))).addOnFailureListener(new zzg(this, taskCompletionSource));
        streamDownloadTask.zzcny();
        return taskCompletionSource.getTask();
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull Uri uri) {
        FileDownloadTask fileDownloadTask = new FileDownloadTask(this, uri);
        fileDownloadTask.zzcny();
        return fileDownloadTask;
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull File file) {
        return this.getFile(Uri.fromFile((File)file));
    }

    @NonNull
    public StreamDownloadTask getStream() {
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        streamDownloadTask.zzcny();
        return streamDownloadTask;
    }

    @NonNull
    public StreamDownloadTask getStream(@NonNull StreamDownloadTask.StreamProcessor streamProcessor) {
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        streamDownloadTask.zza(streamProcessor);
        streamDownloadTask.zzcny();
        return streamDownloadTask;
    }

    public Task<Void> delete() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzu.zzt(new zzb(this, (TaskCompletionSource<Void>)taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    final Uri zzcnx() {
        return this.zzoux;
    }

    public String toString() {
        String string = this.zzoux.getAuthority();
        String string2 = this.zzoux.getEncodedPath();
        return new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(string2).length()).append("gs://").append(string).append(string2).toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof StorageReference)) {
            return false;
        }
        return ((StorageReference)object).toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

