/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public final class zzfbb {
    private static final Runtime zzoxk = Runtime.getRuntime();
    private final InputStream zzoxl;
    private byte[] buffer;
    private int zzoxm;
    private boolean zzoxn;
    private boolean zzoxo;

    public zzfbb(InputStream inputStream, int n) {
        this.zzoxl = inputStream;
        this.buffer = new byte[262144];
        this.zzoxm = 0;
        this.zzoxo = true;
        this.zzoxn = false;
    }

    public final int available() {
        return this.zzoxm;
    }

    public final byte[] zzcom() {
        return this.buffer;
    }

    public final int zzja(int n) throws IOException {
        int n2;
        if (n <= this.zzoxm) {
            this.zzoxm -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zzoxm);
            n2 = n;
        } else {
            n2 = this.zzoxm = 0;
            while (n2 < n) {
                long l = this.zzoxl.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zzoxl.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public final int zzjb(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzjc(n));
        }
        while (this.zzoxm < n) {
            int n2 = this.zzoxl.read(this.buffer, this.zzoxm, n - this.zzoxm);
            if (n2 == -1) {
                this.zzoxn = true;
                break;
            }
            this.zzoxm += n2;
        }
        return this.zzoxm;
    }

    private final int zzjc(int n) {
        int n2 = Math.max(this.buffer.length << 1, n);
        long l = zzoxk.totalMemory() - zzoxk.freeMemory();
        long l2 = zzoxk.maxMemory() - l;
        if (this.zzoxo && (long)n2 < l2) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zzoxm);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zzoxo = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public final boolean isFinished() {
        return this.zzoxn;
    }

    public final void close() throws IOException {
        this.zzoxl.close();
    }
}

