package com.google.firebase.sessions;

import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import java.io.IOException;
import java.lang.Override;

public final class AutoSessionEventEncoder implements Configurator {
  public static final int CODEGEN_VERSION = 2;

  public static final Configurator CONFIG = new AutoSessionEventEncoder();

  private AutoSessionEventEncoder() {
  }

  @Override
  public void configure(EncoderConfig<?> cfg) {
    cfg.registerEncoder(SessionEvent.class, SessionEventEncoder.INSTANCE);
    cfg.registerEncoder(SessionInfo.class, SessionInfoEncoder.INSTANCE);
    cfg.registerEncoder(DataCollectionStatus.class, DataCollectionStatusEncoder.INSTANCE);
    cfg.registerEncoder(ApplicationInfo.class, ApplicationInfoEncoder.INSTANCE);
    cfg.registerEncoder(AndroidApplicationInfo.class, AndroidApplicationInfoEncoder.INSTANCE);
  }

  private static final class SessionEventEncoder implements ObjectEncoder<SessionEvent> {
    static final SessionEventEncoder INSTANCE = new SessionEventEncoder();

    private static final FieldDescriptor EVENTTYPE_DESCRIPTOR = FieldDescriptor.of("eventType");

    private static final FieldDescriptor SESSIONDATA_DESCRIPTOR = FieldDescriptor.of("sessionData");

    private static final FieldDescriptor APPLICATIONINFO_DESCRIPTOR = FieldDescriptor.of("applicationInfo");

    @Override
    public void encode(SessionEvent value, ObjectEncoderContext ctx) throws IOException {
      ctx.add(EVENTTYPE_DESCRIPTOR, value.getEventType());
      ctx.add(SESSIONDATA_DESCRIPTOR, value.getSessionData());
      ctx.add(APPLICATIONINFO_DESCRIPTOR, value.getApplicationInfo());
    }
  }

  private static final class SessionInfoEncoder implements ObjectEncoder<SessionInfo> {
    static final SessionInfoEncoder INSTANCE = new SessionInfoEncoder();

    private static final FieldDescriptor SESSIONID_DESCRIPTOR = FieldDescriptor.of("sessionId");

    private static final FieldDescriptor FIRSTSESSIONID_DESCRIPTOR = FieldDescriptor.of("firstSessionId");

    private static final FieldDescriptor SESSIONINDEX_DESCRIPTOR = FieldDescriptor.of("sessionIndex");

    private static final FieldDescriptor EVENTTIMESTAMPUS_DESCRIPTOR = FieldDescriptor.of("eventTimestampUs");

    private static final FieldDescriptor DATACOLLECTIONSTATUS_DESCRIPTOR = FieldDescriptor.of("dataCollectionStatus");

    private static final FieldDescriptor FIREBASEINSTALLATIONID_DESCRIPTOR = FieldDescriptor.of("firebaseInstallationId");

    @Override
    public void encode(SessionInfo value, ObjectEncoderContext ctx) throws IOException {
      ctx.add(SESSIONID_DESCRIPTOR, value.getSessionId());
      ctx.add(FIRSTSESSIONID_DESCRIPTOR, value.getFirstSessionId());
      ctx.add(SESSIONINDEX_DESCRIPTOR, value.getSessionIndex());
      ctx.add(EVENTTIMESTAMPUS_DESCRIPTOR, value.getEventTimestampUs());
      ctx.add(DATACOLLECTIONSTATUS_DESCRIPTOR, value.getDataCollectionStatus());
      ctx.add(FIREBASEINSTALLATIONID_DESCRIPTOR, value.getFirebaseInstallationId());
    }
  }

  private static final class DataCollectionStatusEncoder implements ObjectEncoder<DataCollectionStatus> {
    static final DataCollectionStatusEncoder INSTANCE = new DataCollectionStatusEncoder();

    private static final FieldDescriptor PERFORMANCE_DESCRIPTOR = FieldDescriptor.of("performance");

    private static final FieldDescriptor CRASHLYTICS_DESCRIPTOR = FieldDescriptor.of("crashlytics");

    private static final FieldDescriptor SESSIONSAMPLINGRATE_DESCRIPTOR = FieldDescriptor.of("sessionSamplingRate");

    @Override
    public void encode(DataCollectionStatus value, ObjectEncoderContext ctx) throws IOException {
      ctx.add(PERFORMANCE_DESCRIPTOR, value.getPerformance());
      ctx.add(CRASHLYTICS_DESCRIPTOR, value.getCrashlytics());
      ctx.add(SESSIONSAMPLINGRATE_DESCRIPTOR, value.getSessionSamplingRate());
    }
  }

  private static final class ApplicationInfoEncoder implements ObjectEncoder<ApplicationInfo> {
    static final ApplicationInfoEncoder INSTANCE = new ApplicationInfoEncoder();

    private static final FieldDescriptor APPID_DESCRIPTOR = FieldDescriptor.of("appId");

    private static final FieldDescriptor DEVICEMODEL_DESCRIPTOR = FieldDescriptor.of("deviceModel");

    private static final FieldDescriptor SESSIONSDKVERSION_DESCRIPTOR = FieldDescriptor.of("sessionSdkVersion");

    private static final FieldDescriptor OSVERSION_DESCRIPTOR = FieldDescriptor.of("osVersion");

    private static final FieldDescriptor LOGENVIRONMENT_DESCRIPTOR = FieldDescriptor.of("logEnvironment");

    private static final FieldDescriptor ANDROIDAPPINFO_DESCRIPTOR = FieldDescriptor.of("androidAppInfo");

    @Override
    public void encode(ApplicationInfo value, ObjectEncoderContext ctx) throws IOException {
      ctx.add(APPID_DESCRIPTOR, value.getAppId());
      ctx.add(DEVICEMODEL_DESCRIPTOR, value.getDeviceModel());
      ctx.add(SESSIONSDKVERSION_DESCRIPTOR, value.getSessionSdkVersion());
      ctx.add(OSVERSION_DESCRIPTOR, value.getOsVersion());
      ctx.add(LOGENVIRONMENT_DESCRIPTOR, value.getLogEnvironment());
      ctx.add(ANDROIDAPPINFO_DESCRIPTOR, value.getAndroidAppInfo());
    }
  }

  private static final class AndroidApplicationInfoEncoder implements ObjectEncoder<AndroidApplicationInfo> {
    static final AndroidApplicationInfoEncoder INSTANCE = new AndroidApplicationInfoEncoder();

    private static final FieldDescriptor PACKAGENAME_DESCRIPTOR = FieldDescriptor.of("packageName");

    private static final FieldDescriptor VERSIONNAME_DESCRIPTOR = FieldDescriptor.of("versionName");

    private static final FieldDescriptor APPBUILDVERSION_DESCRIPTOR = FieldDescriptor.of("appBuildVersion");

    private static final FieldDescriptor DEVICEMANUFACTURER_DESCRIPTOR = FieldDescriptor.of("deviceManufacturer");

    @Override
    public void encode(AndroidApplicationInfo value, ObjectEncoderContext ctx) throws IOException {
      ctx.add(PACKAGENAME_DESCRIPTOR, value.getPackageName());
      ctx.add(VERSIONNAME_DESCRIPTOR, value.getVersionName());
      ctx.add(APPBUILDVERSION_DESCRIPTOR, value.getAppBuildVersion());
      ctx.add(DEVICEMANUFACTURER_DESCRIPTOR, value.getDeviceManufacturer());
    }
  }
}
