/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.core.DatabaseConfig;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.core.RepoManager;
import com.google.firebase.database.utilities.ParsedUrl;
import com.google.firebase.database.utilities.Utilities;
import com.google.firebase.database.utilities.Validation;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final String SDK_VERSION = "3.0.0";
    private static final Map<String, FirebaseDatabase> databaseInstances = new HashMap<String, FirebaseDatabase>();
    private final FirebaseApp app;
    private final RepoInfo repoInfo;
    private final DatabaseConfig config;
    private Repo repo;

    public static FirebaseDatabase getInstance() {
        return FirebaseDatabase.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp app) {
        if (!databaseInstances.containsKey(app.getName())) {
            String url = app.getOptions().getDatabaseUrl();
            if (url == null) {
                throw new DatabaseException("Failed to get FirebaseDatabase instance: FirebaseApp object has no DatabaseURL in its FirebaseOptions object.");
            }
            ParsedUrl parsedUrl = Utilities.parseUrl(url);
            if (!parsedUrl.path.isEmpty()) {
                String string = String.valueOf(parsedUrl.path.toString());
                throw new DatabaseException(new StringBuilder(114 + String.valueOf(url).length() + String.valueOf(string).length()).append("Configured Database URL '").append(url).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string).toString());
            }
            DatabaseConfig config = new DatabaseConfig();
            config.setSessionPersistenceKey(app.getName());
            config.setFirebaseApp(app);
            databaseInstances.put(app.getName(), new FirebaseDatabase(app, parsedUrl.repoInfo, config));
        }
        return databaseInstances.get(app.getName());
    }

    static FirebaseDatabase createForTests(FirebaseApp app, RepoInfo repoInfo, DatabaseConfig config) {
        FirebaseDatabase db = new FirebaseDatabase(app, repoInfo, config);
        db.ensureRepo();
        return db;
    }

    private FirebaseDatabase(FirebaseApp app, RepoInfo repoInfo, DatabaseConfig config) {
        this.app = app;
        this.repoInfo = repoInfo;
        this.config = config;
    }

    public FirebaseApp getApp() {
        return this.app;
    }

    public DatabaseReference getReference() {
        this.ensureRepo();
        return new DatabaseReference(this.repo, Path.getEmptyPath());
    }

    public DatabaseReference getReference(String path) {
        this.ensureRepo();
        if (path == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        Validation.validateRootPathString(path);
        Path childPath = new Path(path);
        return new DatabaseReference(this.repo, childPath);
    }

    public DatabaseReference getReferenceFromUrl(String url) {
        this.ensureRepo();
        if (url == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        ParsedUrl parsedUrl = Utilities.parseUrl(url);
        if (!parsedUrl.repoInfo.host.equals(this.repo.getRepoInfo().host)) {
            String string = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(url).length() + String.valueOf(string).length()).append("Invalid URL (").append(url).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string).toString());
        }
        return new DatabaseReference(this.repo, parsedUrl.path);
    }

    public void purgeOutstandingWrites() {
        this.ensureRepo();
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.repo.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        this.ensureRepo();
        RepoManager.resume(this.repo);
    }

    public void goOffline() {
        this.ensureRepo();
        RepoManager.interrupt(this.repo);
    }

    public synchronized void setLogLevel(Logger.Level logLevel) {
        this.assertUnfrozen("setLogLevel");
        this.config.setLogLevel(logLevel);
    }

    public synchronized void setPersistenceEnabled(boolean isEnabled) {
        this.assertUnfrozen("setPersistenceEnabled");
        this.config.setPersistenceEnabled(isEnabled);
    }

    public static String getSdkVersion() {
        return SDK_VERSION;
    }

    private void assertUnfrozen(String methodCalled) {
        if (this.repo != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(methodCalled).length()).append("Calls to ").append(methodCalled).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private synchronized void ensureRepo() {
        if (this.repo == null) {
            this.repo = RepoManager.createRepo(this.config, this.repoInfo, this);
        }
    }
}

