/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.os.Bundle;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.Optional;

public final class ImmutableBundle {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final Bundle bundle;

    public ImmutableBundle() {
        this(new Bundle());
    }

    public ImmutableBundle(Bundle bundle) {
        this.bundle = (Bundle)bundle.clone();
    }

    public boolean containsKey(String key) {
        return key != null && this.bundle.containsKey(key);
    }

    public Optional<Boolean> getBoolean(String key) {
        if (!this.containsKey(key)) {
            return Optional.absent();
        }
        try {
            Object o = this.bundle.get(key);
            return Optional.fromNullable((Boolean)o);
        }
        catch (ClassCastException e) {
            logger.debug("Metadata key %s contains type other than boolean: %s", key, e.getMessage());
            return Optional.absent();
        }
    }

    public Optional<Double> getDouble(String key) {
        if (!this.containsKey(key)) {
            return Optional.absent();
        }
        Object o = this.bundle.get(key);
        if (o == null) {
            return Optional.absent();
        }
        if (o instanceof Float) {
            return Optional.of(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return Optional.of((Double)o);
        }
        logger.debug("Metadata key %s contains type other than double: %s", key);
        return Optional.absent();
    }

    public Optional<Long> getLong(String key) {
        Optional<Integer> intValue = this.getInt(key);
        if (intValue.isAvailable()) {
            return Optional.of(Long.valueOf(intValue.get().intValue()));
        }
        return Optional.absent();
    }

    private Optional<Integer> getInt(String key) {
        if (!this.containsKey(key)) {
            return Optional.absent();
        }
        try {
            Object o = this.bundle.get(key);
            return Optional.fromNullable((Integer)o);
        }
        catch (ClassCastException e) {
            logger.debug("Metadata key %s contains type other than int: %s", key, e.getMessage());
            return Optional.absent();
        }
    }
}

