/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.config;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.StartupTime;
import com.google.firebase.inject.Provider;
import com.google.firebase.perf.config.ConfigurationConstants;
import com.google.firebase.perf.config.DeviceCacheManager;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.Optional;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.RemoteConfigComponent;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Keep
public class RemoteConfigManager {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final RemoteConfigManager instance = new RemoteConfigManager();
    private static final String FIREPERF_FRC_NAMESPACE_NAME = "fireperf";
    private static final long TIME_AFTER_WHICH_A_FETCH_IS_CONSIDERED_STALE_MS = TimeUnit.HOURS.toMillis(12L);
    private static final long FETCH_NEVER_HAPPENED_TIMESTAMP_MS = 0L;
    private static final long MIN_APP_START_CONFIG_FETCH_DELAY_MS = 5000L;
    private static final int RANDOM_APP_START_CONFIG_FETCH_DELAY_MS = 25000;
    private final DeviceCacheManager cache;
    private final ConcurrentHashMap<String, FirebaseRemoteConfigValue> allRcConfigMap;
    private final Executor executor;
    private final long appStartTimeInMs;
    private final long appStartConfigFetchDelayInMs;
    private long firebaseRemoteConfigLastFetchTimestampMs = 0L;
    @Nullable
    private Provider<RemoteConfigComponent> firebaseRemoteConfigProvider;
    @Nullable
    private FirebaseRemoteConfig firebaseRemoteConfig;

    @SuppressLint(value={"ThreadPoolCreation"})
    private RemoteConfigManager() {
        this(DeviceCacheManager.getInstance(), new ThreadPoolExecutor(0, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()), null, 5000L + (long)new Random().nextInt(25000), RemoteConfigManager.getInitialStartupMillis());
    }

    @VisibleForTesting
    static long getInitialStartupMillis() {
        StartupTime startupTime = (StartupTime)FirebaseApp.getInstance().get(StartupTime.class);
        if (startupTime != null) {
            return startupTime.getEpochMillis();
        }
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    RemoteConfigManager(DeviceCacheManager cache, Executor executor, FirebaseRemoteConfig firebaseRemoteConfig, long appStartConfigFetchDelayInMs, long appStartTimeInMs) {
        this.cache = cache;
        this.executor = executor;
        this.firebaseRemoteConfig = firebaseRemoteConfig;
        this.allRcConfigMap = firebaseRemoteConfig == null ? new ConcurrentHashMap() : new ConcurrentHashMap(firebaseRemoteConfig.getAll());
        this.appStartTimeInMs = appStartTimeInMs;
        this.appStartConfigFetchDelayInMs = appStartConfigFetchDelayInMs;
    }

    public static RemoteConfigManager getInstance() {
        return instance;
    }

    public void setFirebaseRemoteConfigProvider(@Nullable Provider<RemoteConfigComponent> firebaseRemoteConfigProvider) {
        this.firebaseRemoteConfigProvider = firebaseRemoteConfigProvider;
    }

    public Optional<Double> getDouble(String key) {
        block4: {
            if (key == null) {
                logger.debug("The key to get Remote Config double value is null.");
                return Optional.absent();
            }
            FirebaseRemoteConfigValue rcValue = this.getRemoteConfigValue(key);
            if (rcValue != null) {
                try {
                    return Optional.of(rcValue.asDouble());
                }
                catch (IllegalArgumentException e) {
                    if (rcValue.asString().isEmpty()) break block4;
                    logger.debug("Could not parse value: '%s' for key: '%s'.", rcValue.asString(), key);
                }
            }
        }
        return Optional.absent();
    }

    public Optional<Long> getLong(String key) {
        block4: {
            if (key == null) {
                logger.debug("The key to get Remote Config long value is null.");
                return Optional.absent();
            }
            FirebaseRemoteConfigValue rcValue = this.getRemoteConfigValue(key);
            if (rcValue != null) {
                try {
                    return Optional.of(rcValue.asLong());
                }
                catch (IllegalArgumentException e) {
                    if (rcValue.asString().isEmpty()) break block4;
                    logger.debug("Could not parse value: '%s' for key: '%s'.", rcValue.asString(), key);
                }
            }
        }
        return Optional.absent();
    }

    public Optional<Boolean> getBoolean(String key) {
        block4: {
            if (key == null) {
                logger.debug("The key to get Remote Config boolean value is null.");
                return Optional.absent();
            }
            FirebaseRemoteConfigValue rcValue = this.getRemoteConfigValue(key);
            if (rcValue != null) {
                try {
                    return Optional.of(rcValue.asBoolean());
                }
                catch (IllegalArgumentException e) {
                    if (rcValue.asString().isEmpty()) break block4;
                    logger.debug("Could not parse value: '%s' for key: '%s'.", rcValue.asString(), key);
                }
            }
        }
        return Optional.absent();
    }

    public Optional<String> getString(String key) {
        if (key == null) {
            logger.debug("The key to get Remote Config String value is null.");
            return Optional.absent();
        }
        FirebaseRemoteConfigValue rcValue = this.getRemoteConfigValue(key);
        if (rcValue != null) {
            return Optional.of(rcValue.asString());
        }
        return Optional.absent();
    }

    public <T> T getRemoteConfigValueOrDefault(String key, T defaultValue) {
        Object valueToReturn;
        block11: {
            valueToReturn = defaultValue;
            FirebaseRemoteConfigValue rcValue = this.getRemoteConfigValue(key);
            if (rcValue != null) {
                try {
                    if (defaultValue instanceof Boolean) {
                        valueToReturn = rcValue.asBoolean();
                    } else if (defaultValue instanceof Double) {
                        valueToReturn = rcValue.asDouble();
                    } else if (defaultValue instanceof Long || defaultValue instanceof Integer) {
                        valueToReturn = rcValue.asLong();
                    } else if (defaultValue instanceof String) {
                        valueToReturn = rcValue.asString();
                    } else {
                        valueToReturn = rcValue.asString();
                        logger.debug("No matching type found for the defaultValue: '%s', using String.", defaultValue);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (rcValue.asString().isEmpty()) break block11;
                    logger.debug("Could not parse value: '%s' for key: '%s'.", rcValue.asString(), key);
                }
            }
        }
        return valueToReturn;
    }

    private FirebaseRemoteConfigValue getRemoteConfigValue(String key) {
        FirebaseRemoteConfigValue rcValue;
        this.triggerRemoteConfigFetchIfNecessary();
        if (this.isFirebaseRemoteConfigAvailable() && this.allRcConfigMap.containsKey(key) && (rcValue = this.allRcConfigMap.get(key)).getSource() == 2) {
            logger.debug("Fetched value: '%s' for key: '%s' from Firebase Remote Config.", rcValue.asString(), key);
            return rcValue;
        }
        return null;
    }

    public boolean isLastFetchFailed() {
        return this.firebaseRemoteConfig == null || this.firebaseRemoteConfig.getInfo().getLastFetchStatus() == 1 || this.firebaseRemoteConfig.getInfo().getLastFetchStatus() == 2;
    }

    private void triggerRemoteConfigFetchIfNecessary() {
        if (!this.isFirebaseRemoteConfigAvailable()) {
            return;
        }
        if (this.allRcConfigMap.isEmpty()) {
            this.allRcConfigMap.putAll(this.firebaseRemoteConfig.getAll());
        }
        if (this.shouldFetchAndActivateRemoteConfigValues()) {
            this.triggerFirebaseRemoteConfigFetchAndActivateOnSuccessfulFetch();
        }
    }

    private void triggerFirebaseRemoteConfigFetchAndActivateOnSuccessfulFetch() {
        this.firebaseRemoteConfigLastFetchTimestampMs = this.getCurrentSystemTimeMillis();
        this.firebaseRemoteConfig.fetchAndActivate().addOnSuccessListener(this.executor, result -> this.syncConfigValues(this.firebaseRemoteConfig.getAll())).addOnFailureListener(this.executor, ex -> {
            logger.warn("Call to Remote Config failed: %s. This may cause a degraded experience with Firebase Performance. Please reach out to Firebase Support https://firebase.google.com/support/", ex);
            this.firebaseRemoteConfigLastFetchTimestampMs = 0L;
        });
    }

    @VisibleForTesting
    protected void syncConfigValues(Map<String, FirebaseRemoteConfigValue> newlyFetchedMap) {
        this.allRcConfigMap.putAll(newlyFetchedMap);
        for (String existingKey : this.allRcConfigMap.keySet()) {
            if (newlyFetchedMap.containsKey(existingKey)) continue;
            this.allRcConfigMap.remove(existingKey);
        }
        ConfigurationConstants.ExperimentTTID flag = ConfigurationConstants.ExperimentTTID.getInstance();
        FirebaseRemoteConfigValue rcValue = this.allRcConfigMap.get(flag.getRemoteConfigFlag());
        if (rcValue != null) {
            try {
                this.cache.setValue(flag.getDeviceCacheFlag(), rcValue.asBoolean());
            }
            catch (Exception exception) {
                logger.debug("ExperimentTTID remote config flag has invalid value, expected boolean.");
            }
        } else {
            logger.debug("ExperimentTTID remote config flag does not exist.");
        }
    }

    @VisibleForTesting
    protected long getCurrentSystemTimeMillis() {
        return System.currentTimeMillis();
    }

    public boolean isFirebaseRemoteConfigAvailable() {
        RemoteConfigComponent rcComponent;
        if (this.firebaseRemoteConfig == null && this.firebaseRemoteConfigProvider != null && (rcComponent = (RemoteConfigComponent)this.firebaseRemoteConfigProvider.get()) != null) {
            this.firebaseRemoteConfig = rcComponent.get(FIREPERF_FRC_NAMESPACE_NAME);
        }
        return this.firebaseRemoteConfig != null;
    }

    private boolean shouldFetchAndActivateRemoteConfigValues() {
        long currentTimeInMs = this.getCurrentSystemTimeMillis();
        return this.hasAppStartConfigFetchDelayElapsed(currentTimeInMs) && this.hasLastFetchBecomeStale(currentTimeInMs);
    }

    private boolean hasAppStartConfigFetchDelayElapsed(long currentTimeInMs) {
        return currentTimeInMs - this.appStartTimeInMs >= this.appStartConfigFetchDelayInMs;
    }

    private boolean hasLastFetchBecomeStale(long currentTimeInMs) {
        return currentTimeInMs - this.firebaseRemoteConfigLastFetchTimestampMs > TIME_AFTER_WHICH_A_FETCH_IS_CONSIDERED_STALE_MS;
    }

    @VisibleForTesting
    public static int getVersionCode(Context context) {
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            return 0;
        }
    }
}

