/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.session.gauges;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.StorageUnit;
import com.google.firebase.perf.util.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GaugeMetadataManager {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final Runtime runtime;
    private final ActivityManager activityManager;
    private final ActivityManager.MemoryInfo memoryInfo;
    private final Context appContext;

    GaugeMetadataManager(Context appContext) {
        this(Runtime.getRuntime(), appContext);
    }

    @VisibleForTesting
    GaugeMetadataManager(Runtime runtime, Context appContext) {
        this.runtime = runtime;
        this.appContext = appContext;
        this.activityManager = (ActivityManager)appContext.getSystemService("activity");
        this.memoryInfo = new ActivityManager.MemoryInfo();
        this.activityManager.getMemoryInfo(this.memoryInfo);
    }

    public int getMaxAppJavaHeapMemoryKb() {
        return Utils.saturatedIntCast(StorageUnit.BYTES.toKilobytes(this.runtime.maxMemory()));
    }

    public int getMaxEncouragedAppJavaHeapMemoryKb() {
        return Utils.saturatedIntCast(StorageUnit.MEGABYTES.toKilobytes(this.activityManager.getMemoryClass()));
    }

    public int getDeviceRamSizeKb() {
        if (Build.VERSION.SDK_INT >= 16) {
            return Utils.saturatedIntCast(StorageUnit.BYTES.toKilobytes(this.memoryInfo.totalMem));
        }
        return this.readTotalRAM("/proc/meminfo");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    int readTotalRAM(String procFileName) {
        try (BufferedReader br = new BufferedReader(new FileReader(procFileName));){
            String s = br.readLine();
            while (s != null) {
                if (s.startsWith("MemTotal")) {
                    Matcher m = Pattern.compile("\\d+").matcher(s);
                    int n = m.find() ? Integer.parseInt(m.group()) : 0;
                    return n;
                }
                s = br.readLine();
            }
            return 0;
        }
        catch (IOException ioe) {
            logger.warn("Unable to read '" + procFileName + "' file: " + ioe.getMessage());
            return 0;
        }
        catch (NumberFormatException nfe) {
            logger.warn("Unable to parse '" + procFileName + "' file: " + nfe.getMessage());
        }
        return 0;
    }
}

