/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.application;

import android.app.Activity;
import android.os.Build;
import android.util.SparseIntArray;
import androidx.core.app.FrameMetricsAggregator;
import androidx.fragment.app.Fragment;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.FrameMetricsCalculator;
import com.google.firebase.perf.util.Optional;
import java.util.HashMap;
import java.util.Map;

public class FrameMetricsRecorder {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final String FRAME_METRICS_AGGREGATOR_CLASSNAME = "androidx.core.app.FrameMetricsAggregator";
    private final Activity activity;
    private final FrameMetricsAggregator frameMetricsAggregator;
    private final Map<Fragment, FrameMetricsCalculator.PerfFrameMetrics> fragmentSnapshotMap;
    private boolean isRecording = false;

    static boolean isFrameMetricsRecordingSupported() {
        try {
            Class<?> initializerClass = Class.forName(FRAME_METRICS_AGGREGATOR_CLASSNAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public FrameMetricsRecorder(Activity activity) {
        this(activity, new FrameMetricsAggregator(), new HashMap<Fragment, FrameMetricsCalculator.PerfFrameMetrics>());
    }

    @VisibleForTesting
    FrameMetricsRecorder(Activity activity, FrameMetricsAggregator frameMetricsAggregator, Map<Fragment, FrameMetricsCalculator.PerfFrameMetrics> subTraceMap) {
        this.activity = activity;
        this.frameMetricsAggregator = frameMetricsAggregator;
        this.fragmentSnapshotMap = subTraceMap;
    }

    public void start() {
        if (this.isRecording) {
            logger.debug("FrameMetricsAggregator is already recording %s", this.activity.getClass().getSimpleName());
            return;
        }
        this.frameMetricsAggregator.add(this.activity);
        this.isRecording = true;
    }

    public Optional<FrameMetricsCalculator.PerfFrameMetrics> stop() {
        if (!this.isRecording) {
            logger.debug("Cannot stop because no recording was started");
            return Optional.absent();
        }
        if (!this.fragmentSnapshotMap.isEmpty()) {
            logger.debug("Sub-recordings are still ongoing! Sub-recordings should be stopped first before stopping Activity screen trace.");
            this.fragmentSnapshotMap.clear();
        }
        Optional<FrameMetricsCalculator.PerfFrameMetrics> data = this.snapshot();
        try {
            this.frameMetricsAggregator.remove(this.activity);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            if (ex instanceof NullPointerException && Build.VERSION.SDK_INT > 28) {
                throw ex;
            }
            logger.warn("View not hardware accelerated. Unable to collect FrameMetrics. %s", ex.toString());
            data = Optional.absent();
        }
        this.frameMetricsAggregator.reset();
        this.isRecording = false;
        return data;
    }

    public void startFragment(Fragment fragment) {
        if (!this.isRecording) {
            logger.debug("Cannot start sub-recording because FrameMetricsAggregator is not recording");
            return;
        }
        if (this.fragmentSnapshotMap.containsKey(fragment)) {
            logger.debug("Cannot start sub-recording because one is already ongoing with the key %s", fragment.getClass().getSimpleName());
            return;
        }
        Optional<FrameMetricsCalculator.PerfFrameMetrics> snapshot = this.snapshot();
        if (!snapshot.isAvailable()) {
            logger.debug("startFragment(%s): snapshot() failed", fragment.getClass().getSimpleName());
            return;
        }
        this.fragmentSnapshotMap.put(fragment, snapshot.get());
    }

    public Optional<FrameMetricsCalculator.PerfFrameMetrics> stopFragment(Fragment fragment) {
        if (!this.isRecording) {
            logger.debug("Cannot stop sub-recording because FrameMetricsAggregator is not recording");
            return Optional.absent();
        }
        if (!this.fragmentSnapshotMap.containsKey(fragment)) {
            logger.debug("Sub-recording associated with key %s was not started or does not exist", fragment.getClass().getSimpleName());
            return Optional.absent();
        }
        FrameMetricsCalculator.PerfFrameMetrics snapshotStart = this.fragmentSnapshotMap.remove(fragment);
        Optional<FrameMetricsCalculator.PerfFrameMetrics> snapshotEnd = this.snapshot();
        if (!snapshotEnd.isAvailable()) {
            logger.debug("stopFragment(%s): snapshot() failed", fragment.getClass().getSimpleName());
            return Optional.absent();
        }
        return Optional.of(snapshotEnd.get().deltaFrameMetricsFromSnapshot(snapshotStart));
    }

    private Optional<FrameMetricsCalculator.PerfFrameMetrics> snapshot() {
        if (!this.isRecording) {
            logger.debug("No recording has been started.");
            return Optional.absent();
        }
        SparseIntArray[] arr = this.frameMetricsAggregator.getMetrics();
        if (arr == null) {
            logger.debug("FrameMetricsAggregator.mMetrics is uninitialized.");
            return Optional.absent();
        }
        SparseIntArray frameTimes = arr[0];
        if (frameTimes == null) {
            logger.debug("FrameMetricsAggregator.mMetrics[TOTAL_INDEX] is uninitialized.");
            return Optional.absent();
        }
        return Optional.of(FrameMetricsCalculator.calculateFrameMetrics(arr));
    }
}

