/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import com.google.firebase.perf.metrics.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import java.io.OutputStream;

public final class InstrHttpOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    private final Timer timer;
    NetworkRequestMetricBuilder networkMetricBuilder;
    long bytesWritten = -1L;

    public InstrHttpOutputStream(OutputStream outputStream, NetworkRequestMetricBuilder builder, Timer timer) {
        this.outputStream = outputStream;
        this.networkMetricBuilder = builder;
        this.timer = timer;
    }

    @Override
    public void close() throws IOException {
        if (this.bytesWritten != -1L) {
            this.networkMetricBuilder.setRequestPayloadBytes(this.bytesWritten);
        }
        this.networkMetricBuilder.setTimeToRequestCompletedMicros(this.timer.getDurationMicros());
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.outputStream.write(b);
            ++this.bytesWritten;
            this.networkMetricBuilder.setRequestPayloadBytes(this.bytesWritten);
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.outputStream.write(b);
            this.bytesWritten += (long)b.length;
            this.networkMetricBuilder.setRequestPayloadBytes(this.bytesWritten);
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.outputStream.write(b, off, len);
            this.bytesWritten += (long)len;
            this.networkMetricBuilder.setRequestPayloadBytes(this.bytesWritten);
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }
}

