/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.NonNull;
import com.google.firebase.perf.logging.AndroidLogger;
import java.net.URI;

public class URLAllowlist {
    private static String[] allowlistedDomains;

    public static boolean isURLAllowlisted(@NonNull URI uri, @NonNull Context appContext) {
        String host;
        Resources resources = appContext.getResources();
        int resourceId = resources.getIdentifier("firebase_performance_whitelisted_domains", "array", appContext.getPackageName());
        if (resourceId == 0) {
            return true;
        }
        AndroidLogger.getInstance().debug("Detected domain allowlist, only allowlisted domains will be measured.");
        if (allowlistedDomains == null) {
            allowlistedDomains = resources.getStringArray(resourceId);
        }
        if ((host = uri.getHost()) == null) {
            return true;
        }
        for (String allowlistedDomain : allowlistedDomains) {
            if (!host.contains(allowlistedDomain)) continue;
            return true;
        }
        return false;
    }
}

