/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.perf.FirebasePerformanceAttributable;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.NetworkRequestMetricBuilder;
import com.google.firebase.perf.metrics.validator.PerfMetricValidator;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Timer;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpMetric
implements FirebasePerformanceAttributable {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final NetworkRequestMetricBuilder networkMetricBuilder;
    private final Timer timer;
    private final Map<String, String> customAttributesMap = new ConcurrentHashMap<String, String>();
    private boolean isStopped = false;
    private boolean isDisabled = false;

    public HttpMetric(String url, String httpMethod, TransportManager transportManager, Timer timer) {
        this.timer = timer;
        this.networkMetricBuilder = NetworkRequestMetricBuilder.builder(transportManager).setUrl(url).setHttpMethod(httpMethod);
        this.networkMetricBuilder.setManualNetworkRequestMetric();
        if (!ConfigResolver.getInstance().isPerformanceMonitoringEnabled()) {
            logger.info("HttpMetric feature is disabled. URL %s", url);
            this.isDisabled = true;
        }
    }

    public HttpMetric(URL url, String httpMethod, TransportManager transportManager, Timer timer) {
        this(url.toString(), httpMethod, transportManager, timer);
    }

    public void setHttpResponseCode(int responseCode) {
        this.networkMetricBuilder.setHttpResponseCode(responseCode);
    }

    public void setRequestPayloadSize(long bytes) {
        this.networkMetricBuilder.setRequestPayloadBytes(bytes);
    }

    public void setResponsePayloadSize(long bytes) {
        this.networkMetricBuilder.setResponsePayloadBytes(bytes);
    }

    public void setResponseContentType(@Nullable String contentType) {
        this.networkMetricBuilder.setResponseContentType(contentType);
    }

    public void start() {
        this.timer.reset();
        this.networkMetricBuilder.setRequestStartTimeMicros(this.timer.getMicros());
    }

    public void markRequestComplete() {
        this.networkMetricBuilder.setTimeToRequestCompletedMicros(this.timer.getDurationMicros());
    }

    public void markResponseStart() {
        this.networkMetricBuilder.setTimeToResponseInitiatedMicros(this.timer.getDurationMicros());
    }

    public void stop() {
        if (this.isDisabled) {
            return;
        }
        this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros()).setCustomAttributes(this.customAttributesMap).build();
        this.isStopped = true;
    }

    @Override
    public void putAttribute(@NonNull String attribute, @NonNull String value) {
        boolean noError = true;
        try {
            attribute = attribute.trim();
            value = value.trim();
            this.checkAttribute(attribute, value);
            logger.debug("Setting attribute '%s' to %s on network request '%s'", attribute, value, this.networkMetricBuilder.getUrl());
        }
        catch (Exception e) {
            logger.error("Cannot set attribute '%s' with value '%s' (%s)", attribute, value, e.getMessage());
            noError = false;
        }
        if (noError) {
            this.customAttributesMap.put(attribute, value);
        }
    }

    private void checkAttribute(@Nullable String attribute, @Nullable String value) {
        if (this.isStopped) {
            throw new IllegalArgumentException("HttpMetric has been logged already so unable to modify attributes");
        }
        if (attribute == null || value == null) {
            throw new IllegalArgumentException("Attribute must not have null key or value.");
        }
        if (!this.customAttributesMap.containsKey(attribute) && this.customAttributesMap.size() >= 5) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Exceeds max limit of number of attributes - %d", 5));
        }
        String err = PerfMetricValidator.validateAttribute(new AbstractMap.SimpleEntry<String, String>(attribute, value));
        if (err != null) {
            throw new IllegalArgumentException(err);
        }
    }

    @Override
    public void removeAttribute(@NonNull String attribute) {
        if (this.isStopped) {
            logger.error("Can't remove a attribute from a HttpMetric that's stopped.");
            return;
        }
        this.customAttributesMap.remove(attribute);
    }

    @Override
    @Nullable
    public String getAttribute(@NonNull String attribute) {
        return this.customAttributesMap.get(attribute);
    }

    @Override
    @NonNull
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.customAttributesMap);
    }
}

