/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.logging;

public final class ConsoleUrlGenerator {
    private static final String URL_BASE_PATH = "https://console.firebase.google.com";
    private static final String UTM_MEDIUM = "android-ide";
    private static final String UTM_SOURCE = "perf-android-sdk";

    public static String generateDashboardUrl(String projectId, String packageName) {
        String rootUrl = ConsoleUrlGenerator.getRootUrl(projectId, packageName);
        return String.format("%s/trends?utm_source=%s&utm_medium=%s", rootUrl, UTM_SOURCE, UTM_MEDIUM);
    }

    public static String generateCustomTraceUrl(String projectId, String packageName, String name) {
        String rootUrl = ConsoleUrlGenerator.getRootUrl(projectId, packageName);
        return String.format("%s/metrics/trace/DURATION_TRACE/%s?utm_source=%s&utm_medium=%s", rootUrl, name, UTM_SOURCE, UTM_MEDIUM);
    }

    public static String generateScreenTraceUrl(String projectId, String packageName, String name) {
        String rootUrl = ConsoleUrlGenerator.getRootUrl(projectId, packageName);
        return String.format("%s/metrics/trace/SCREEN_TRACE/%s?utm_source=%s&utm_medium=%s", rootUrl, name, UTM_SOURCE, UTM_MEDIUM);
    }

    private static String getRootUrl(String projectId, String packageName) {
        return String.format("%s/project/%s/performance/app/android:%s", URL_BASE_PATH, projectId, packageName);
    }
}

