/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zzav;
import com.google.android.gms.internal.firebase-perf.zzax;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.firebase.perf.internal.GaugeManager;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.internal.zzb;
import com.google.firebase.perf.internal.zzq;
import com.google.firebase.perf.internal.zzs;
import com.google.firebase.perf.internal.zzt;
import com.google.firebase.perf.metrics.zza;
import com.google.firebase.perf.metrics.zzc;
import com.google.firebase.perf.metrics.zzd;
import com.google.firebase.perf.metrics.zze;
import com.google.firebase.perf.metrics.zzf;
import com.google.firebase.perf.metrics.zzg;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Trace
extends zzb
implements Parcelable {
    private static final Map<String, Trace> zzgn = new ConcurrentHashMap<String, Trace>();
    private final Trace zzgo;
    private final GaugeManager zzbk;
    private final String name;
    private final List<zzt> zzbj;
    private final List<Trace> zzgp;
    private final Map<String, zza> zzgq;
    private final zzav zzgr;
    private final com.google.firebase.perf.internal.zzd zzco;
    private final Map<String, String> zzgs;
    private zzbg zzgt;
    private zzbg zzgu;
    private BroadcastReceiver zzbp = new zzc(this);
    @Keep
    public static final Parcelable.Creator<Trace> CREATOR = new zzd();
    @VisibleForTesting
    private static final Parcelable.Creator<Trace> zzgv = new zze();

    @NonNull
    public static Trace zzi(@NonNull String string) {
        return new Trace(string);
    }

    private Trace(@NonNull String string) {
        this(string, com.google.firebase.perf.internal.zzd.zzbc(), new zzav(), com.google.firebase.perf.internal.zza.zzak(), GaugeManager.zzbf());
    }

    public Trace(@NonNull String string, @NonNull com.google.firebase.perf.internal.zzd zzd2, @NonNull zzav zzav2, @NonNull com.google.firebase.perf.internal.zza zza2) {
        this(string, zzd2, zzav2, zza2, GaugeManager.zzbf());
    }

    private Trace(@NonNull String string, @NonNull com.google.firebase.perf.internal.zzd zzd2, @NonNull zzav zzav2, @NonNull com.google.firebase.perf.internal.zza zza2, @NonNull GaugeManager gaugeManager) {
        super(zza2);
        this.zzgo = null;
        this.name = string.trim();
        this.zzgp = new ArrayList<Trace>();
        this.zzgq = new ConcurrentHashMap<String, zza>();
        this.zzgs = new ConcurrentHashMap<String, String>();
        this.zzgr = zzav2;
        this.zzco = zzd2;
        this.zzbj = new ArrayList<zzt>();
        this.zzbk = gaugeManager;
    }

    /*
     * Unable to fully structure code
     */
    @Keep
    public void start() {
        block8: {
            block9: {
                block7: {
                    var3_1 = this.name;
                    if (var3_1 != null) break block7;
                    v0 = "Trace name must not be null";
                    break block8;
                }
                if (var3_1.length() <= 100) break block9;
                v0 = String.format(Locale.US, "Trace name must not exceed %d characters", new Object[]{100});
                break block8;
            }
            if (!var3_1.startsWith("_")) ** GOTO lbl-1000
            var4_2 = zzax.values();
            var5_3 = var4_2.length;
            for (var6_4 = 0; var6_4 < var5_3; ++var6_4) {
                if (!var4_2[var6_4].toString().equals(var3_1)) {
                    continue;
                }
                ** GOTO lbl-1000
            }
            if (!var3_1.startsWith("_st_")) {
                v0 = "Trace name must not start with '_'";
            } else lbl-1000:
            // 3 sources

            {
                v0 = var1_5 = null;
            }
        }
        if (v0 != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Cannot start trace %s. Trace name is invalid.(%s)", new Object[]{this.name, var1_5}));
            return;
        }
        if (this.zzgt != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has already started, should not start again!", new Object[]{this.name}));
            return;
        }
        this.zzap();
        var2_6 = SessionManager.zzcn().zzco();
        this.zzbj.add(var2_6);
        this.zzgt = new zzbg();
        Log.i((String)"FirebasePerformance", (String)String.format("Session ID - %s", new Object[]{var2_6.zzbp()}));
        LocalBroadcastManager.getInstance((Context)SessionManager.zzcp()).registerReceiver(this.zzbp, new IntentFilter("SessionIdUpdate"));
        if (var2_6.zzbq()) {
            this.zzbk.zzbh();
        }
    }

    @Keep
    public void stop() {
        if (!this.hasStarted()) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has not been started so unable to stop!", this.name));
            return;
        }
        if (this.isStopped()) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has already stopped, should not stop again!", this.name));
            return;
        }
        SessionManager.zzcn();
        LocalBroadcastManager.getInstance((Context)SessionManager.zzcp()).unregisterReceiver(this.zzbp);
        this.zzaq();
        this.zzgu = new zzbg();
        if (this.zzgo == null) {
            zzbg zzbg2 = this.zzgu;
            Trace trace = this;
            if (!trace.zzgp.isEmpty()) {
                int n = trace.zzgp.size() - 1;
                Trace trace2 = trace.zzgp.get(n);
                if (trace2.zzgu == null) {
                    trace2.zzgu = zzbg2;
                }
            }
            if (!this.name.isEmpty()) {
                if (this.zzco != null) {
                    this.zzco.zza(new zzg(this).zzcy(), this.zzam());
                    if (SessionManager.zzcn().zzco().zzbq()) {
                        this.zzbk.zzbh();
                        return;
                    }
                }
            } else {
                Log.e((String)"FirebasePerformance", (String)"Trace name is empty, no log is sent to server");
            }
        }
    }

    @NonNull
    private final zza zzj(@NonNull String string) {
        zza zza2 = this.zzgq.get(string);
        if (zza2 == null) {
            zza2 = new zza(string);
            this.zzgq.put(string, zza2);
        }
        return zza2;
    }

    @Deprecated
    @Keep
    public void incrementCounter(@NonNull String string, long l) {
        this.zza(string, l, zzs.zzec);
    }

    private final void zza(String string, long l, int n) {
        String string2 = zzq.zza(string, n);
        if (string2 != null) {
            switch (zzf.zzeb[n - 1]) {
                case 1: {
                    Log.e((String)"FirebasePerformance", (String)String.format("Cannot increment counter %s. Counter name is invalid.(%s)", string, string2));
                    return;
                }
                case 2: {
                    Log.e((String)"FirebasePerformance", (String)String.format("Cannot increment metric %s. Metric name is invalid.(%s)", string, string2));
                }
            }
            return;
        }
        if (!this.hasStarted()) {
            switch (zzf.zzeb[n - 1]) {
                case 1: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment counter '%s' for trace '%s' because it's not started", string, this.name));
                    return;
                }
                case 2: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment metric '%s' for trace '%s' because it's not started", string, this.name));
                }
            }
            return;
        }
        if (this.isStopped()) {
            switch (zzf.zzeb[n - 1]) {
                case 1: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment counter '%s' for trace '%s' because it's been stopped", string, this.name));
                    return;
                }
                case 2: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment metric '%s' for trace '%s' because it's been stopped", string, this.name));
                }
            }
            return;
        }
        this.zzj(string.trim()).zzn(l);
    }

    @Deprecated
    @Keep
    public void incrementCounter(@NonNull String string) {
        this.incrementCounter(string, 1L);
    }

    @Keep
    public void incrementMetric(@NonNull String string, long l) {
        this.zza(string, l, zzs.zzed);
    }

    @Keep
    public long getLongMetric(@NonNull String string) {
        zza zza2 = null;
        if (string != null) {
            zza2 = this.zzgq.get(string.trim());
        }
        if (zza2 == null) {
            return 0L;
        }
        return zza2.getCount();
    }

    @Keep
    public void putMetric(@NonNull String string, long l) {
        String string2 = zzq.zza(string, zzs.zzed);
        if (string2 != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Cannot set value for metric %s. Metric name is invalid.(%s)", string, string2));
            return;
        }
        if (!this.hasStarted()) {
            Log.w((String)"FirebasePerformance", (String)String.format("Cannot set value for metric '%s' for trace '%s' because it's not started", string, this.name));
            return;
        }
        if (this.isStopped()) {
            Log.w((String)"FirebasePerformance", (String)String.format("Cannot set value for metric '%s' for trace '%s' because it's been stopped", string, this.name));
            return;
        }
        this.zzj(string.trim()).zzo(l);
    }

    protected void finalize() throws Throwable {
        try {
            Trace trace = this;
            if (trace.hasStarted() && !trace.isStopped()) {
                Log.w((String)"FirebasePerformance", (String)String.format("Trace '%s' is started but not stopped when it is destructed!", this.name));
                this.zzc(1);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @VisibleForTesting
    @NonNull
    final String getName() {
        return this.name;
    }

    @VisibleForTesting
    @NonNull
    final Map<String, zza> zzct() {
        return this.zzgq;
    }

    @VisibleForTesting
    final zzbg zzcu() {
        return this.zzgt;
    }

    @VisibleForTesting
    final zzbg zzcv() {
        return this.zzgu;
    }

    @VisibleForTesting
    @NonNull
    final List<Trace> zzcw() {
        return this.zzgp;
    }

    @VisibleForTesting
    final boolean isStopped() {
        return this.zzgu != null;
    }

    @VisibleForTesting
    final boolean hasStarted() {
        return this.zzgt != null;
    }

    @Keep
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        parcel.writeParcelable((Parcelable)this.zzgo, 0);
        parcel.writeString(this.name);
        parcel.writeList(this.zzgp);
        parcel.writeMap(this.zzgq);
        parcel.writeParcelable((Parcelable)this.zzgt, 0);
        parcel.writeParcelable((Parcelable)this.zzgu, 0);
        parcel.writeList(this.zzbj);
    }

    private Trace(@NonNull Parcel parcel, boolean bl) {
        super(bl ? null : com.google.firebase.perf.internal.zza.zzak());
        this.zzgo = (Trace)parcel.readParcelable(Trace.class.getClassLoader());
        this.name = parcel.readString();
        this.zzgp = new ArrayList<Trace>();
        parcel.readList(this.zzgp, Trace.class.getClassLoader());
        this.zzgq = new ConcurrentHashMap<String, zza>();
        this.zzgs = new ConcurrentHashMap<String, String>();
        parcel.readMap(this.zzgq, zza.class.getClassLoader());
        this.zzgt = (zzbg)parcel.readParcelable(zzbg.class.getClassLoader());
        this.zzgu = (zzbg)parcel.readParcelable(zzbg.class.getClassLoader());
        this.zzbj = new ArrayList<zzt>();
        parcel.readList(this.zzbj, zzt.class.getClassLoader());
        if (bl) {
            this.zzco = null;
            this.zzgr = null;
            this.zzbk = null;
            return;
        }
        this.zzco = com.google.firebase.perf.internal.zzd.zzbc();
        this.zzgr = new zzav();
        this.zzbk = GaugeManager.zzbf();
    }

    @Keep
    public void putAttribute(@NonNull String string, @NonNull String string2) {
        boolean bl = true;
        try {
            string = string.trim();
            String string3 = string2 = string2.trim();
            String string4 = string;
            Trace trace = this;
            if (trace.isStopped()) {
                throw new IllegalArgumentException(String.format(Locale.US, "Trace %s has been stopped", trace.name));
            }
            if (!trace.zzgs.containsKey(string4) && trace.zzgs.size() >= 5) {
                throw new IllegalArgumentException(String.format(Locale.US, "Exceeds max limit of number of attributes - %d", 5));
            }
            String string5 = zzq.zza(new AbstractMap.SimpleEntry<String, String>(string4, string3));
            if (string5 != null) {
                throw new IllegalArgumentException(string5);
            }
        }
        catch (Exception exception) {
            Log.e((String)"FirebasePerformance", (String)String.format("Can not set attribute %s with value %s (%s)", string, string2, exception.getMessage()));
            bl = false;
        }
        if (bl) {
            this.zzgs.put(string, string2);
        }
    }

    @Keep
    public void removeAttribute(@NonNull String string) {
        if (this.isStopped()) {
            Log.e((String)"FirebasePerformance", (String)"Can't remove a attribute from a Trace that's stopped.");
            return;
        }
        this.zzgs.remove(string);
    }

    @Nullable
    @Keep
    public String getAttribute(@NonNull String string) {
        return this.zzgs.get(string);
    }

    @NonNull
    @Keep
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzgs);
    }

    @Keep
    public int describeContents() {
        return 0;
    }

    @VisibleForTesting
    public final List<zzt> zzcx() {
        return this.zzbj;
    }

    static /* synthetic */ List zza(Trace trace) {
        return trace.zzbj;
    }

    /* synthetic */ Trace(Parcel parcel, boolean bl, zzc zzc2) {
        this(parcel, bl);
    }
}

