/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzat;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.firebase.perf.internal.zzd;
import com.google.firebase.perf.internal.zzq;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpMetric {
    private zzat zzgj;
    private zzbg zzgk;
    private final Map<String, String> zzgl;
    private boolean zzgm = false;

    public HttpMetric(String string, String string2, zzd zzd2, zzbg zzbg2) {
        this.zzgj = zzat.zza(zzd2);
        this.zzgj.zza(string);
        this.zzgj.zzb(string2);
        this.zzgk = zzbg2;
        this.zzgj.zzaf();
        this.zzgl = new ConcurrentHashMap<String, String>();
    }

    public HttpMetric(URL uRL, String string, zzd zzd2, zzbg zzbg2) {
        this.zzgj = zzat.zza(zzd2);
        this.zzgj.zza(uRL.toString());
        this.zzgj.zzb(string);
        this.zzgk = zzbg2;
        this.zzgj.zzaf();
        this.zzgl = new ConcurrentHashMap<String, String>();
    }

    public void setHttpResponseCode(int n) {
        this.zzgj.zzb(n);
    }

    public void setRequestPayloadSize(long l) {
        this.zzgj.zzf(l);
    }

    public void setResponsePayloadSize(long l) {
        this.zzgj.zzk(l);
    }

    public void setResponseContentType(@Nullable String string) {
        this.zzgj.zzc(string);
    }

    public void start() {
        this.zzgk.reset();
        this.zzgj.zzg(this.zzgk.zzdb());
    }

    public void stop() {
        this.zzgj.zzj(this.zzgk.zzdc());
        this.zzgj.zzb(this.zzgl);
        this.zzgj.zzaj();
        this.zzgm = true;
    }

    public void putAttribute(@NonNull String string, @NonNull String string2) {
        boolean bl = true;
        try {
            string = string.trim();
            String string3 = string2 = string2.trim();
            String string4 = string;
            HttpMetric httpMetric = this;
            if (httpMetric.zzgm) {
                throw new IllegalArgumentException("HttpMetric has been logged already so unable to modify attributes");
            }
            if (string4 == null || string3 == null) {
                throw new IllegalArgumentException("Attribute must not have null key or value.");
            }
            if (!httpMetric.zzgl.containsKey(string4) && httpMetric.zzgl.size() >= 5) {
                throw new IllegalArgumentException(String.format(Locale.US, "Exceeds max limit of number of attributes - %d", 5));
            }
            String string5 = zzq.zza(new AbstractMap.SimpleEntry<String, String>(string4, string3));
            if (string5 != null) {
                throw new IllegalArgumentException(string5);
            }
        }
        catch (Exception exception) {
            Log.e((String)"FirebasePerformance", (String)String.format("Can not set attribute %s with value %s (%s)", string, string2, exception.getMessage()));
            bl = false;
        }
        if (bl) {
            this.zzgl.put(string, string2);
        }
    }

    public void removeAttribute(@NonNull String string) {
        if (this.zzgm) {
            Log.e((String)"FirebasePerformance", (String)"Can't remove a attribute from a HttpMetric that's stopped.");
            return;
        }
        this.zzgl.remove(string);
    }

    @Nullable
    public String getAttribute(@NonNull String string) {
        return this.zzgl.get(string);
    }

    @NonNull
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzgl);
    }
}

