/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.support.annotation.Keep;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzag;
import com.google.android.gms.internal.firebase-perf.zzay;
import com.google.firebase.perf.FirebasePerformance;
import com.google.firebase.perf.internal.RemoteConfigManager;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Keep
public class FeatureControl {
    @Nullable
    private static FeatureControl zzcj = null;
    private final RemoteConfigManager zzck = RemoteConfigManager.zzcb();
    private final zzay zzcl;
    private static final long zzcm = TimeUnit.HOURS.toMinutes(4L);

    private FeatureControl() {
        FirebasePerformance firebasePerformance = FirebasePerformance.getInstance();
        if (firebasePerformance == null) {
            Log.d((String)"FirebasePerformance", (String)"Firebase Performance not initialized in time for FeatureControl to use.");
            this.zzcl = new zzay();
            return;
        }
        this.zzcl = firebasePerformance.zzr();
    }

    public static synchronized FeatureControl zzar() {
        if (zzcj == null) {
            zzcj = new FeatureControl();
        }
        return zzcj;
    }

    public final boolean zzas() {
        return this.zzb("sessions_feature_enabled", 1L) != 0L;
    }

    public final boolean zzat() {
        return this.zzb("sessions_cpu_capture_enabled", 1L) != 0L;
    }

    public final boolean zzau() {
        return this.zzb("sessions_memory_capture_enabled", 1L) != 0L;
    }

    public final float zzav() {
        String string = "sessions_sampling_percentage";
        FeatureControl featureControl = this;
        float f = featureControl.zzck.zza(string, 1.0f);
        return featureControl.zzcl.getFloat(string, f);
    }

    public final long zzaw() {
        return this.zzb("sessions_cpu_capture_frequency_fg_ms", 100L);
    }

    public final long zzax() {
        return this.zzb("sessions_memory_capture_frequency_fg_ms", 100L);
    }

    public final long zzay() {
        return this.zzb("sessions_cpu_capture_frequency_bg_ms", 0L);
    }

    public final long zzaz() {
        return this.zzb("sessions_memory_capture_frequency_bg_ms", 0L);
    }

    public final long zzba() {
        return this.zzb("sessions_max_length_minutes", zzcm);
    }

    private final long zzb(String string, long l) {
        int n = zzag.zza(this.zzck.zzc(string, l));
        int n2 = this.zzcl.getInt(string, n);
        if (n2 == Integer.MAX_VALUE || n2 == Integer.MIN_VALUE) {
            return l;
        }
        return n2;
    }
}

