/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.tasks.Task;
import java.util.Map;
import java.util.concurrent.Executor;

class RequestDeduplicator {
    private final Executor executor;
    @GuardedBy(value="this")
    private final Map<String, Task<String>> getTokenRequests = new ArrayMap();

    RequestDeduplicator(Executor executor) {
        this.executor = executor;
    }

    synchronized Task<String> getOrStartGetTokenRequest(String authorizedEntity, GetTokenRequest request) {
        Task<String> ongoingTask = this.getTokenRequests.get(authorizedEntity);
        if (ongoingTask != null) {
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)("Joining ongoing request for: " + authorizedEntity));
            }
            return ongoingTask;
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)("Making new request for: " + authorizedEntity));
        }
        Task newTask = request.start().continueWithTask(this.executor, task -> {
            RequestDeduplicator requestDeduplicator = this;
            synchronized (requestDeduplicator) {
                this.getTokenRequests.remove(authorizedEntity);
            }
            return task;
        });
        this.getTokenRequests.put(authorizedEntity, (Task<String>)newTask);
        return newTask;
    }

    static interface GetTokenRequest {
        public Task<String> start();
    }
}

