/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.internal.FirebaseInstanceIdInternal;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.FcmBroadcastProcessor;
import com.google.firebase.messaging.FcmExecutors;
import com.google.firebase.messaging.FcmLifecycleCallbacks;
import com.google.firebase.messaging.GmsRpc;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.Metadata;
import com.google.firebase.messaging.ProxyNotificationInitializer;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.RequestDeduplicator;
import com.google.firebase.messaging.Store;
import com.google.firebase.messaging.SyncTask;
import com.google.firebase.messaging.TopicsSubscriber;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class FirebaseMessaging {
    static final String TAG = "FirebaseMessaging";
    static final String GMS_PACKAGE = "com.google.android.gms";
    private static final String SEND_INTENT_ACTION = "com.google.android.gcm.intent.SEND";
    private static final String EXTRA_DUMMY_P_INTENT = "app";
    @Deprecated
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private static final long MIN_DELAY_SEC = 30L;
    private static final long MAX_DELAY_SEC = TimeUnit.HOURS.toSeconds(8L);
    private static final String SUBTYPE_DEFAULT = "";
    @GuardedBy(value="FirebaseMessaging.class")
    private static Store store;
    private final FirebaseApp firebaseApp;
    @Nullable
    private final FirebaseInstanceIdInternal iid;
    private final FirebaseInstallationsApi fis;
    private final Context context;
    private final GmsRpc gmsRpc;
    private final RequestDeduplicator requestDeduplicator;
    private final AutoInit autoInit;
    private final Executor initExecutor;
    private final Executor taskExecutor;
    private final Executor fileExecutor;
    private final Task<TopicsSubscriber> topicsSubscriberTask;
    private final Metadata metadata;
    @GuardedBy(value="this")
    private boolean syncScheduledOrRunning = false;
    private final Application.ActivityLifecycleCallbacks lifecycleCallbacks;
    @Nullable
    @SuppressLint(value={"FirebaseUnknownNullness"})
    @VisibleForTesting
    static TransportFactory transportFactory;
    @GuardedBy(value="FirebaseMessaging.class")
    @VisibleForTesting
    static ScheduledExecutorService syncExecutor;

    @NonNull
    public static synchronized FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    @NonNull
    private static synchronized Store getStore(Context context) {
        if (store == null) {
            store = new Store(context);
        }
        return store;
    }

    @VisibleForTesting
    static synchronized void clearStoreForTest() {
        store = null;
    }

    @Keep
    @NonNull
    static synchronized FirebaseMessaging getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseMessaging firebaseMessaging = (FirebaseMessaging)firebaseApp.get(FirebaseMessaging.class);
        Preconditions.checkNotNull((Object)firebaseMessaging, (Object)"Firebase Messaging component is not present");
        return firebaseMessaging;
    }

    FirebaseMessaging(FirebaseApp firebaseApp, @Nullable FirebaseInstanceIdInternal iid, Provider<UserAgentPublisher> userAgentPublisher, Provider<HeartBeatInfo> heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory, Subscriber subscriber) {
        this(firebaseApp, iid, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi, transportFactory, subscriber, new Metadata(firebaseApp.getApplicationContext()));
    }

    FirebaseMessaging(FirebaseApp firebaseApp, @Nullable FirebaseInstanceIdInternal iid, Provider<UserAgentPublisher> userAgentPublisher, Provider<HeartBeatInfo> heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory, Subscriber subscriber, Metadata metadata) {
        this(firebaseApp, iid, firebaseInstallationsApi, transportFactory, subscriber, metadata, new GmsRpc(firebaseApp, metadata, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi), FcmExecutors.newTaskExecutor(), FcmExecutors.newInitExecutor(), FcmExecutors.newFileIOExecutor());
    }

    FirebaseMessaging(FirebaseApp firebaseApp, @Nullable FirebaseInstanceIdInternal iid, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory, Subscriber subscriber, Metadata metadata, GmsRpc gmsRpc, Executor taskExecutor, Executor initExecutor, Executor fileExecutor) {
        FirebaseMessaging.transportFactory = transportFactory;
        this.firebaseApp = firebaseApp;
        this.iid = iid;
        this.fis = firebaseInstallationsApi;
        this.autoInit = new AutoInit(subscriber);
        this.context = firebaseApp.getApplicationContext();
        this.lifecycleCallbacks = new FcmLifecycleCallbacks();
        this.metadata = metadata;
        this.taskExecutor = taskExecutor;
        this.gmsRpc = gmsRpc;
        this.requestDeduplicator = new RequestDeduplicator(taskExecutor);
        this.initExecutor = initExecutor;
        this.fileExecutor = fileExecutor;
        Context appContext = firebaseApp.getApplicationContext();
        if (appContext instanceof Application) {
            Application app = (Application)appContext;
            app.registerActivityLifecycleCallbacks(this.lifecycleCallbacks);
        } else {
            Log.w((String)TAG, (String)("Context " + appContext + " was not an application, can't register for lifecycle callbacks. Some notification events may be dropped as a result."));
        }
        if (iid != null) {
            iid.addNewTokenListener(token -> this.invokeOnTokenRefresh(token));
        }
        initExecutor.execute(() -> {
            if (this.isAutoInitEnabled()) {
                this.startSyncIfNecessary();
            }
        });
        this.topicsSubscriberTask = TopicsSubscriber.createInstance(this, metadata, gmsRpc, this.context, FcmExecutors.newTopicsSyncExecutor());
        this.topicsSubscriberTask.addOnSuccessListener(initExecutor, topicsSubscriber -> {
            if (this.isAutoInitEnabled()) {
                topicsSubscriber.startTopicsSyncIfNecessary();
            }
        });
        initExecutor.execute(() -> ProxyNotificationInitializer.initialize(this.context));
    }

    public boolean isAutoInitEnabled() {
        return this.autoInit.isEnabled();
    }

    public void setAutoInitEnabled(boolean enable) {
        this.autoInit.setEnabled(enable);
    }

    @NonNull
    public boolean deliveryMetricsExportToBigQueryEnabled() {
        return MessagingAnalytics.deliveryMetricsExportToBigQueryEnabled();
    }

    public void setDeliveryMetricsExportToBigQuery(boolean enable) {
        MessagingAnalytics.setDeliveryMetricsExportToBigQuery(enable);
    }

    public boolean isNotificationDelegationEnabled() {
        return ProxyNotificationInitializer.isProxyNotificationEnabled(this.context);
    }

    public Task<Void> setNotificationDelegationEnabled(boolean enable) {
        return ProxyNotificationInitializer.setEnableProxyNotification(this.initExecutor, this.context, enable);
    }

    @NonNull
    public Task<String> getToken() {
        if (this.iid != null) {
            return this.iid.getTokenTask();
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.initExecutor.execute(() -> {
            try {
                taskCompletionSource.setResult((Object)this.blockingGetToken());
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<Void> deleteToken() {
        if (this.iid != null) {
            TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            this.initExecutor.execute(() -> {
                try {
                    this.iid.deleteToken(Metadata.getDefaultSenderId(this.firebaseApp), INSTANCE_ID_SCOPE);
                    taskCompletionSource.setResult(null);
                }
                catch (Exception e) {
                    taskCompletionSource.setException(e);
                }
            });
            return taskCompletionSource.getTask();
        }
        Store.Token token = this.getTokenWithoutTriggeringSync();
        if (token == null) {
            return Tasks.forResult(null);
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        ExecutorService executorService = FcmExecutors.newNetworkIOExecutor();
        executorService.execute(() -> {
            try {
                Tasks.await(this.gmsRpc.deleteToken());
                FirebaseMessaging.getStore(this.context).deleteToken(this.getSubtype(), Metadata.getDefaultSenderId(this.firebaseApp));
                taskCompletionSource.setResult(null);
            }
            catch (Exception e) {
                taskCompletionSource.setException(e);
            }
        });
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<Void> subscribeToTopic(@NonNull String topic) {
        return this.topicsSubscriberTask.onSuccessTask(topicsSubscriber -> topicsSubscriber.subscribeToTopic(topic));
    }

    @NonNull
    public Task<Void> unsubscribeFromTopic(@NonNull String topic) {
        return this.topicsSubscriberTask.onSuccessTask(topicsSubscriber -> topicsSubscriber.unsubscribeFromTopic(topic));
    }

    public void send(@NonNull RemoteMessage message) {
        if (TextUtils.isEmpty((CharSequence)message.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent(SEND_INTENT_ACTION);
        Intent dummyIntent = new Intent();
        dummyIntent.setPackage("com.google.example.invalidpackage");
        intent.putExtra(EXTRA_DUMMY_P_INTENT, (Parcelable)PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)dummyIntent, (int)(Build.VERSION.SDK_INT >= 23 ? 0x4000000 : 0)));
        intent.setPackage(GMS_PACKAGE);
        message.populateSendMessageIntent(intent);
        this.context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    Task<TopicsSubscriber> getTopicsSubscriberTask() {
        return this.topicsSubscriberTask;
    }

    @Nullable
    public static TransportFactory getTransportFactory() {
        return transportFactory;
    }

    static void clearTransportFactoryForTest() {
        transportFactory = null;
    }

    @VisibleForTesting
    boolean isGmsCorePresent() {
        return this.metadata.isGmscorePresent();
    }

    Context getApplicationContext() {
        return this.context;
    }

    synchronized void setSyncScheduledOrRunning(boolean value) {
        this.syncScheduledOrRunning = value;
    }

    synchronized void syncWithDelaySecondsInternal(long delaySeconds) {
        long retryDelaySeconds = Math.min(Math.max(30L, delaySeconds * 2L), MAX_DELAY_SEC);
        SyncTask syncTask = new SyncTask(this, retryDelaySeconds);
        this.enqueueTaskWithDelaySeconds(syncTask, delaySeconds);
        this.syncScheduledOrRunning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueTaskWithDelaySeconds(Runnable task, long delaySeconds) {
        Class<FirebaseMessaging> clazz = FirebaseMessaging.class;
        synchronized (FirebaseMessaging.class) {
            if (syncExecutor == null) {
                syncExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("TAG"));
            }
            syncExecutor.schedule(task, delaySeconds, TimeUnit.SECONDS);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private void startSyncIfNecessary() {
        if (this.iid != null) {
            this.iid.getToken();
            return;
        }
        Store.Token token = this.getTokenWithoutTriggeringSync();
        if (this.tokenNeedsRefresh(token)) {
            this.startSync();
        }
    }

    private synchronized void startSync() {
        if (!this.syncScheduledOrRunning) {
            this.syncWithDelaySecondsInternal(0L);
        }
    }

    @Nullable
    @VisibleForTesting
    Store.Token getTokenWithoutTriggeringSync() {
        return FirebaseMessaging.getStore(this.context).getToken(this.getSubtype(), Metadata.getDefaultSenderId(this.firebaseApp));
    }

    String blockingGetToken() throws IOException {
        if (this.iid != null) {
            try {
                return (String)Tasks.await((Task)this.iid.getTokenTask());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
        Store.Token cachedToken = this.getTokenWithoutTriggeringSync();
        if (!this.tokenNeedsRefresh(cachedToken)) {
            return cachedToken.token;
        }
        String senderId = Metadata.getDefaultSenderId(this.firebaseApp);
        Task<String> tokenTask = this.requestDeduplicator.getOrStartGetTokenRequest(senderId, () -> this.gmsRpc.getToken().onSuccessTask(this.fileExecutor, token -> {
            FirebaseMessaging.getStore(this.context).saveToken(this.getSubtype(), senderId, (String)token, this.metadata.getAppVersionCode());
            if (cachedToken == null || !token.equals(cachedToken.token)) {
                this.invokeOnTokenRefresh((String)token);
            }
            return Tasks.forResult((Object)token);
        }));
        try {
            return (String)Tasks.await(tokenTask);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    private String getSubtype() {
        return "[DEFAULT]".equals(this.firebaseApp.getName()) ? SUBTYPE_DEFAULT : this.firebaseApp.getPersistenceKey();
    }

    @VisibleForTesting
    boolean tokenNeedsRefresh(@Nullable Store.Token token) {
        return token == null || token.needsRefresh(this.metadata.getAppVersionCode());
    }

    private void invokeOnTokenRefresh(String token) {
        if ("[DEFAULT]".equals(this.firebaseApp.getName())) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Invoking onNewToken for app: " + this.firebaseApp.getName()));
            }
            Intent messagingIntent = new Intent("com.google.firebase.messaging.NEW_TOKEN");
            messagingIntent.putExtra("token", token);
            new FcmBroadcastProcessor(this.context).process(messagingIntent);
        }
    }

    private class AutoInit {
        private static final String MANIFEST_METADATA_AUTO_INIT_ENABLED = "firebase_messaging_auto_init_enabled";
        private static final String FCM_PREFERENCES = "com.google.firebase.messaging";
        private static final String AUTO_INIT_PREF = "auto_init";
        private final Subscriber subscriber;
        @GuardedBy(value="this")
        private boolean initialized;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> dataCollectionDefaultChangeEventHandler;
        @GuardedBy(value="this")
        @Nullable
        private Boolean autoInitEnabled;

        AutoInit(Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        synchronized void initialize() {
            if (this.initialized) {
                return;
            }
            this.autoInitEnabled = this.readEnabled();
            if (this.autoInitEnabled == null) {
                this.dataCollectionDefaultChangeEventHandler = event -> {
                    if (this.isEnabled()) {
                        FirebaseMessaging.this.startSyncIfNecessary();
                    }
                };
                this.subscriber.subscribe(DataCollectionDefaultChange.class, this.dataCollectionDefaultChangeEventHandler);
            }
            this.initialized = true;
        }

        synchronized boolean isEnabled() {
            this.initialize();
            return this.autoInitEnabled != null ? this.autoInitEnabled.booleanValue() : FirebaseMessaging.this.firebaseApp.isDataCollectionDefaultEnabled();
        }

        synchronized void setEnabled(boolean enable) {
            this.initialize();
            if (this.dataCollectionDefaultChangeEventHandler != null) {
                this.subscriber.unsubscribe(DataCollectionDefaultChange.class, this.dataCollectionDefaultChangeEventHandler);
                this.dataCollectionDefaultChangeEventHandler = null;
            }
            SharedPreferences.Editor preferencesEditor = FirebaseMessaging.this.firebaseApp.getApplicationContext().getSharedPreferences(FCM_PREFERENCES, 0).edit();
            preferencesEditor.putBoolean(AUTO_INIT_PREF, enable);
            preferencesEditor.apply();
            if (enable) {
                FirebaseMessaging.this.startSyncIfNecessary();
            }
            this.autoInitEnabled = enable;
        }

        @Nullable
        private Boolean readEnabled() {
            Context applicationContext = FirebaseMessaging.this.firebaseApp.getApplicationContext();
            SharedPreferences preferences = applicationContext.getSharedPreferences(FCM_PREFERENCES, 0);
            if (preferences.contains(AUTO_INIT_PREF)) {
                return preferences.getBoolean(AUTO_INIT_PREF, false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = applicationContext.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(applicationContext.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey(MANIFEST_METADATA_AUTO_INIT_ENABLED)) {
                    return applicationInfo.metaData.getBoolean(MANIFEST_METADATA_AUTO_INIT_ENABLED);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }
}

