/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.messaging.WithinAppServiceBinder;
import com.google.firebase.messaging.WithinAppServiceConnection$BindRequest$$ExternalSyntheticLambda0;
import com.google.firebase.messaging.WithinAppServiceConnection$BindRequest$$ExternalSyntheticLambda1;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class WithinAppServiceConnection
implements ServiceConnection {
    private final Context context;
    private final Intent connectionIntent;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Queue<BindRequest> intentQueue;
    @Nullable
    private WithinAppServiceBinder binder;
    @GuardedBy(value="this")
    private boolean connectionInProgress;

    synchronized Task<Void> sendIntent(Intent intent) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"new intent queued in the bind-strategy delivery");
        }
        BindRequest bindRequest = new BindRequest(intent);
        bindRequest.arrangeTimeout(this.scheduledExecutorService);
        this.intentQueue.add(bindRequest);
        this.flushQueue();
        return bindRequest.getTask();
    }

    WithinAppServiceConnection(Context context, String object) {
        NamedThreadFactory namedThreadFactory = new NamedThreadFactory("Firebase-FirebaseInstanceIdServiceConnection");
        object = new ScheduledThreadPoolExecutor(0, (ThreadFactory)namedThreadFactory);
        this(context, "com.google.firebase.MESSAGING_EVENT", (ScheduledExecutorService)object);
    }

    @VisibleForTesting
    WithinAppServiceConnection(Context context, String arrayDeque, ScheduledExecutorService scheduledExecutorService) {
        arrayDeque = new ArrayDeque<BindRequest>();
        this.intentQueue = arrayDeque;
        this.connectionInProgress = false;
        this.context = context.getApplicationContext();
        super("com.google.firebase.MESSAGING_EVENT");
        this.connectionIntent = context.setPackage(this.context.getPackageName());
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @GuardedBy(value="this")
    private void finishAllInQueue() {
        while (!this.intentQueue.isEmpty()) {
            this.intentQueue.poll().finish();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void flushQueue() {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"flush queue called");
        }
        while (true) {
            BindRequest bindRequest;
            WithinAppServiceBinder withinAppServiceBinder;
            if (this.intentQueue.isEmpty()) {
                return;
            }
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"found intent to be delivered");
            }
            if ((withinAppServiceBinder = this.binder) == null || !withinAppServiceBinder.isBinderAlive()) break;
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"binder is alive, sending the intent.");
            }
            Queue<BindRequest> queue = this.intentQueue;
            BindRequest bindRequest2 = bindRequest = queue.poll();
            this.binder.send(bindRequest2);
        }
        this.startConnectionIfNeeded();
    }

    public synchronized void onServiceConnected(ComponentName object, IBinder iBinder) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            object = String.valueOf(object);
            String.valueOf(object).length();
            Log.d((String)"FirebaseMessaging", (String)"onServiceConnected: ".concat(String.valueOf(object)));
        }
        this.connectionInProgress = false;
        if (!(iBinder instanceof WithinAppServiceBinder)) {
            object = String.valueOf(iBinder);
            String.valueOf(object).length();
            Log.e((String)"FirebaseMessaging", (String)"Invalid service connection: ".concat(String.valueOf(object)));
            this.finishAllInQueue();
            return;
        }
        this.binder = (WithinAppServiceBinder)iBinder;
        this.flushQueue();
    }

    public void onServiceDisconnected(ComponentName object) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            object = String.valueOf(object);
            String.valueOf(object).length();
            Log.d((String)"FirebaseMessaging", (String)"onServiceDisconnected: ".concat(String.valueOf(object)));
        }
        this.flushQueue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GuardedBy(value="this")
    private void startConnectionIfNeeded() {
        boolean bl;
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            bl = this.connectionInProgress;
            StringBuilder stringBuilder = new StringBuilder(39);
            stringBuilder.append("binder is dead. start connection? ");
            stringBuilder.append(bl ^ true);
            Log.d((String)"FirebaseMessaging", (String)stringBuilder.toString());
        }
        if (this.connectionInProgress) {
            return;
        }
        this.connectionInProgress = true;
        try {
            bl = ConnectionTracker.getInstance().bindService(this.context, this.connectionIntent, (ServiceConnection)this, 65);
            if (bl) {
                return;
            }
            Log.e((String)"FirebaseMessaging", (String)"binding to the service failed");
        }
        catch (SecurityException securityException) {
            Log.e((String)"FirebaseMessaging", (String)"Exception while binding the service", (Throwable)securityException);
        }
        this.connectionInProgress = false;
        this.finishAllInQueue();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class BindRequest {
        final Intent intent;
        private final TaskCompletionSource<Void> taskCompletionSource;

        Task<Void> getTask() {
            return this.taskCompletionSource.getTask();
        }

        BindRequest(Intent intent) {
            TaskCompletionSource taskCompletionSource;
            this.taskCompletionSource = taskCompletionSource = new TaskCompletionSource();
            this.intent = intent;
        }

        void arrangeTimeout(ScheduledExecutorService scheduledExecutorService) {
            Object object = new WithinAppServiceConnection$BindRequest$$ExternalSyntheticLambda1((BindRequest)task);
            Object object2 = TimeUnit.MILLISECONDS;
            object = scheduledExecutorService.schedule((Runnable)object, 9000L, (TimeUnit)((Object)object2));
            Task<Void> task = task.getTask();
            object2 = new WithinAppServiceConnection$BindRequest$$ExternalSyntheticLambda0((ScheduledFuture)object);
            task.addOnCompleteListener((Executor)scheduledExecutorService, (OnCompleteListener)object2);
        }

        void finish() {
            this.taskCompletionSource.trySetResult(null);
        }

        /* synthetic */ void lambda$arrangeTimeout$0$com-google-firebase-messaging-WithinAppServiceConnection$BindRequest() {
            String string = this.intent.getAction();
            String string2 = String.valueOf(string);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 61);
            stringBuilder.append("Service took too long to process intent: ");
            stringBuilder.append(string);
            stringBuilder.append(" App may get closed.");
            Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
            this.finish();
        }

        static /* synthetic */ void lambda$arrangeTimeout$1(ScheduledFuture scheduledFuture, Task task) {
            scheduledFuture.cancel(false);
        }
    }
}

