/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.res.Resources;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;
import org.json.JSONArray;
import org.json.JSONException;

public class NotificationParams {
    @NonNull
    private final Bundle data;

    private static int getLightColor(String string) {
        int n = Color.parseColor((String)string);
        if (n == -16777216) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Transparent color is invalid");
            throw illegalArgumentException;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Uri getLink() {
        String string = ((NotificationParams)this).getString("gcm.n.link_android");
        if (!TextUtils.isEmpty((CharSequence)(this = TextUtils.isEmpty((CharSequence)string) ? ((NotificationParams)this).getString("gcm.n.link") : string))) {
            return Uri.parse((String)this);
        }
        return null;
    }

    @NonNull
    public Bundle paramsForAnalyticsIntent() {
        Bundle bundle = new Bundle(((NotificationParams)this).data);
        for (String string : ((NotificationParams)this).data.keySet()) {
            if (NotificationParams.isAnalyticsKey(string)) continue;
            bundle.remove(string);
        }
        return bundle;
    }

    @NonNull
    public Bundle paramsWithReservedKeysRemoved() {
        Bundle bundle = new Bundle(((NotificationParams)this).data);
        for (String string : ((NotificationParams)this).data.keySet()) {
            if (!NotificationParams.isReservedKey(string)) continue;
            bundle.remove(string);
        }
        return bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public Integer getInteger(@NonNull String key) {
        String string;
        if (TextUtils.isEmpty((CharSequence)(this = ((NotificationParams)this).getString(string)))) return null;
        try {
            return Integer.parseInt((String)this);
        }
        catch (NumberFormatException numberFormatException) {
            string = NotificationParams.userFriendlyKey(string);
            String string2 = String.valueOf(string);
            int n = string2.length();
            String string3 = String.valueOf(this);
            int n2 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 38 + n2);
            stringBuilder.append("Couldn't parse value of ");
            stringBuilder.append(string);
            stringBuilder.append("(");
            stringBuilder.append((String)this);
            stringBuilder.append(") into an int");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
    }

    @Nullable
    Integer getNotificationCount() {
        if ((object = ((NotificationParams)object).getInteger("gcm.n.notification_count")) == null) {
            return null;
        }
        if ((Integer)object < 0) {
            Object object = object.toString();
            StringBuilder stringBuilder = new StringBuilder(((String)object).length() + 67);
            stringBuilder.append("notificationCount is invalid: ");
            stringBuilder.append((String)object);
            stringBuilder.append(". Skipping setting notificationCount.");
            Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
            return null;
        }
        return object;
    }

    @Nullable
    Integer getNotificationPriority() {
        if ((object = ((NotificationParams)object).getInteger("gcm.n.notification_priority")) == null) {
            return null;
        }
        if ((Integer)object < -2 || (Integer)object > 2) {
            Object object = object.toString();
            StringBuilder stringBuilder = new StringBuilder(((String)object).length() + 72);
            stringBuilder.append("notificationPriority is invalid ");
            stringBuilder.append((String)object);
            stringBuilder.append(". Skipping setting notificationPriority.");
            Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
            return null;
        }
        return object;
    }

    Integer getVisibility() {
        if ((object = ((NotificationParams)object).getInteger("gcm.n.visibility")) == null) {
            return null;
        }
        if ((Integer)object < -1 || (Integer)object > 1) {
            Object object = object.toString();
            StringBuilder stringBuilder = new StringBuilder(((String)object).length() + 53);
            stringBuilder.append("visibility is invalid: ");
            stringBuilder.append((String)object);
            stringBuilder.append(". Skipping setting visibility.");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public Long getLong(@NonNull String key) {
        String string;
        if (TextUtils.isEmpty((CharSequence)(this = ((NotificationParams)this).getString(string)))) return null;
        try {
            return Long.parseLong((String)this);
        }
        catch (NumberFormatException numberFormatException) {
            string = NotificationParams.userFriendlyKey(string);
            String string2 = String.valueOf(string);
            int n = string2.length();
            String string3 = String.valueOf(this);
            int n2 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 38 + n2);
            stringBuilder.append("Couldn't parse value of ");
            stringBuilder.append(string);
            stringBuilder.append("(");
            stringBuilder.append((String)this);
            stringBuilder.append(") into a long");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getLocalizationResourceForKey(@NonNull String key) {
        void var1_1;
        return this.getString(String.valueOf(var1_1).concat("_loc_key"));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getLocalizedString(@NonNull Resources resources, @NonNull String packageName, @NonNull String key) {
        Object this_;
        void var2_4;
        String string;
        String string2;
        CharSequence charSequence = this_.getLocalizationResourceForKey(string2);
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return null;
        }
        int n = string.getIdentifier((String)charSequence, "string", (String)var2_4);
        if (n == 0) {
            this_ = NotificationParams.userFriendlyKey(String.valueOf(string2).concat("_loc_key"));
            string = String.valueOf(this_);
            int n2 = string.length();
            String string3 = String.valueOf(string2);
            int n3 = string3.length();
            charSequence = new StringBuilder(n2 + 49 + n3);
            ((StringBuilder)charSequence).append((String)this_);
            ((StringBuilder)charSequence).append(" resource not found: ");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(" Default value will be used.");
            Log.w((String)"NotificationParams", (String)((StringBuilder)charSequence).toString());
            return null;
        }
        if ((this_ = this_.getLocalizationArgsForKey(string2)) == null) {
            return string.getString(n);
        }
        try {
            string = string.getString(n, this_);
            return string;
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            String string4 = NotificationParams.userFriendlyKey(string2);
            this_ = Arrays.toString(this_);
            string2 = String.valueOf(string4);
            int n4 = string2.length();
            charSequence = String.valueOf(this_);
            int n5 = ((String)charSequence).length();
            StringBuilder stringBuilder = new StringBuilder(n4 + 58 + n5);
            stringBuilder.append("Missing format argument for ");
            stringBuilder.append(string4);
            stringBuilder.append(": ");
            stringBuilder.append((String)this_);
            stringBuilder.append(" Default value will be used.");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString(), (Throwable)missingFormatArgumentException);
            return null;
        }
    }

    @NonNull
    public String getNotificationChannelId() {
        return this.getString("gcm.n.android_channel_id");
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public String getPossiblyLocalizedString(@NonNull Resources resources, @NonNull String packageName, @NonNull String key) {
        void var2_2;
        void var1_1;
        void var3_3;
        String string = this.getString((String)var3_3);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return this.getLocalizedString((Resources)var1_1, (String)var2_2, (String)var3_3);
    }

    @Nullable
    public String getSoundResourceName() {
        String string = this.getString("gcm.n.sound2");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return this.getString("gcm.n.sound");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public String getString(@NonNull String key) {
        void var1_1;
        return this.data.getString(this.normalizePrefix((String)var1_1));
    }

    private static String keyWithOldPrefix(String string) {
        if (!string.startsWith("gcm.n.")) {
            return string;
        }
        return string.replace("gcm.n.", "gcm.notification.");
    }

    private String normalizePrefix(String string) {
        String string2;
        if (!this.data.containsKey(string) && string.startsWith("gcm.n.") && this.data.containsKey(string2 = NotificationParams.keyWithOldPrefix(string))) {
            return string2;
        }
        return string;
    }

    private static String userFriendlyKey(String string) {
        if (string.startsWith("gcm.n.")) {
            return string.substring(6);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public JSONArray getJSONArray(@NonNull String key) {
        String string;
        if (TextUtils.isEmpty((CharSequence)(this = ((NotificationParams)this).getString(string)))) return null;
        try {
            return new JSONArray((String)this);
        }
        catch (JSONException jSONException) {
            string = NotificationParams.userFriendlyKey(string);
            String string2 = String.valueOf(string);
            int n = string2.length();
            String string3 = String.valueOf(this);
            int n2 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 50 + n2);
            stringBuilder.append("Malformed JSON for key ");
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append((String)this);
            stringBuilder.append(", falling back to default");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public NotificationParams(@NonNull Bundle data) {
        Bundle bundle;
        void var1_1;
        if (var1_1 == null) {
            Object this_ = new NullPointerException("data");
            throw this_;
        }
        ((NotificationParams)this_).data = bundle = new Bundle((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(@NonNull String key) {
        void var1_1;
        return "1".equals(this = ((NotificationParams)this).getString((String)var1_1)) || Boolean.parseBoolean((String)this);
    }

    public boolean hasImage() {
        return !TextUtils.isEmpty((CharSequence)this.getString("gcm.n.image"));
    }

    private static boolean isAnalyticsKey(String string) {
        return string.startsWith("google.c.a.") || string.equals("from");
    }

    public boolean isNotification() {
        return this.getBoolean("gcm.n.e");
    }

    public static boolean isNotification(@NonNull Bundle data) {
        Bundle bundle;
        return "1".equals(bundle.getString("gcm.n.e")) || "1".equals(bundle.getString(NotificationParams.keyWithOldPrefix("gcm.n.e")));
    }

    private static boolean isReservedKey(String string) {
        return string.startsWith("google.c.") || string.startsWith("gcm.n.") || string.startsWith("gcm.notification.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    int[] getLightSettings() {
        Object object;
        if ((object = ((NotificationParams)object).getJSONArray("gcm.n.light_settings")) == null) {
            return null;
        }
        Object object2 = new int[3];
        try {
            int n = object.length();
            if (n != 3) {
                object2 = (Object)new JSONException;
                object2("lightSettings don't have all three fields");
                throw object2;
            }
            object2[0] = NotificationParams.getLightColor(object.optString(0));
            object2[1] = object.optInt(1);
            object2[2] = object.optInt(2);
            return object2;
        }
        catch (JSONException jSONException) {
            object = object.toString();
            object2 = new StringBuilder;
            ((StringBuilder)object2)(((String)object).length() + 58);
            ((StringBuilder)object2).append("LightSettings is invalid: ");
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append(". Skipping setting LightSettings");
            Log.w((String)"NotificationParams", (String)((StringBuilder)object2).toString());
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = object.toString();
            String string = illegalArgumentException.getMessage();
            String string2 = String.valueOf(string);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(((String)object).length() + 60 + n);
            stringBuilder.append("LightSettings is invalid: ");
            stringBuilder.append((String)object);
            stringBuilder.append(". ");
            stringBuilder.append(string);
            stringBuilder.append(". Skipping setting LightSettings");
            Log.w((String)"NotificationParams", (String)stringBuilder.toString());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public long[] getVibrateTimings() {
        Object object = ((NotificationParams)((Object)this_)).getJSONArray("gcm.n.vibrate_timings");
        if (object == null) {
            return null;
        }
        try {
            int n = object.length();
            if (n <= 1) {
                JSONException jSONException = new JSONException("vibrateTimings have invalid length");
                throw jSONException;
            }
            long[] lArray = new long[object.length()];
            n = 0;
            while (true) {
                int n2;
                if (n >= (n2 = lArray.length)) {
                    return lArray;
                }
                lArray[n] = object.optLong(n);
                ++n;
            }
        }
        catch (NumberFormatException | JSONException throwable) {
            String this_ = object.toString();
            object = new StringBuilder(this_.length() + 74);
            ((StringBuilder)object).append("User defined vibrateTimings is invalid: ");
            ((StringBuilder)object).append(this_);
            ((StringBuilder)object).append(". Skipping setting vibrateTimings.");
            Log.w((String)"NotificationParams", (String)((StringBuilder)object).toString());
            return null;
        }
    }

    @Nullable
    public Object[] getLocalizationArgsForKey(@NonNull String key) {
        JSONArray jSONArray;
        if ((jSONArray = this.getJSONArray(String.valueOf(jSONArray).concat("_loc_args"))) == null) {
            return null;
        }
        Object[] objectArray = new String[jSONArray.length()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = jSONArray.optString(i);
        }
        return objectArray;
    }
}

