/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.GmsRpc;
import com.google.firebase.messaging.Metadata;
import com.google.firebase.messaging.TopicOperation;
import com.google.firebase.messaging.TopicsStore;
import com.google.firebase.messaging.TopicsSubscriber$$Lambda$0;
import com.google.firebase.messaging.TopicsSyncTask;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class TopicsSubscriber {
    private static final long MAX_DELAY_SEC = TimeUnit.HOURS.toSeconds(8L);
    private final Context context;
    private final Metadata metadata;
    private final GmsRpc rpc;
    private final FirebaseMessaging firebaseMessaging;
    private final FirebaseInstallationsApi firebaseInstallationsApi;
    @GuardedBy(value="pendingOperations")
    private final Map<String, ArrayDeque<TaskCompletionSource<Void>>> pendingOperations;
    private final ScheduledExecutorService syncExecutor;
    @GuardedBy(value="this")
    private boolean syncScheduledOrRunning;
    private final TopicsStore store;

    @VisibleForTesting
    static Task<TopicsSubscriber> createInstance(FirebaseMessaging firebaseMessaging, FirebaseInstallationsApi firebaseInstallationsApi, Metadata metadata, GmsRpc gmsRpc, Context context, @NonNull ScheduledExecutorService scheduledExecutorService) {
        TopicsSubscriber$$Lambda$0 topicsSubscriber$$Lambda$0 = new TopicsSubscriber$$Lambda$0(context, scheduledExecutorService, firebaseMessaging, firebaseInstallationsApi, metadata, gmsRpc);
        return Tasks.call((Executor)scheduledExecutorService, (Callable)topicsSubscriber$$Lambda$0);
    }

    private TopicsSubscriber(FirebaseMessaging firebaseMessaging, FirebaseInstallationsApi firebaseInstallationsApi, Metadata metadata, TopicsStore topicsStore, GmsRpc gmsRpc, Context context, @NonNull ScheduledExecutorService scheduledExecutorService) {
        ArrayMap arrayMap;
        this.pendingOperations = arrayMap = new ArrayMap();
        this.syncScheduledOrRunning = false;
        this.firebaseMessaging = firebaseMessaging;
        this.firebaseInstallationsApi = firebaseInstallationsApi;
        this.metadata = metadata;
        this.store = topicsStore;
        this.rpc = gmsRpc;
        this.context = context;
        this.syncExecutor = scheduledExecutorService;
    }

    Task<Void> subscribeToTopic(String task) {
        task = TopicOperation.subscribe((String)task);
        task = this.scheduleTopicOperation((TopicOperation)task);
        this.startTopicsSyncIfNecessary();
        return task;
    }

    Task<Void> unsubscribeFromTopic(String task) {
        task = TopicOperation.unsubscribe((String)task);
        task = this.scheduleTopicOperation((TopicOperation)task);
        this.startTopicsSyncIfNecessary();
        return task;
    }

    @VisibleForTesting
    Task<Void> scheduleTopicOperation(TopicOperation topicOperation) {
        this.store.addTopicOperation(topicOperation);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.addToPendingOperations(topicOperation, (TaskCompletionSource<Void>)taskCompletionSource);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addToPendingOperations(TopicOperation object, TaskCompletionSource<Void> taskCompletionSource) {
        Map<String, ArrayDeque<TaskCompletionSource<Void>>> map = ((TopicsSubscriber)((Object)arrayDeque)).pendingOperations;
        synchronized (map) {
            ArrayDeque<TaskCompletionSource<Void>> arrayDeque;
            object = ((TopicOperation)object).serialize();
            boolean bl = ((TopicsSubscriber)((Object)arrayDeque)).pendingOperations.containsKey(object);
            if (bl) {
                arrayDeque = ((TopicsSubscriber)((Object)arrayDeque)).pendingOperations.get(object);
            } else {
                ArrayDeque<TaskCompletionSource<Void>> arrayDeque2 = new ArrayDeque<TaskCompletionSource<Void>>();
                ((TopicsSubscriber)((Object)arrayDeque)).pendingOperations.put((String)object, arrayDeque2);
                arrayDeque = arrayDeque2;
            }
            arrayDeque.add(taskCompletionSource);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    boolean hasPendingOperation() {
        return this.store.getNextTopicOperation() != null;
    }

    void startTopicsSyncIfNecessary() {
        if (this.hasPendingOperation()) {
            this.startSync();
            return;
        }
    }

    private void startSync() {
        if (!this.isSyncScheduledOrRunning()) {
            this.syncWithDelaySecondsInternal(0L);
            return;
        }
    }

    void syncWithDelaySecondsInternal(long l) {
        long l2 = Math.max(30L, l + l);
        long l3 = MAX_DELAY_SEC;
        l2 = Math.min(l2, l3);
        TopicsSyncTask topicsSyncTask = new TopicsSyncTask(this, this.context, this.metadata, l2);
        this.scheduleSyncTaskWithDelaySeconds(topicsSyncTask, l);
        this.setSyncScheduledOrRunning(true);
    }

    void scheduleSyncTaskWithDelaySeconds(Runnable runnable, long l) {
        this.syncExecutor.schedule(runnable, l, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    boolean syncTopics() throws IOException {
        while (true) {
            TopicOperation topicOperation;
            synchronized (this) {
                topicOperation = this.store.getNextTopicOperation();
                if (topicOperation == null) {
                    boolean bl = TopicsSubscriber.isDebugLogEnabled();
                    if (!bl) return true;
                    Log.d((String)"FirebaseMessaging", (String)"topic sync succeeded");
                    return true;
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            if (!this.performTopicOperation(topicOperation)) {
                return false;
            }
            this.store.removeTopicOperation(topicOperation);
            this.markCompletePendingOperation(topicOperation);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void markCompletePendingOperation(TopicOperation object) {
        Map<String, ArrayDeque<TaskCompletionSource<Void>>> map = this.pendingOperations;
        synchronized (map) {
            boolean bl;
            object = ((TopicOperation)object).serialize();
            boolean bl2 = this.pendingOperations.containsKey(object);
            if (!bl2) {
                return;
            }
            ArrayDeque<TaskCompletionSource<Void>> arrayDeque = this.pendingOperations.get(object);
            TaskCompletionSource<Void> taskCompletionSource = arrayDeque.poll();
            if (taskCompletionSource != null) {
                taskCompletionSource.setResult(null);
            }
            if (!(bl = arrayDeque.isEmpty())) return;
            this.pendingOperations.remove(object);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @WorkerThread
    boolean performTopicOperation(TopicOperation var1_9) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CASE]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @WorkerThread
    private void blockingSubscribeToTopic(String string) throws IOException {
        Object object = this.firebaseInstallationsApi;
        object = object.getId();
        object = TopicsSubscriber.awaitTask(object);
        object = (String)object;
        TopicsSubscriber.awaitTask(this.rpc.subscribeToTopic((String)object, this.firebaseMessaging.blockingGetToken(), string));
    }

    @WorkerThread
    private void blockingUnsubscribeFromTopic(String string) throws IOException {
        Object object = this.firebaseInstallationsApi;
        object = object.getId();
        object = TopicsSubscriber.awaitTask(object);
        object = (String)object;
        TopicsSubscriber.awaitTask(this.rpc.unsubscribeFromTopic((String)object, this.firebaseMessaging.blockingGetToken(), string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private static <T> T awaitTask(Task<T> object) throws IOException {
        Throwable throwable;
        try {
            Object object2 = Tasks.await(object, (long)30L, (TimeUnit)TimeUnit.SECONDS);
            return (T)object2;
        }
        catch (ExecutionException executionException) {
            throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
        }
        catch (InterruptedException | TimeoutException exception) {
            IOException iOException = new IOException("SERVICE_NOT_AVAILABLE", exception);
            throw iOException;
        }
        if (throwable instanceof RuntimeException) throw (RuntimeException)throwable;
        throwable = new IOException(executionException);
        throw throwable;
    }

    synchronized boolean isSyncScheduledOrRunning() {
        return this.syncScheduledOrRunning;
    }

    synchronized void setSyncScheduledOrRunning(boolean bl) {
        this.syncScheduledOrRunning = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isDebugLogEnabled() {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) return true;
        if (Build.VERSION.SDK_INT != 23) return false;
        if (!Log.isLoggable((String)"FirebaseMessaging", (int)3)) return false;
        return true;
    }

    static final /* synthetic */ TopicsSubscriber lambda$createInstance$0$TopicsSubscriber(Context context, ScheduledExecutorService scheduledExecutorService, FirebaseMessaging firebaseMessaging, FirebaseInstallationsApi firebaseInstallationsApi, Metadata metadata, GmsRpc gmsRpc) throws Exception {
        TopicsStore topicsStore = TopicsStore.getInstance(context, scheduledExecutorService);
        TopicsSubscriber topicsSubscriber = new TopicsSubscriber(firebaseMessaging, firebaseInstallationsApi, metadata, topicsStore, gmsRpc, context, scheduledExecutorService);
        return topicsSubscriber;
    }
}

