/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.messaging.WakeLockHolder;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class ServiceStarter {
    public static final int SUCCESS = -1;
    @KeepForSdk
    public static final int ERROR_UNKNOWN = 500;
    private static ServiceStarter instance;
    @GuardedBy(value="this")
    @Nullable
    private String firebaseMessagingServiceClassName = null;
    private Boolean hasWakeLockPermission = null;
    private Boolean hasAccessNetworkStatePermission = null;
    private final Queue<Intent> messagingEvents;

    static synchronized ServiceStarter getInstance() {
        if (instance == null) {
            ServiceStarter serviceStarter;
            instance = serviceStarter = new ServiceStarter();
        }
        return instance;
    }

    private ServiceStarter() {
        ArrayDeque<Intent> arrayDeque = new ArrayDeque<Intent>();
        this.messagingEvents = arrayDeque;
    }

    @MainThread
    Intent getMessagingEvent() {
        return this.messagingEvents.poll();
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    public int startMessagingService(@NonNull Context context, @NonNull Intent intent) {
        void var1_1;
        Intent intent2;
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Starting service");
        }
        this.messagingEvents.offer(intent2);
        intent2 = new Intent("com.google.firebase.MESSAGING_EVENT");
        intent2.setPackage(var1_1.getPackageName());
        return this.doStartService((Context)var1_1, intent2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doStartService(Context object, Intent object2) {
        String string = this.resolveServiceClassName((Context)object, (Intent)object2);
        if (string != null) {
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                String string2;
                String string3 = "Restricting intent to a specific service: ";
                string3 = string.length() != 0 ? string3.concat(string) : (string2 = new String(string3));
                Log.d((String)"FirebaseMessaging", (String)string3);
            }
            object2.setClassName(object.getPackageName(), string);
        }
        try {
            ComponentName componentName;
            boolean bl = this.hasWakeLockPermission((Context)object);
            if (bl) {
                componentName = WakeLockHolder.startWakefulService((Context)object, (Intent)object2);
            } else {
                componentName = object.startService((Intent)object2);
                Log.d((String)"FirebaseMessaging", (String)"Missing wake lock permission, service start may be delayed");
            }
            if (componentName == null) {
                Log.e((String)"FirebaseMessaging", (String)"Error while delivering the message: ServiceIntent not found.");
                return 404;
            }
            return -1;
        }
        catch (SecurityException securityException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while delivering the message to the serviceIntent", (Throwable)securityException);
            return 401;
        }
        catch (IllegalStateException illegalStateException) {
            String string4 = String.valueOf(illegalStateException);
            object = String.valueOf(string4);
            int n = ((String)object).length();
            object2 = new StringBuilder(n + 45);
            ((StringBuilder)object2).append("Failed to start service while in background: ");
            ((StringBuilder)object2).append(string4);
            Log.e((String)"FirebaseMessaging", (String)((StringBuilder)object2).toString());
            return 402;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private synchronized String resolveServiceClassName(Context object, Intent object2) {
        String string = ((ServiceStarter)((Object)string2)).firebaseMessagingServiceClassName;
        if (string != null) {
            return string;
        }
        object2 = object.getPackageManager().resolveService((Intent)object2, 0);
        if (object2 == null || ((ResolveInfo)object2).serviceInfo == null) {
            Log.e((String)"FirebaseMessaging", (String)"Failed to resolve target intent service, skipping classname enforcement");
            return null;
        }
        object2 = ((ResolveInfo)object2).serviceInfo;
        if (!object.getPackageName().equals(((ServiceInfo)object2).packageName) || ((ServiceInfo)object2).name == null) {
            String string2 = ((ServiceInfo)object2).packageName;
            object = ((ServiceInfo)object2).name;
            object2 = String.valueOf(string2);
            int n = ((String)object2).length();
            string = String.valueOf(object);
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 94 + n2);
            stringBuilder.append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ");
            stringBuilder.append(string2);
            stringBuilder.append("/");
            stringBuilder.append((String)object);
            Log.e((String)"FirebaseMessaging", (String)stringBuilder.toString());
            return null;
        }
        if (!((ServiceInfo)object2).name.startsWith(".")) {
            ((ServiceStarter)((Object)string2)).firebaseMessagingServiceClassName = ((ServiceInfo)object2).name;
            return ((ServiceStarter)((Object)string2)).firebaseMessagingServiceClassName;
        }
        object = String.valueOf(object.getPackageName());
        object2 = String.valueOf(((ServiceInfo)object2).name);
        object = ((String)object2).length() != 0 ? ((String)object).concat((String)object2) : (object2 = new String((String)object));
        ((ServiceStarter)((Object)string2)).firebaseMessagingServiceClassName = object;
        return ((ServiceStarter)((Object)string2)).firebaseMessagingServiceClassName;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean hasWakeLockPermission(Context context) {
        if (this.hasWakeLockPermission == null) {
            boolean bl = context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0;
            this.hasWakeLockPermission = bl;
        }
        if (!this.hasWakeLockPermission.booleanValue() && Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Missing Permission: android.permission.WAKE_LOCK this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.hasWakeLockPermission;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean hasAccessNetworkStatePermission(Context context) {
        if (this.hasAccessNetworkStatePermission == null) {
            boolean bl = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
            this.hasAccessNetworkStatePermission = bl;
        }
        if (!this.hasWakeLockPermission.booleanValue() && Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Missing Permission: android.permission.ACCESS_NETWORK_STATE this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.hasAccessNetworkStatePermission;
    }

    @VisibleForTesting
    public static void setForTesting(@NonNull ServiceStarter serviceStarter) {
        instance = serviceStarter;
    }
}

