/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_messaging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase_messaging.zzaa;
import com.google.android.gms.internal.firebase_messaging.zzaf;
import com.google.android.gms.internal.firebase_messaging.zzt;
import com.google.android.gms.internal.firebase_messaging.zzv;
import com.google.android.gms.internal.firebase_messaging.zzw;
import com.google.android.gms.internal.firebase_messaging.zzx;
import com.google.android.gms.internal.firebase_messaging.zzz;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.ValueEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;

final class zzab
implements ObjectEncoderContext {
    private static final Charset zza = Charset.forName("UTF-8");
    private OutputStream zzb;
    private final Map<Class<?>, ObjectEncoder<?>> zzc;
    private final Map<Class<?>, ValueEncoder<?>> zzd;
    private final ObjectEncoder<Object> zze;
    private final zzaf zzf;
    private static final FieldDescriptor zzg;
    private static final FieldDescriptor zzh;
    private static final ObjectEncoder<Map.Entry<Object, Object>> zzi;

    zzab(OutputStream outputStream, Map<Class<?>, ObjectEncoder<?>> map, Map<Class<?>, ValueEncoder<?>> map2, ObjectEncoder<Object> objectEncoder) {
        zzaf zzaf2;
        this.zzf = zzaf2 = new zzaf(this);
        this.zzb = outputStream;
        this.zzc = map;
        this.zzd = map2;
        this.zze = objectEncoder;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull String string, @Nullable Object object) throws IOException {
        this.zza(FieldDescriptor.of((String)string), object, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull String string, double d) throws IOException {
        this.zzb(FieldDescriptor.of((String)string), d, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull String string, int n) throws IOException {
        this.zzd(FieldDescriptor.of((String)string), n, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull String string, long l) throws IOException {
        this.zze(FieldDescriptor.of((String)string), l, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull String string, boolean bl) throws IOException {
        this.zzd(FieldDescriptor.of((String)string), bl ? 1 : 0, true);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull FieldDescriptor fieldDescriptor, @Nullable Object object) throws IOException {
        this.zza(fieldDescriptor, object, true);
        return this;
    }

    final ObjectEncoderContext zza(@NonNull FieldDescriptor object, @Nullable Object object2, boolean bl) throws IOException {
        if (object2 == null) {
            return this;
        }
        if (object2 instanceof CharSequence) {
            object2 = (CharSequence)object2;
            if (bl && object2.length() == 0) {
                return this;
            }
            this.zzn(zzab.zzl(object) << 3 | 2);
            object = object2.toString().getBytes(zza);
            this.zzn(((FieldDescriptor)object).length);
            this.zzb.write((byte[])object);
            return this;
        }
        if (object2 instanceof Collection) {
            object2 = ((Collection)object2).iterator();
            while (object2.hasNext()) {
                this.zza((FieldDescriptor)object, object2.next(), false);
            }
            return this;
        }
        if (object2 instanceof Map) {
            for (Object object3 : ((Map)object2).entrySet()) {
                Map.Entry entry = (Map.Entry)object3;
                this.zzh((ObjectEncoder)zzi, (FieldDescriptor)object, (Object)entry, false);
            }
            return this;
        }
        if (object2 instanceof Double) {
            this.zzb((FieldDescriptor)object, (Double)object2, bl);
            return this;
        }
        if (object2 instanceof Float) {
            this.zzc((FieldDescriptor)object, ((Float)object2).floatValue(), bl);
            return this;
        }
        if (object2 instanceof Number) {
            this.zze((FieldDescriptor)object, ((Number)object2).longValue(), bl);
            return this;
        }
        if (object2 instanceof Boolean) {
            this.zzd((FieldDescriptor)object, ((Boolean)object2).booleanValue() ? 1 : 0, bl);
            return this;
        }
        if (object2 instanceof byte[]) {
            object2 = (byte[])object2;
            if (bl && ((Object)object2).length == 0) {
                return this;
            }
            this.zzn(zzab.zzl(object) << 3 | 2);
            this.zzn(((Object)object2).length);
            this.zzb.write((byte[])object2);
            return this;
        }
        ObjectEncoder<?> objectEncoder = this.zzc.get(object2.getClass());
        if (objectEncoder != null) {
            this.zzh((ObjectEncoder)objectEncoder, (FieldDescriptor)object, (Object)object2, bl);
            return this;
        }
        objectEncoder = this.zzd.get(object2.getClass());
        if (objectEncoder != null) {
            this.zzj((ValueEncoder)objectEncoder, (FieldDescriptor)object, (Object)object2, bl);
            return this;
        }
        if (object2 instanceof zzx) {
            this.zzd((FieldDescriptor)object, ((zzx)object2).getNumber(), true);
            return this;
        }
        if (object2 instanceof Enum) {
            this.zzd((FieldDescriptor)object, ((Enum)object2).ordinal(), true);
            return this;
        }
        this.zzh((ObjectEncoder)this.zze, (FieldDescriptor)object, (Object)object2, bl);
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull FieldDescriptor fieldDescriptor, double d) throws IOException {
        this.zzb(fieldDescriptor, d, true);
        return this;
    }

    final ObjectEncoderContext zzb(@NonNull FieldDescriptor fieldDescriptor, double d, boolean bl) throws IOException {
        if (bl && d == 0.0) {
            return this;
        }
        this.zzn(zzab.zzl(fieldDescriptor) << 3 | 1);
        this.zzb.write(zzab.zzk(8).putDouble(d).array());
        return this;
    }

    @NonNull
    public final ObjectEncoderContext add(@NonNull FieldDescriptor fieldDescriptor, float f) throws IOException {
        this.zzc(fieldDescriptor, f, true);
        return this;
    }

    final ObjectEncoderContext zzc(@NonNull FieldDescriptor fieldDescriptor, float f, boolean bl) throws IOException {
        if (bl && f == 0.0f) {
            return this;
        }
        this.zzn(zzab.zzl(fieldDescriptor) << 3 | 5);
        this.zzb.write(zzab.zzk(4).putFloat(f).array());
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    final zzab zzd(@NonNull FieldDescriptor object, int n, boolean bl) throws IOException {
        if (bl) {
            if (n == 0) return this;
        }
        object = zzab.zzm((FieldDescriptor)object);
        switch (object.zzb().ordinal()) {
            case 2: {
                this.zzn(object.zza() << 3 | 5);
                this.zzb.write(zzab.zzk(4).putInt(n).array());
                return this;
            }
            case 1: {
                this.zzn(object.zza() << 3);
                this.zzn(n + n ^ n >> 31);
                return this;
            }
            case 0: {
                this.zzn(object.zza() << 3);
                this.zzn(n);
                return this;
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    final zzab zze(@NonNull FieldDescriptor object, long l, boolean bl) throws IOException {
        if (bl) {
            if (l == 0L) return this;
        }
        object = zzab.zzm((FieldDescriptor)object);
        switch (object.zzb().ordinal()) {
            case 2: {
                this.zzn(object.zza() << 3 | 1);
                this.zzb.write(zzab.zzk(8).putLong(l).array());
                return this;
            }
            case 1: {
                this.zzn(object.zza() << 3);
                this.zzo(l + l ^ l >> 63);
                return this;
            }
            case 0: {
                this.zzn(object.zza() << 3);
                this.zzo(l);
                return this;
            }
        }
        return this;
    }

    @NonNull
    public final ObjectEncoderContext inline(@Nullable Object object) throws IOException {
        this.zzf(object);
        return this;
    }

    final zzab zzf(@Nullable Object object) throws IOException {
        if (object == null) {
            return zzab2;
        }
        Object object2 = zzab2.zzc.get(object.getClass());
        if (object2 == null) {
            object = String.valueOf(object.getClass());
            object2 = String.valueOf(object);
            int n = ((String)object2).length();
            StringBuilder stringBuilder = new StringBuilder(n + 15);
            stringBuilder.append("No encoder for ");
            stringBuilder.append((String)object);
            zzab zzab2 = new EncodingException(stringBuilder.toString());
            throw zzab2;
        }
        object2.encode(object, (Object)zzab2);
        return zzab2;
    }

    @NonNull
    public final ObjectEncoderContext nested(@NonNull String string) throws IOException {
        return this.nested(FieldDescriptor.of((String)string));
    }

    @NonNull
    public final ObjectEncoderContext nested(@NonNull FieldDescriptor fieldDescriptor) throws IOException {
        zzab zzab2 = new EncodingException("nested() is not implemented for protobuf encoding.");
        throw zzab2;
    }

    private final <T> zzab zzh(ObjectEncoder<T> objectEncoder, FieldDescriptor fieldDescriptor, T t, boolean bl) throws IOException {
        long l = this.zzi(objectEncoder, t);
        if (bl && l == 0L) {
            return this;
        }
        this.zzn(zzab.zzl(fieldDescriptor) << 3 | 2);
        this.zzo(l);
        objectEncoder.encode(t, (Object)this);
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final <T> long zzi(ObjectEncoder<T> objectEncoder, T t) throws IOException {
        zzw zzw2 = new zzw();
        OutputStream outputStream = this.zzb;
        this.zzb = zzw2;
        {
            catch (Throwable throwable) {
                try {
                    zzw2.close();
                }
                catch (Throwable throwable2) {
                    zzt.zza(throwable, throwable2);
                    throw throwable;
                }
                throw throwable;
            }
        }
        objectEncoder.encode(t, (Object)this);
        this.zzb = outputStream;
        long l = zzw2.zza();
        zzw2.close();
        return l;
        catch (Throwable throwable) {
            this.zzb = outputStream;
            throw throwable;
        }
    }

    private final <T> zzab zzj(ValueEncoder<T> valueEncoder, FieldDescriptor fieldDescriptor, T t, boolean bl) throws IOException {
        this.zzf.zza(fieldDescriptor, bl);
        valueEncoder.encode(t, (Object)this.zzf);
        return this;
    }

    private static ByteBuffer zzk(int n) {
        return ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
    }

    private static int zzl(FieldDescriptor object) {
        if ((object = (zzz)object.getProperty(zzz.class)) == null) {
            object = new EncodingException("Field has no @Protobuf config");
            throw object;
        }
        return object.zza();
    }

    private static zzz zzm(FieldDescriptor object) {
        if ((object = (zzz)object.getProperty(zzz.class)) == null) {
            object = new EncodingException("Field has no @Protobuf config");
            throw object;
        }
        return object;
    }

    private final void zzn(int n) throws IOException {
        while ((long)(n & 0xFFFFFF80) != 0L) {
            this.zzb.write(n & 0x7F | 0x80);
            n >>>= 7;
        }
        this.zzb.write(n & 0x7F);
    }

    private final void zzo(long l) throws IOException {
        long l2 = l;
        while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.zzb.write((int)l2 & 0x7F | 0x80);
            l2 >>>= 7;
        }
        this.zzb.write((int)l2 & 0x7F);
    }

    static final /* synthetic */ void zzg(Map.Entry entry, ObjectEncoderContext objectEncoderContext) throws IOException {
        objectEncoderContext.add(zzg, entry.getKey());
        objectEncoderContext.add(zzh, entry.getValue());
    }

    static {
        FieldDescriptor.Builder builder = FieldDescriptor.builder((String)"key");
        zzv zzv2 = new zzv();
        zzv2.zza(1);
        zzg = builder.withProperty((Annotation)zzv2.zzb()).build();
        builder = FieldDescriptor.builder((String)"value");
        zzv2 = new zzv();
        zzv2.zza(2);
        zzh = builder.withProperty((Annotation)zzv2.zzb()).build();
        zzi = zzaa.zza;
    }
}

