/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.stats.WakeLock;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class WakeLockHolder {
    private static final long WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS;
    private static final Object syncObject;
    @GuardedBy(value="WakeLockHolder.syncObject")
    private static WakeLock wakeLock;

    @GuardedBy(value="WakeLockHolder.syncObject")
    private static void checkAndInitWakeLock(Context context) {
        if (wakeLock == null) {
            WakeLock wakeLock;
            WakeLockHolder.wakeLock = wakeLock = new WakeLock(context, 1, "wake:com.google.firebase.iid.WakeLockHolder");
            WakeLockHolder.wakeLock.setReferenceCounted(true);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ComponentName startWakefulService(@NonNull Context context, @NonNull Intent intent) {
        Object object = syncObject;
        synchronized (object) {
            WakeLockHolder.checkAndInitWakeLock(context);
            boolean bl = WakeLockHolder.isWakefulIntent(intent);
            WakeLockHolder.setAsWakefulIntent(intent, true);
            context = context.startService(intent);
            if (context == null) {
                return null;
            }
            if (bl) return context;
            wakeLock.acquire(WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS);
            return context;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    private static void setAsWakefulIntent(@NonNull Intent intent, boolean bl) {
        intent.putExtra("com.google.firebase.iid.WakeLockHolder.wakefulintent", bl);
    }

    @VisibleForTesting
    static boolean isWakefulIntent(@NonNull Intent intent) {
        return intent.getBooleanExtra("com.google.firebase.iid.WakeLockHolder.wakefulintent", false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void completeWakefulIntent(@NonNull Intent intent) {
        Object object = syncObject;
        synchronized (object) {
            WakeLock wakeLock = WakeLockHolder.wakeLock;
            if (wakeLock == null) return;
            boolean bl = WakeLockHolder.isWakefulIntent(intent);
            if (!bl) return;
            WakeLockHolder.setAsWakefulIntent(intent, false);
            WakeLockHolder.wakeLock.release();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static {
        Object object;
        WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(1L);
        syncObject = object = new Object();
    }
}

