/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class Store {
    final SharedPreferences store;
    final Context context;

    public Store(Context context) {
        this.context = context;
        this.store = context.getSharedPreferences("com.google.android.gms.appid", 0);
        this.checkForRestore("com.google.android.gms.appid-no-backup");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkForRestore(String object) {
        object = this.context;
        File file = new File((File)(object = ContextCompat.getNoBackupFilesDir((Context)object)), "com.google.android.gms.appid-no-backup");
        if (file.exists()) {
            return;
        }
        try {
            boolean bl = file.createNewFile();
            if (!bl || (bl = this.isEmpty())) return;
            Log.i((String)"FirebaseMessaging", (String)"App restored, clearing state");
            this.deleteAll();
            return;
        }
        catch (IOException iOException) {
            if (!Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                return;
            }
            String string = String.valueOf(iOException.getMessage());
            object = "Error creating file in no backup dir: ";
            string = string.length() != 0 ? ((String)object).concat(string) : new String((String)object);
            Log.d((String)"FirebaseMessaging", (String)string);
            return;
        }
    }

    public synchronized boolean isEmpty() {
        return this.store.getAll().isEmpty();
    }

    private String createTokenKey(String string, String string2) {
        String string3 = String.valueOf(string);
        int n = string3.length();
        String string4 = String.valueOf(string2);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 5 + n2);
        stringBuilder.append(string);
        stringBuilder.append("|T|");
        stringBuilder.append(string2);
        stringBuilder.append("|*");
        return stringBuilder.toString();
    }

    public synchronized void deleteAll() {
        this.store.edit().clear().commit();
    }

    public synchronized Token getToken(String string, String string2) {
        return Token.parse(this.store.getString(this.createTokenKey(string, string2), null));
    }

    public synchronized void saveToken(String string, String string2, String string3, String string4) {
        if ((string3 = Token.encode(string3, string4, System.currentTimeMillis())) == null) {
            return;
        }
        string4 = this.store.edit();
        string4.putString(this.createTokenKey(string, string2), string3);
        string4.commit();
    }

    public synchronized void deleteToken(String string, String string2) {
        string = store.createTokenKey(string, string2);
        Store store = store.store.edit();
        store.remove(string);
        store.commit();
    }

    static class Token {
        private static final long REFRESH_PERIOD_MILLIS = TimeUnit.DAYS.toMillis(7L);
        final String token;
        final String appVersion;
        final long timestamp;

        private Token(String string, String string2, long l) {
            this.token = string;
            this.appVersion = string2;
            this.timestamp = l;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Token parse(String object) {
            if (TextUtils.isEmpty((CharSequence)object)) {
                return null;
            }
            if (!((String)object).startsWith("{")) return new Token((String)object, null, 0L);
            try {
                JSONObject jSONObject = new JSONObject((String)object);
                return new Token(jSONObject.getString("token"), jSONObject.getString("appVersion"), jSONObject.getLong("timestamp"));
            }
            catch (JSONException jSONException) {
                String string = String.valueOf((Object)jSONException);
                String string2 = String.valueOf(string);
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 23);
                stringBuilder.append("Failed to parse token: ");
                stringBuilder.append(string);
                Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
                return null;
            }
        }

        static String encode(String string, String string2, long l) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("token", (Object)string);
                jSONObject.put("appVersion", (Object)string2);
                jSONObject.put("timestamp", l);
                string = jSONObject.toString();
                return string;
            }
            catch (JSONException jSONException) {
                String string3 = String.valueOf((Object)jSONException);
                string2 = String.valueOf(string3);
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 24);
                stringBuilder.append("Failed to encode token: ");
                stringBuilder.append(string3);
                Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
                return null;
            }
        }

        boolean needsRefresh(String string) {
            return System.currentTimeMillis() > this.timestamp + REFRESH_PERIOD_MILLIS || !string.equals(this.appVersion);
        }
    }
}

