/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.WakeLockHolder;
import com.google.firebase.iid.WithinAppServiceBinder;
import com.google.firebase.messaging.EnhancedIntentService$$Lambda$0;
import com.google.firebase.messaging.EnhancedIntentService$$Lambda$1;
import com.google.firebase.messaging.EnhancedIntentService$$Lambda$2;
import com.google.firebase.messaging.FcmExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@SuppressLint(value={"UnwrappedWakefulBroadcastReceiver"})
public abstract class EnhancedIntentService
extends Service {
    @VisibleForTesting
    final ExecutorService executor = FcmExecutors.newIntentHandleExecutor();
    private Binder binder;
    private final Object lock;
    private int lastStartId;
    private int runningTasks;

    public EnhancedIntentService() {
        Object object;
        this.lock = object = new Object();
        this.runningTasks = 0;
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"Service received bind request");
        }
        if (this.binder == null) {
            WithinAppServiceBinder.IntentHandler intentHandler = new WithinAppServiceBinder.IntentHandler(){

                @KeepForSdk
                public Task<Void> handle(Intent intent) {
                    return EnhancedIntentService.this.processIntent(intent);
                }
            };
            intent = new WithinAppServiceBinder(intentHandler);
            this.binder = intent;
        }
        return this.binder;
    }

    @MainThread
    private Task<Void> processIntent(Intent intent) {
        if (this.handleIntentOnMainThread(intent)) {
            return Tasks.forResult(null);
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        ExecutorService executorService = this.executor;
        EnhancedIntentService$$Lambda$0 enhancedIntentService$$Lambda$0 = new EnhancedIntentService$$Lambda$0(this, intent, taskCompletionSource);
        executorService.execute(enhancedIntentService$$Lambda$0);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int onStartCommand(Intent intent, int n, int n2) {
        Task<Void> task = this.lock;
        synchronized (task) {
            this.lastStartId = n2;
            ++this.runningTasks;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var2_4
            task = this.getStartCommandIntent(intent);
            if (task == null) {
                this.finishTask(intent);
                return 2;
            }
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        if ((task = this.processIntent((Intent)task)).isComplete()) {
            this.finishTask(intent);
            return 2;
        }
        Executor executor = EnhancedIntentService$$Lambda$1.$instance;
        EnhancedIntentService$$Lambda$2 enhancedIntentService$$Lambda$2 = new EnhancedIntentService$$Lambda$2(this, intent);
        task.addOnCompleteListener(executor, (OnCompleteListener)enhancedIntentService$$Lambda$2);
        return 3;
    }

    @CallSuper
    public void onDestroy() {
        this.executor.shutdown();
        super.onDestroy();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishTask(Intent object) {
        if (object != null) {
            WakeLockHolder.completeWakefulIntent((Intent)object);
        }
        object = this.lock;
        synchronized (object) {
            int n = this.runningTasks;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            {
                this.runningTasks = --n;
                if (n != 0) return;
                this.stopSelfResultHook(this.lastStartId);
                return;
            }
        }
    }

    boolean stopSelfResultHook(int n) {
        return this.stopSelfResult(n);
    }

    protected Intent getStartCommandIntent(Intent intent) {
        return intent;
    }

    public boolean handleIntentOnMainThread(Intent intent) {
        return false;
    }

    public abstract void handleIntent(Intent var1);

    final /* synthetic */ void lambda$onStartCommand$1$EnhancedIntentService(Intent intent, Task task) {
        this.finishTask(intent);
    }

    final /* synthetic */ void lambda$processIntent$0$EnhancedIntentService(Intent intent, TaskCompletionSource taskCompletionSource) {
        try {
            this.handleIntent(intent);
        }
        finally {
            taskCompletionSource.setResult(null);
        }
    }
}

