/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.GmsRpc;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.Metadata;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.TopicOperation;
import com.google.firebase.messaging.TopicsStore;
import com.google.firebase.messaging.TopicsSubscriber$$Lambda$0;
import com.google.firebase.messaging.TopicsSyncTask;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class TopicsSubscriber {
    private static final long MAX_DELAY_SEC = TimeUnit.HOURS.toSeconds(8L);
    private final FirebaseInstanceId iid;
    private final Context context;
    private final Metadata metadata;
    private final GmsRpc rpc;
    @GuardedBy(value="pendingOperations")
    private final Map<String, ArrayDeque<TaskCompletionSource<Void>>> pendingOperations = new ArrayMap();
    private final ScheduledExecutorService syncExecutor;
    @GuardedBy(value="this")
    private boolean syncScheduledOrRunning = false;
    private final TopicsStore store;

    static Task<TopicsSubscriber> createInstance(FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, Metadata metadata, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi, Context context, @NonNull ScheduledExecutorService scheduledExecutorService) {
        return TopicsSubscriber.createInstance(firebaseInstanceId, metadata, new GmsRpc(firebaseApp, metadata, provider, provider2, firebaseInstallationsApi), context, scheduledExecutorService);
    }

    @VisibleForTesting
    static Task<TopicsSubscriber> createInstance(FirebaseInstanceId firebaseInstanceId, Metadata metadata, GmsRpc gmsRpc, Context context, @NonNull ScheduledExecutorService scheduledExecutorService) {
        return Tasks.call((Executor)scheduledExecutorService, (Callable)new TopicsSubscriber$$Lambda$0(context, scheduledExecutorService, firebaseInstanceId, metadata, gmsRpc));
    }

    private TopicsSubscriber(FirebaseInstanceId firebaseInstanceId, Metadata metadata, TopicsStore topicsStore, GmsRpc gmsRpc, Context context, @NonNull ScheduledExecutorService scheduledExecutorService) {
        this.iid = firebaseInstanceId;
        this.metadata = metadata;
        this.store = topicsStore;
        this.rpc = gmsRpc;
        this.context = context;
        this.syncExecutor = scheduledExecutorService;
    }

    Task<Void> subscribeToTopic(String string) {
        Task<Void> task = this.scheduleTopicOperation(TopicOperation.subscribe(string));
        this.startTopicsSyncIfNecessary();
        return task;
    }

    Task<Void> unsubscribeFromTopic(String string) {
        Task<Void> task = this.scheduleTopicOperation(TopicOperation.unsubscribe(string));
        this.startTopicsSyncIfNecessary();
        return task;
    }

    @VisibleForTesting
    Task<Void> scheduleTopicOperation(TopicOperation topicOperation) {
        this.store.addTopicOperation(topicOperation);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.addToPendingOperations(topicOperation, (TaskCompletionSource<Void>)taskCompletionSource);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPendingOperations(TopicOperation topicOperation, TaskCompletionSource<Void> taskCompletionSource) {
        Map<String, ArrayDeque<TaskCompletionSource<Void>>> map = this.pendingOperations;
        synchronized (map) {
            ArrayDeque<Object> arrayDeque;
            String string = topicOperation.serialize();
            if (this.pendingOperations.containsKey(string)) {
                arrayDeque = this.pendingOperations.get(string);
            } else {
                arrayDeque = new ArrayDeque();
                this.pendingOperations.put(string, arrayDeque);
            }
            arrayDeque.add(taskCompletionSource);
            return;
        }
    }

    boolean hasPendingOperation() {
        return this.store.getNextTopicOperation() != null;
    }

    void startTopicsSyncIfNecessary() {
        if (this.hasPendingOperation()) {
            this.startSync();
        }
    }

    private void startSync() {
        if (!this.isSyncScheduledOrRunning()) {
            this.syncWithDelaySecondsInternal(0L);
        }
    }

    void syncWithDelaySecondsInternal(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), MAX_DELAY_SEC);
        TopicsSyncTask topicsSyncTask = new TopicsSyncTask(this, this.context, this.metadata, l2);
        this.scheduleSyncTaskWithDelaySeconds(topicsSyncTask, l);
        this.setSyncScheduledOrRunning(true);
    }

    void scheduleSyncTaskWithDelaySeconds(Runnable runnable, long l) {
        this.syncExecutor.schedule(runnable, l, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    boolean syncTopics() throws IOException {
        while (true) {
            TopicOperation topicOperation;
            TopicsSubscriber topicsSubscriber = this;
            synchronized (topicsSubscriber) {
                topicOperation = this.store.getNextTopicOperation();
                if (topicOperation == null) {
                    if (TopicsSubscriber.isDebugLogEnabled()) {
                        Log.d((String)"FirebaseMessaging", (String)"topic sync succeeded");
                    }
                    return true;
                }
            }
            if (!this.performTopicOperation(topicOperation)) {
                return false;
            }
            this.store.removeTopicOperation(topicOperation);
            this.markCompletePendingOperation(topicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markCompletePendingOperation(TopicOperation topicOperation) {
        Map<String, ArrayDeque<TaskCompletionSource<Void>>> map = this.pendingOperations;
        synchronized (map) {
            String string = topicOperation.serialize();
            if (!this.pendingOperations.containsKey(string)) {
                return;
            }
            ArrayDeque<TaskCompletionSource<Void>> arrayDeque = this.pendingOperations.get(string);
            TaskCompletionSource<Void> taskCompletionSource = arrayDeque.poll();
            if (taskCompletionSource != null) {
                taskCompletionSource.setResult(null);
            }
            if (arrayDeque.isEmpty()) {
                this.pendingOperations.remove(string);
            }
            return;
        }
    }

    @WorkerThread
    boolean performTopicOperation(TopicOperation topicOperation) throws IOException {
        try {
            switch (topicOperation.getOperation()) {
                case "S": {
                    this.blockingSubscribeToTopic(topicOperation.getTopic());
                    if (TopicsSubscriber.isDebugLogEnabled()) {
                        String string = topicOperation.getTopic();
                        Log.d((String)"FirebaseMessaging", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Subscribe to topic: ").append(string).append(" succeeded.").toString());
                    }
                    break;
                }
                case "U": {
                    this.blockingUnsubscribeFromTopic(topicOperation.getTopic());
                    if (TopicsSubscriber.isDebugLogEnabled()) {
                        String string = topicOperation.getTopic();
                        Log.d((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string).length()).append("Unsubscribe from topic: ").append(string).append(" succeeded.").toString());
                    }
                    break;
                }
                default: {
                    if (TopicsSubscriber.isDebugLogEnabled()) {
                        String string = String.valueOf(topicOperation);
                        Log.d((String)"FirebaseMessaging", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Unknown topic operation").append(string).append(".").toString());
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            if ("SERVICE_NOT_AVAILABLE".equals(iOException.getMessage()) || "INTERNAL_SERVER_ERROR".equals(iOException.getMessage())) {
                String string = iOException.getMessage();
                Log.e((String)"FirebaseMessaging", (String)new StringBuilder(53 + String.valueOf(string).length()).append("Topic operation failed: ").append(string).append(". Will retry Topic operation.").toString());
                return false;
            }
            if (iOException.getMessage() == null) {
                Log.e((String)"FirebaseMessaging", (String)"Topic operation failed without exception message. Will retry Topic operation.");
                return false;
            }
            throw iOException;
        }
        return true;
    }

    @WorkerThread
    private void blockingSubscribeToTopic(String string) throws IOException {
        InstanceIdResult instanceIdResult = (InstanceIdResult)TopicsSubscriber.awaitTask(this.iid.getInstanceId());
        TopicsSubscriber.awaitTask(this.rpc.subscribeToTopic(instanceIdResult.getId(), instanceIdResult.getToken(), string));
    }

    @WorkerThread
    private void blockingUnsubscribeFromTopic(String string) throws IOException {
        InstanceIdResult instanceIdResult = (InstanceIdResult)TopicsSubscriber.awaitTask(this.iid.getInstanceId());
        TopicsSubscriber.awaitTask(this.rpc.unsubscribeFromTopic(instanceIdResult.getId(), instanceIdResult.getToken(), string));
    }

    @WorkerThread
    private static <T> T awaitTask(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE", exception);
        }
    }

    synchronized boolean isSyncScheduledOrRunning() {
        return this.syncScheduledOrRunning;
    }

    synchronized void setSyncScheduledOrRunning(boolean bl) {
        this.syncScheduledOrRunning = bl;
    }

    static boolean isDebugLogEnabled() {
        return Log.isLoggable((String)"FirebaseMessaging", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseMessaging", (int)3);
    }

    static final /* synthetic */ TopicsSubscriber lambda$createInstance$0$TopicsSubscriber(Context context, ScheduledExecutorService scheduledExecutorService, FirebaseInstanceId firebaseInstanceId, Metadata metadata, GmsRpc gmsRpc) throws Exception {
        TopicsStore topicsStore = TopicsStore.getInstance(context, scheduledExecutorService);
        return new TopicsSubscriber(firebaseInstanceId, metadata, topicsStore, gmsRpc, context, scheduledExecutorService);
    }
}

