/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.firebase_messaging.zzac;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzav;
import com.google.firebase.iid.zzb;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.zza;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FirebaseMessagingService
extends zzb {
    private static final Queue<String> zzdv = new ArrayDeque<String>(10);

    @WorkerThread
    public void onMessageReceived(RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(String string) {
    }

    @WorkerThread
    public void onSendError(String string, Exception exception) {
    }

    @WorkerThread
    public void onNewToken(String string) {
    }

    protected final Intent zzb(Intent intent) {
        return zzav.zzai().zzaj();
    }

    public final boolean zzc(Intent intent) {
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            Intent intent2 = intent;
            PendingIntent pendingIntent = (PendingIntent)intent2.getParcelableExtra("pending_intent");
            if (pendingIntent != null) {
                try {
                    pendingIntent.send();
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.e((String)"FirebaseMessaging", (String)"Notification pending intent canceled");
                }
            }
            if (MessagingAnalytics.shouldUploadMetrics(intent2)) {
                MessagingAnalytics.logNotificationOpen(intent2);
            }
            return true;
        }
        return false;
    }

    public final void zzd(Intent intent) {
        String string = intent.getAction();
        if ("com.google.android.c2dm.intent.RECEIVE".equals(string) || "com.google.firebase.messaging.RECEIVE_DIRECT_BOOT".equals(string)) {
            boolean bl;
            Object object;
            Task task;
            String string2;
            Intent intent2 = intent;
            FirebaseMessagingService firebaseMessagingService = this;
            String string3 = string2 = intent2.getStringExtra("google.message_id");
            Object object2 = firebaseMessagingService;
            if (TextUtils.isEmpty((CharSequence)string3)) {
                task = Tasks.forResult(null);
            } else {
                object = new Bundle();
                object.putString("google.message_id", string3);
                task = zzab.zzc((Context)object2).zza(2, object);
            }
            Task task2 = task;
            object2 = string2;
            if (TextUtils.isEmpty((CharSequence)object2)) {
                bl = false;
            } else if (zzdv.contains(object2)) {
                if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                    String string4 = String.valueOf(object2);
                    Log.d((String)"FirebaseMessaging", (String)(string4.length() != 0 ? "Received duplicate message: ".concat(string4) : new String("Received duplicate message: ")));
                }
                bl = true;
            } else {
                if (zzdv.size() >= 10) {
                    zzdv.remove();
                }
                zzdv.add((String)object2);
                bl = false;
            }
            if (!bl) {
                string3 = intent2;
                object2 = firebaseMessagingService;
                object = string3.getStringExtra("message_type");
                if (object == null) {
                    object = "gcm";
                }
                switch (object) {
                    case "gcm": {
                        if (MessagingAnalytics.shouldUploadMetrics((Intent)string3)) {
                            MessagingAnalytics.logNotificationReceived((Intent)string3);
                        }
                        String string5 = string3;
                        Object object3 = object2;
                        Bundle bundle = string5.getExtras();
                        if (bundle == null) {
                            bundle = new Bundle();
                        }
                        bundle.remove("android.support.content.wakelockid");
                        if (zzac.zzj(bundle)) {
                            if (new zza((Context)object3, bundle).zzar()) break;
                            if (MessagingAnalytics.shouldUploadMetrics((Intent)string5)) {
                                MessagingAnalytics.logNotificationForeground((Intent)string5);
                            }
                        }
                        ((FirebaseMessagingService)((Object)object3)).onMessageReceived(new RemoteMessage(bundle));
                        break;
                    }
                    case "deleted_messages": {
                        ((FirebaseMessagingService)((Object)object2)).onDeletedMessages();
                        break;
                    }
                    case "send_event": {
                        ((FirebaseMessagingService)((Object)object2)).onMessageSent(string3.getStringExtra("google.message_id"));
                        break;
                    }
                    case "send_error": {
                        String string6 = string3;
                        String string7 = string6.getStringExtra("google.message_id");
                        if (string7 == null) {
                            string7 = string6.getStringExtra("message_id");
                        }
                        ((FirebaseMessagingService)((Object)object2)).onSendError(string7, new SendException(string3.getStringExtra("error")));
                        break;
                    }
                    default: {
                        String string8 = String.valueOf(object);
                        Log.w((String)"FirebaseMessaging", (String)(string8.length() != 0 ? "Received message with unknown type: ".concat(string8) : new String("Received message with unknown type: ")));
                    }
                }
            }
            try {
                Tasks.await((Task)task2, (long)1L, (TimeUnit)TimeUnit.SECONDS);
                return;
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                String string9 = String.valueOf(exception);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(20 + String.valueOf(string9).length()).append("Message ack failed: ").append(string9).toString());
                return;
            }
        }
        if ("com.google.firebase.messaging.NOTIFICATION_DISMISS".equals(string)) {
            if (MessagingAnalytics.shouldUploadMetrics(intent)) {
                MessagingAnalytics.logNotificationDismiss(intent);
                return;
            }
        } else {
            if ("com.google.firebase.messaging.NEW_TOKEN".equals(string)) {
                this.onNewToken(intent.getStringExtra("token"));
                return;
            }
            String string10 = String.valueOf(intent.getAction());
            Log.d((String)"FirebaseMessaging", (String)(string10.length() != 0 ? "Unknown intent action: ".concat(string10) : new String("Unknown intent action: ")));
        }
    }
}

