/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzc;
import com.google.firebase.messaging.zzd;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RemoteMessageCreator")
public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzd();
    @SafeParcelable.Field(id=2)
    Bundle zzdm;
    private Map<String, String> zzdn;
    private Notification zzdo;

    @SafeParcelable.Constructor
    public RemoteMessage(@SafeParcelable.Param(id=2) Bundle bundle) {
        this.zzdm = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)2, (Bundle)remoteMessage.zzdm, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getFrom() {
        return this.zzdm.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.zzdm.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzdn == null) {
            this.zzdn = new ArrayMap();
            for (String string2 : this.zzdm.keySet()) {
                Object object = this.zzdm.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                this.zzdn.put(string2, string3);
            }
        }
        return this.zzdn;
    }

    @Nullable
    public final String getCollapseKey() {
        return this.zzdm.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string2 = this.zzdm.getString("google.message_id");
        if (string2 == null) {
            string2 = this.zzdm.getString("message_id");
        }
        return string2;
    }

    @Nullable
    public final String getMessageType() {
        return this.zzdm.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.zzdm.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.zzdm.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    public final int getOriginalPriority() {
        String string2 = this.zzdm.getString("google.original_priority");
        if (string2 == null) {
            string2 = this.zzdm.getString("google.priority");
        }
        return RemoteMessage.zzo(string2);
    }

    public final int getPriority() {
        String string2 = this.zzdm.getString("google.delivered_priority");
        if (string2 == null) {
            if ("1".equals(this.zzdm.getString("google.priority_reduced"))) {
                return 2;
            }
            string2 = this.zzdm.getString("google.priority");
        }
        return RemoteMessage.zzo(string2);
    }

    private static int zzo(String string2) {
        if ("high".equals(string2)) {
            return 1;
        }
        if ("normal".equals(string2)) {
            return 2;
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.zzdo == null && zza.zzf(this.zzdm)) {
            this.zzdo = new Notification(this.zzdm, null);
        }
        return this.zzdo;
    }

    public static class Notification {
        private final String zzdp;
        private final String zzdq;
        private final String[] zzdr;
        private final String zzds;
        private final String zzdt;
        private final String[] zzdu;
        private final String zzdv;
        private final String zzdw;
        private final String tag;
        private final String zzdx;
        private final String zzdy;
        private final Uri zzdz;

        private Notification(Bundle bundle) {
            this.zzdp = zza.zza(bundle, "gcm.n.title");
            this.zzdq = zza.zzb(bundle, "gcm.n.title");
            this.zzdr = Notification.zze(bundle, "gcm.n.title");
            this.zzds = zza.zza(bundle, "gcm.n.body");
            this.zzdt = zza.zzb(bundle, "gcm.n.body");
            this.zzdu = Notification.zze(bundle, "gcm.n.body");
            this.zzdv = zza.zza(bundle, "gcm.n.icon");
            this.zzdw = zza.zzi(bundle);
            this.tag = zza.zza(bundle, "gcm.n.tag");
            this.zzdx = zza.zza(bundle, "gcm.n.color");
            this.zzdy = zza.zza(bundle, "gcm.n.click_action");
            this.zzdz = zza.zzg(bundle);
        }

        private static String[] zze(Bundle bundle, String string2) {
            Object[] objectArray = zza.zzc(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzdp;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzdq;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzdr;
        }

        @Nullable
        public String getBody() {
            return this.zzds;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzdt;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzdu;
        }

        @Nullable
        public String getIcon() {
            return this.zzdv;
        }

        @Nullable
        public String getSound() {
            return this.zzdw;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getColor() {
            return this.zzdx;
        }

        @Nullable
        public String getClickAction() {
            return this.zzdy;
        }

        @Nullable
        public Uri getLink() {
            return this.zzdz;
        }

        /* synthetic */ Notification(Bundle bundle, zzc zzc2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle zzdm = new Bundle();
        private final Map<String, String> zzdn = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.zzdm.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzdn.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzdm);
            this.zzdm.remove("from");
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzdn.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzdn.clear();
            this.zzdn.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzdn.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.zzdm.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.zzdm.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.zzdm.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.zzdm.putString("collapse_key", string2);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }
}

