/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zze;
import com.google.firebase.messaging.zzf;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RemoteMessageCreator")
public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzf();
    @SafeParcelable.Field(id=2)
    Bundle zzafw;
    private Map<String, String> zzrr;
    private Notification zzbst;

    @SafeParcelable.Constructor
    public RemoteMessage(@SafeParcelable.Param(id=2) Bundle bundle) {
        this.zzafw = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)2, (Bundle)remoteMessage.zzafw, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getFrom() {
        return this.zzafw.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.zzafw.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzrr == null) {
            this.zzrr = new ArrayMap();
            for (String string2 : this.zzafw.keySet()) {
                Object object = this.zzafw.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                this.zzrr.put(string2, string3);
            }
        }
        return this.zzrr;
    }

    @Nullable
    public final String getCollapseKey() {
        return this.zzafw.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string2 = this.zzafw.getString("google.message_id");
        if (string2 == null) {
            string2 = this.zzafw.getString("message_id");
        }
        return string2;
    }

    @Nullable
    public final String getMessageType() {
        return this.zzafw.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.zzafw.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.zzafw.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.zzbst == null && zza.zzl(this.zzafw)) {
            this.zzbst = new Notification(this.zzafw, null);
        }
        return this.zzbst;
    }

    public static class Notification {
        private final String zzbsu;
        private final String zzbsv;
        private final String[] zzbsw;
        private final String zzbsx;
        private final String zzbsy;
        private final String[] zzbsz;
        private final String zzbta;
        private final String zzbtb;
        private final String tag;
        private final String zzbtc;
        private final String zzbtd;
        private final Uri zzbte;

        private Notification(Bundle bundle) {
            this.zzbsu = zza.zza(bundle, "gcm.n.title");
            this.zzbsv = zza.zzb(bundle, "gcm.n.title");
            this.zzbsw = Notification.zze(bundle, "gcm.n.title");
            this.zzbsx = zza.zza(bundle, "gcm.n.body");
            this.zzbsy = zza.zzb(bundle, "gcm.n.body");
            this.zzbsz = Notification.zze(bundle, "gcm.n.body");
            this.zzbta = zza.zza(bundle, "gcm.n.icon");
            this.zzbtb = zza.zzo(bundle);
            this.tag = zza.zza(bundle, "gcm.n.tag");
            this.zzbtc = zza.zza(bundle, "gcm.n.color");
            this.zzbtd = zza.zza(bundle, "gcm.n.click_action");
            this.zzbte = zza.zzm(bundle);
        }

        private static String[] zze(Bundle bundle, String string2) {
            Object[] objectArray = zza.zzc(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzbsu;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzbsv;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzbsw;
        }

        @Nullable
        public String getBody() {
            return this.zzbsx;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzbsy;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzbsz;
        }

        @Nullable
        public String getIcon() {
            return this.zzbta;
        }

        @Nullable
        public String getSound() {
            return this.zzbtb;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getColor() {
            return this.zzbtc;
        }

        @Nullable
        public String getClickAction() {
            return this.zzbtd;
        }

        @Nullable
        public Uri getLink() {
            return this.zzbte;
        }

        /* synthetic */ Notification(Bundle bundle, zze zze2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle zzafw = new Bundle();
        private final Map<String, String> zzrr = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.zzafw.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzrr.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzafw);
            this.zzafw.remove("from");
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzrr.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzrr.clear();
            this.zzrr.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzrr.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.zzafw.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.zzafw.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.zzafw.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.zzafw.putString("collapse_key", string2);
            return this;
        }
    }
}

