/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zze;
import com.google.firebase.messaging.zzf;
import java.util.Map;

public final class RemoteMessage
extends zzbej {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzf();
    Bundle mBundle;
    private Map<String, String> zzdms;
    private Notification zznwg;

    RemoteMessage(Bundle bundle) {
        this.mBundle = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (Bundle)remoteMessage.mBundle, (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getFrom() {
        return this.mBundle.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.mBundle.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzdms == null) {
            this.zzdms = new ArrayMap();
            for (String string2 : this.mBundle.keySet()) {
                Object object = this.mBundle.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                this.zzdms.put(string2, string3);
            }
        }
        return this.zzdms;
    }

    @Nullable
    public final String getCollapseKey() {
        return this.mBundle.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string2 = this.mBundle.getString("google.message_id");
        if (string2 == null) {
            string2 = this.mBundle.getString("message_id");
        }
        return string2;
    }

    @Nullable
    public final String getMessageType() {
        return this.mBundle.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.mBundle.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.mBundle.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.zznwg == null && zza.zzah(this.mBundle)) {
            this.zznwg = new Notification(this.mBundle, null);
        }
        return this.zznwg;
    }

    public static class Notification {
        private final String zzekd;
        private final String zznwh;
        private final String[] zznwi;
        private final String zzbrz;
        private final String zznwj;
        private final String[] zznwk;
        private final String zznwl;
        private final String zznwm;
        private final String mTag;
        private final String zznwn;
        private final String zznwo;
        private final Uri zznwp;

        private Notification(Bundle bundle) {
            this.zzekd = zza.zze(bundle, "gcm.n.title");
            this.zznwh = zza.zzh(bundle, "gcm.n.title");
            this.zznwi = Notification.zzk(bundle, "gcm.n.title");
            this.zzbrz = zza.zze(bundle, "gcm.n.body");
            this.zznwj = zza.zzh(bundle, "gcm.n.body");
            this.zznwk = Notification.zzk(bundle, "gcm.n.body");
            this.zznwl = zza.zze(bundle, "gcm.n.icon");
            this.zznwm = zza.zzaj(bundle);
            this.mTag = zza.zze(bundle, "gcm.n.tag");
            this.zznwn = zza.zze(bundle, "gcm.n.color");
            this.zznwo = zza.zze(bundle, "gcm.n.click_action");
            this.zznwp = zza.zzai(bundle);
        }

        private static String[] zzk(Bundle bundle, String string2) {
            Object[] objectArray = zza.zzi(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzekd;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zznwh;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zznwi;
        }

        @Nullable
        public String getBody() {
            return this.zzbrz;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zznwj;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zznwk;
        }

        @Nullable
        public String getIcon() {
            return this.zznwl;
        }

        @Nullable
        public String getSound() {
            return this.zznwm;
        }

        @Nullable
        public String getTag() {
            return this.mTag;
        }

        @Nullable
        public String getColor() {
            return this.zznwn;
        }

        @Nullable
        public String getClickAction() {
            return this.zznwo;
        }

        @Nullable
        public Uri getLink() {
            return this.zznwp;
        }

        /* synthetic */ Notification(Bundle bundle, zze zze2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle mBundle = new Bundle();
        private final Map<String, String> zzdms = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.mBundle.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzdms.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.mBundle);
            String string2 = FirebaseInstanceId.getInstance().getToken();
            if (string2 != null) {
                this.mBundle.putString("from", string2);
            } else {
                this.mBundle.remove("from");
            }
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzdms.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzdms.clear();
            this.zzdms.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzdms.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.mBundle.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.mBundle.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.mBundle.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.mBundle.putString("collapse_key", string2);
            return this;
        }
    }
}

