/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzg;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzd;
import java.util.Iterator;

public class FirebaseMessagingService
extends zzb {
    @WorkerThread
    public void onMessageReceived(RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(String string2) {
    }

    @WorkerThread
    public void onSendError(String string2, Exception exception) {
    }

    protected Intent zzD(Intent intent) {
        return zzg.zzabW().zzabY();
    }

    public boolean zzE(Intent intent) {
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            this.zzI(intent);
            return true;
        }
        return false;
    }

    private void zzI(Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("pending_intent");
        if (pendingIntent != null) {
            try {
                pendingIntent.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e((String)"FirebaseMessaging", (String)"Notification pending intent canceled");
            }
        }
        if (FirebaseMessagingService.zzZ(intent.getExtras())) {
            zzd.zzj((Context)this, intent);
        }
    }

    public void handleIntent(Intent intent) {
        String string2 = intent.getAction();
        if (string2 == null) {
            string2 = "";
        }
        switch (string2) {
            case "com.google.android.c2dm.intent.RECEIVE": {
                this.zzJ(intent);
                break;
            }
            case "com.google.firebase.messaging.NOTIFICATION_DISMISS": {
                if (!FirebaseMessagingService.zzZ(intent.getExtras())) break;
                zzd.zzk((Context)this, intent);
                break;
            }
            default: {
                String string3 = String.valueOf(intent.getAction());
                Log.d((String)"FirebaseMessaging", (String)(string3.length() != 0 ? "Unknown intent action: ".concat(string3) : new String("Unknown intent action: ")));
            }
        }
    }

    private void zzJ(Intent intent) {
        String string2 = intent.getStringExtra("message_type");
        if (string2 == null) {
            string2 = "gcm";
        }
        switch (string2) {
            case "gcm": {
                if (FirebaseMessagingService.zzZ(intent.getExtras())) {
                    zzd.zzi((Context)this, intent);
                }
                this.zzl(intent);
                break;
            }
            case "deleted_messages": {
                this.onDeletedMessages();
                break;
            }
            case "send_event": {
                this.onMessageSent(intent.getStringExtra("google.message_id"));
                break;
            }
            case "send_error": {
                this.onSendError(this.zzm(intent), new SendException(intent.getStringExtra("error")));
                break;
            }
            default: {
                String string3 = String.valueOf(string2);
                Log.w((String)"FirebaseMessaging", (String)(string3.length() != 0 ? "Received message with unknown type: ".concat(string3) : new String("Received message with unknown type: ")));
            }
        }
    }

    private void zzl(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.remove("android.support.content.wakelockid");
        if (zza.zzE(bundle)) {
            if (zza.zzcy((Context)this).zzG(bundle)) {
                return;
            }
            if (FirebaseMessagingService.zzZ(bundle)) {
                zzd.zzl((Context)this, intent);
            }
        }
        this.onMessageReceived(new RemoteMessage(bundle));
    }

    private String zzm(Intent intent) {
        String string2 = intent.getStringExtra("google.message_id");
        if (string2 == null) {
            string2 = intent.getStringExtra("message_id");
        }
        return string2;
    }

    static void zzD(Bundle bundle) {
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null || !string2.startsWith("google.c.")) continue;
            iterator.remove();
        }
    }

    static boolean zzZ(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        return "1".equals(bundle.getString("google.c.a.e"));
    }
}

