/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.CrossProcessLock;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.installations.FirebaseInstallationsException;
import com.google.firebase.installations.GetAuthTokenListener;
import com.google.firebase.installations.GetIdListener;
import com.google.firebase.installations.InstallationTokenResult;
import com.google.firebase.installations.RandomFidGenerator;
import com.google.firebase.installations.StateListener;
import com.google.firebase.installations.Utils;
import com.google.firebase.installations.internal.FidListener;
import com.google.firebase.installations.internal.FidListenerHandle;
import com.google.firebase.installations.local.IidStore;
import com.google.firebase.installations.local.PersistedInstallation;
import com.google.firebase.installations.local.PersistedInstallationEntry;
import com.google.firebase.installations.remote.FirebaseInstallationServiceClient;
import com.google.firebase.installations.remote.InstallationResponse;
import com.google.firebase.installations.remote.TokenResult;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FirebaseInstallations
implements FirebaseInstallationsApi {
    private final FirebaseApp firebaseApp;
    private final FirebaseInstallationServiceClient serviceClient;
    private final PersistedInstallation persistedInstallation;
    private final Utils utils;
    private final IidStore iidStore;
    private final RandomFidGenerator fidGenerator;
    private final Object lock = new Object();
    private final ExecutorService backgroundExecutor;
    private final ExecutorService networkExecutor;
    @GuardedBy(value="this")
    private String cachedFid;
    @GuardedBy(value="FirebaseInstallations.this")
    private Set<FidListener> fidListeners = new HashSet<FidListener>();
    @GuardedBy(value="lock")
    private final List<StateListener> listeners = new ArrayList<StateListener>();
    private static final Object lockGenerateFid = new Object();
    private static final String LOCKFILE_NAME_GENERATE_FID = "generatefid.lock";
    private static final String CHIME_FIREBASE_APP_NAME = "CHIME_ANDROID_SDK";
    private static final int CORE_POOL_SIZE = 0;
    private static final int MAXIMUM_POOL_SIZE = 1;
    private static final long KEEP_ALIVE_TIME_IN_SECONDS = 30L;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, String.format("firebase-installations-executor-%d", this.mCount.getAndIncrement()));
        }
    };
    private static final String API_KEY_VALIDATION_MSG = "Please set a valid API key. A Firebase API key is required to communicate with Firebase server APIs: It authenticates your project with Google.Please refer to https://firebase.google.com/support/privacy/init-options.";
    private static final String APP_ID_VALIDATION_MSG = "Please set your Application ID. A valid Firebase App ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.Please refer to https://firebase.google.com/support/privacy/init-options.";
    private static final String PROJECT_ID_VALIDATION_MSG = "Please set your Project ID. A valid Firebase Project ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.Please refer to https://firebase.google.com/support/privacy/init-options.";
    private static final String AUTH_ERROR_MSG = "Installation ID could not be validated with the Firebase servers (maybe it was deleted). Firebase Installations will need to create a new Installation ID and auth token. Please retry your last request.";

    FirebaseInstallations(FirebaseApp firebaseApp, @NonNull Provider<UserAgentPublisher> publisher, @NonNull Provider<HeartBeatInfo> heartbeatInfo) {
        this(new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY), firebaseApp, new FirebaseInstallationServiceClient(firebaseApp.getApplicationContext(), publisher, heartbeatInfo), new PersistedInstallation(firebaseApp), Utils.getInstance(), new IidStore(firebaseApp), new RandomFidGenerator());
    }

    FirebaseInstallations(ExecutorService backgroundExecutor, FirebaseApp firebaseApp, FirebaseInstallationServiceClient serviceClient, PersistedInstallation persistedInstallation, Utils utils, IidStore iidStore, RandomFidGenerator fidGenerator) {
        this.firebaseApp = firebaseApp;
        this.serviceClient = serviceClient;
        this.persistedInstallation = persistedInstallation;
        this.utils = utils;
        this.iidStore = iidStore;
        this.fidGenerator = fidGenerator;
        this.backgroundExecutor = backgroundExecutor;
        this.networkExecutor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY);
    }

    private void preConditionChecks() {
        Preconditions.checkNotEmpty((String)this.getApplicationId(), (Object)APP_ID_VALIDATION_MSG);
        Preconditions.checkNotEmpty((String)this.getProjectIdentifier(), (Object)PROJECT_ID_VALIDATION_MSG);
        Preconditions.checkNotEmpty((String)this.getApiKey(), (Object)API_KEY_VALIDATION_MSG);
        Preconditions.checkArgument((boolean)Utils.isValidAppIdFormat(this.getApplicationId()), (Object)APP_ID_VALIDATION_MSG);
        Preconditions.checkArgument((boolean)Utils.isValidApiKeyFormat(this.getApiKey()), (Object)API_KEY_VALIDATION_MSG);
    }

    @Nullable
    String getProjectIdentifier() {
        return this.firebaseApp.getOptions().getProjectId();
    }

    @NonNull
    public static FirebaseInstallations getInstance() {
        FirebaseApp defaultFirebaseApp = FirebaseApp.getInstance();
        return FirebaseInstallations.getInstance(defaultFirebaseApp);
    }

    @NonNull
    public static FirebaseInstallations getInstance(@NonNull FirebaseApp app) {
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"Null is not a valid value of FirebaseApp.");
        return (FirebaseInstallations)app.get(FirebaseInstallationsApi.class);
    }

    @VisibleForTesting
    String getApplicationId() {
        return this.firebaseApp.getOptions().getApplicationId();
    }

    @Nullable
    String getApiKey() {
        return this.firebaseApp.getOptions().getApiKey();
    }

    @VisibleForTesting
    String getName() {
        return this.firebaseApp.getName();
    }

    @NonNull
    public Task<String> getId() {
        this.preConditionChecks();
        String fid = this.getCacheFid();
        if (fid != null) {
            return Tasks.forResult((Object)fid);
        }
        Task<String> task = this.addGetIdListener();
        this.backgroundExecutor.execute(() -> this.doRegistrationOrRefresh(false));
        return task;
    }

    @NonNull
    public Task<InstallationTokenResult> getToken(boolean forceRefresh) {
        this.preConditionChecks();
        Task<InstallationTokenResult> task = this.addGetAuthTokenListener();
        this.backgroundExecutor.execute(() -> this.doRegistrationOrRefresh(forceRefresh));
        return task;
    }

    @NonNull
    public Task<Void> delete() {
        return Tasks.call((Executor)this.backgroundExecutor, this::deleteFirebaseInstallationId);
    }

    @NonNull
    public synchronized FidListenerHandle registerFidListener(final @NonNull FidListener listener) {
        this.fidListeners.add(listener);
        return new FidListenerHandle(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unregister() {
                FirebaseInstallations firebaseInstallations = FirebaseInstallations.this;
                synchronized (firebaseInstallations) {
                    FirebaseInstallations.this.fidListeners.remove(listener);
                }
            }
        };
    }

    private Task<String> addGetIdListener() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        GetIdListener l = new GetIdListener((TaskCompletionSource<String>)taskCompletionSource);
        this.addStateListeners(l);
        return taskCompletionSource.getTask();
    }

    private Task<InstallationTokenResult> addGetAuthTokenListener() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        GetAuthTokenListener l = new GetAuthTokenListener(this.utils, (TaskCompletionSource<InstallationTokenResult>)taskCompletionSource);
        this.addStateListeners(l);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStateListeners(StateListener l) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerOnStateReached(PersistedInstallationEntry persistedInstallationEntry) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<StateListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                StateListener l = it.next();
                boolean doneListening = l.onStateReached(persistedInstallationEntry);
                if (!doneListening) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerOnException(Exception exception) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<StateListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                StateListener l = it.next();
                boolean doneListening = l.onException(exception);
                if (!doneListening) continue;
                it.remove();
            }
        }
    }

    private synchronized void updateCacheFid(String cachedFid) {
        this.cachedFid = cachedFid;
    }

    private synchronized String getCacheFid() {
        return this.cachedFid;
    }

    private final void doRegistrationOrRefresh(boolean forceRefresh) {
        PersistedInstallationEntry prefs = this.getPrefsWithGeneratedIdMultiProcessSafe();
        if (forceRefresh) {
            prefs = prefs.withClearedAuthToken();
        }
        this.triggerOnStateReached(prefs);
        this.networkExecutor.execute(() -> this.doNetworkCallIfNecessary(forceRefresh));
    }

    private void doNetworkCallIfNecessary(boolean forceRefresh) {
        PersistedInstallationEntry updatedPrefs;
        PersistedInstallationEntry prefs;
        block9: {
            prefs = this.getMultiProcessSafePrefs();
            try {
                if (prefs.isErrored() || prefs.isUnregistered()) {
                    updatedPrefs = this.registerFidWithServer(prefs);
                    break block9;
                }
                if (forceRefresh || this.utils.isAuthTokenExpired(prefs)) {
                    updatedPrefs = this.fetchAuthTokenFromServer(prefs);
                    break block9;
                }
                return;
            }
            catch (FirebaseInstallationsException e) {
                this.triggerOnException((Exception)((Object)e));
                return;
            }
        }
        this.insertOrUpdatePrefs(updatedPrefs);
        this.updateFidListener(prefs, updatedPrefs);
        prefs = updatedPrefs;
        if (prefs.isRegistered()) {
            this.updateCacheFid(prefs.getFirebaseInstallationId());
        }
        if (prefs.isErrored()) {
            this.triggerOnException((Exception)((Object)new FirebaseInstallationsException(FirebaseInstallationsException.Status.BAD_CONFIG)));
        } else if (prefs.isNotGenerated()) {
            this.triggerOnException(new IOException(AUTH_ERROR_MSG));
        } else {
            this.triggerOnStateReached(prefs);
        }
    }

    private synchronized void updateFidListener(PersistedInstallationEntry prefs, PersistedInstallationEntry updatedPrefs) {
        if (this.fidListeners.size() != 0 && !prefs.getFirebaseInstallationId().equals(updatedPrefs.getFirebaseInstallationId())) {
            for (FidListener listener : this.fidListeners) {
                listener.onFidChanged(updatedPrefs.getFirebaseInstallationId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOrUpdatePrefs(PersistedInstallationEntry prefs) {
        Object object = lockGenerateFid;
        synchronized (object) {
            CrossProcessLock lock = CrossProcessLock.acquire(this.firebaseApp.getApplicationContext(), LOCKFILE_NAME_GENERATE_FID);
            try {
                this.persistedInstallation.insertOrUpdatePersistedInstallationEntry(prefs);
            }
            finally {
                if (lock != null) {
                    lock.releaseAndClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistedInstallationEntry getPrefsWithGeneratedIdMultiProcessSafe() {
        Object object = lockGenerateFid;
        synchronized (object) {
            PersistedInstallationEntry persistedInstallationEntry;
            block8: {
                CrossProcessLock lock = CrossProcessLock.acquire(this.firebaseApp.getApplicationContext(), LOCKFILE_NAME_GENERATE_FID);
                try {
                    PersistedInstallationEntry prefs = this.persistedInstallation.readPersistedInstallationEntryValue();
                    if (prefs.isNotGenerated()) {
                        String fid = this.readExistingIidOrCreateFid(prefs);
                        prefs = this.persistedInstallation.insertOrUpdatePersistedInstallationEntry(prefs.withUnregisteredFid(fid));
                    }
                    persistedInstallationEntry = prefs;
                    if (lock == null) break block8;
                    lock.releaseAndClose();
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        lock.releaseAndClose();
                    }
                    throw throwable;
                }
            }
            return persistedInstallationEntry;
        }
    }

    private String readExistingIidOrCreateFid(PersistedInstallationEntry prefs) {
        if (!this.firebaseApp.getName().equals(CHIME_FIREBASE_APP_NAME) && !this.firebaseApp.isDefaultApp() || !prefs.shouldAttemptMigration()) {
            return this.fidGenerator.createRandomFid();
        }
        String fid = this.iidStore.readIid();
        if (TextUtils.isEmpty((CharSequence)fid)) {
            fid = this.fidGenerator.createRandomFid();
        }
        return fid;
    }

    private PersistedInstallationEntry registerFidWithServer(PersistedInstallationEntry prefs) throws FirebaseInstallationsException {
        String iidToken = null;
        if (prefs.getFirebaseInstallationId() != null && prefs.getFirebaseInstallationId().length() == 11) {
            iidToken = this.iidStore.readToken();
        }
        InstallationResponse response = this.serviceClient.createFirebaseInstallation(this.getApiKey(), prefs.getFirebaseInstallationId(), this.getProjectIdentifier(), this.getApplicationId(), iidToken);
        switch (response.getResponseCode()) {
            case OK: {
                return prefs.withRegisteredFid(response.getFid(), response.getRefreshToken(), this.utils.currentTimeInSecs(), response.getAuthToken().getToken(), response.getAuthToken().getTokenExpirationTimestamp());
            }
            case BAD_CONFIG: {
                return prefs.withFisError("BAD CONFIG");
            }
        }
        throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
    }

    private PersistedInstallationEntry fetchAuthTokenFromServer(@NonNull PersistedInstallationEntry prefs) throws FirebaseInstallationsException {
        TokenResult tokenResult = this.serviceClient.generateAuthToken(this.getApiKey(), prefs.getFirebaseInstallationId(), this.getProjectIdentifier(), prefs.getRefreshToken());
        switch (tokenResult.getResponseCode()) {
            case OK: {
                return prefs.withAuthToken(tokenResult.getToken(), tokenResult.getTokenExpirationTimestamp(), this.utils.currentTimeInSecs());
            }
            case BAD_CONFIG: {
                return prefs.withFisError("BAD CONFIG");
            }
            case AUTH_ERROR: {
                this.updateCacheFid(null);
                return prefs.withNoGeneratedFid();
            }
        }
        throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
    }

    private Void deleteFirebaseInstallationId() throws FirebaseInstallationsException {
        this.updateCacheFid(null);
        PersistedInstallationEntry entry = this.getMultiProcessSafePrefs();
        if (entry.isRegistered()) {
            this.serviceClient.deleteFirebaseInstallation(this.getApiKey(), entry.getFirebaseInstallationId(), this.getProjectIdentifier(), entry.getRefreshToken());
        }
        this.insertOrUpdatePrefs(entry.withNoGeneratedFid());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistedInstallationEntry getMultiProcessSafePrefs() {
        Object object = lockGenerateFid;
        synchronized (object) {
            PersistedInstallationEntry persistedInstallationEntry;
            block7: {
                CrossProcessLock lock = CrossProcessLock.acquire(this.firebaseApp.getApplicationContext(), LOCKFILE_NAME_GENERATE_FID);
                try {
                    PersistedInstallationEntry prefs;
                    persistedInstallationEntry = prefs = this.persistedInstallation.readPersistedInstallationEntryValue();
                    if (lock == null) break block7;
                    lock.releaseAndClose();
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        lock.releaseAndClose();
                    }
                    throw throwable;
                }
            }
            return persistedInstallationEntry;
        }
    }
}

