/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal.injection.modules;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import androidx.annotation.NonNull;
import com.google.common.io.BaseEncoding;
import com.google.firebase.FirebaseApp;
import com.google.firebase.inappmessaging.dagger.Module;
import com.google.firebase.inappmessaging.dagger.Provides;
import com.google.firebase.inappmessaging.internal.injection.scopes.FirebaseAppScope;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.InAppMessagingSdkServingGrpc;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@Module
public class GrpcClientModule {
    private final FirebaseApp firebaseApp;

    public GrpcClientModule(FirebaseApp firebaseApp) {
        this.firebaseApp = firebaseApp;
    }

    @Provides
    public Metadata providesApiKeyHeaders() {
        Metadata.Key apiClientKeyHeader = Metadata.Key.of((String)"X-Goog-Api-Key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Metadata.Key androidPackageHeader = Metadata.Key.of((String)"X-Android-Package", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Metadata.Key androidCertHashHeader = Metadata.Key.of((String)"X-Android-Cert", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Metadata metadata = new Metadata();
        String packageName = this.firebaseApp.getApplicationContext().getPackageName();
        metadata.put(apiClientKeyHeader, (Object)this.firebaseApp.getOptions().getApiKey());
        metadata.put(androidPackageHeader, (Object)packageName);
        String signature = GrpcClientModule.getSignature(this.firebaseApp.getApplicationContext().getPackageManager(), packageName);
        if (signature != null) {
            metadata.put(androidCertHashHeader, (Object)signature);
        }
        return metadata;
    }

    public static String getSignature(@NonNull PackageManager pm, @NonNull String packageName) {
        try {
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 64);
            if (packageInfo == null || packageInfo.signatures == null || packageInfo.signatures.length == 0 || packageInfo.signatures[0] == null) {
                return null;
            }
            return GrpcClientModule.signatureDigest(packageInfo.signatures[0]);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private static String signatureDigest(Signature sig) {
        byte[] signature = sig.toByteArray();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] digest = md.digest(signature);
            return BaseEncoding.base16().upperCase().encode(digest);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    @Provides
    @FirebaseAppScope
    public InAppMessagingSdkServingGrpc.InAppMessagingSdkServingBlockingStub providesInAppMessagingSdkServingStub(Channel channel, Metadata metadata) {
        return InAppMessagingSdkServingGrpc.newBlockingStub(ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)}));
    }
}

