/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import com.google.firebase.inappmessaging.internal.ProtoStorageClient;
import com.google.firebase.inappmessaging.internal.RateLimitProto;
import com.google.firebase.inappmessaging.internal.injection.qualifiers.RateLimit;
import com.google.firebase.inappmessaging.internal.time.Clock;
import com.google.protobuf.AbstractMessageLite;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RateLimiterClient {
    private static final RateLimitProto.RateLimit EMPTY_RATE_LIMITS = RateLimitProto.RateLimit.getDefaultInstance();
    private final ProtoStorageClient storageClient;
    private final Clock clock;
    private Maybe<RateLimitProto.RateLimit> cachedRateLimts = Maybe.empty();

    @Inject
    RateLimiterClient(@RateLimit ProtoStorageClient storageClient, Clock clock) {
        this.storageClient = storageClient;
        this.clock = clock;
    }

    private static RateLimitProto.Counter increment(RateLimitProto.Counter current) {
        return (RateLimitProto.Counter)RateLimitProto.Counter.newBuilder(current).clearValue().setValue(current.getValue() + 1L).build();
    }

    public Completable increment(com.google.firebase.inappmessaging.model.RateLimit limit) {
        return this.getRateLimits().defaultIfEmpty((Object)EMPTY_RATE_LIMITS).flatMapCompletable(storedLimits -> Observable.just((Object)storedLimits.getLimitsOrDefault(limit.limiterKey(), this.newCounter())).filter(counter -> !this.isLimitExpired((RateLimitProto.Counter)counter, limit)).switchIfEmpty((ObservableSource)Observable.just((Object)this.newCounter())).map(current -> {
            RateLimitProto.Counter incremented = RateLimiterClient.increment(current);
            return (RateLimitProto.RateLimit)RateLimitProto.RateLimit.newBuilder(storedLimits).putLimits(limit.limiterKey(), incremented).build();
        }).flatMapCompletable(a -> this.storageClient.write((AbstractMessageLite)a).doOnComplete(() -> this.initInMemCache((RateLimitProto.RateLimit)a))));
    }

    public Single<Boolean> isRateLimited(com.google.firebase.inappmessaging.model.RateLimit limit) {
        return this.getRateLimits().switchIfEmpty((MaybeSource)Maybe.just((Object)RateLimitProto.RateLimit.getDefaultInstance())).map(storedLimits -> storedLimits.getLimitsOrDefault(limit.limiterKey(), this.newCounter())).filter(counter -> this.isLimitExpired((RateLimitProto.Counter)counter, limit) || counter.getValue() < limit.limit()).isEmpty();
    }

    private boolean isLimitExpired(RateLimitProto.Counter counter, com.google.firebase.inappmessaging.model.RateLimit limit) {
        long currentTime = this.clock.now();
        return currentTime - counter.getStartTimeEpoch() > limit.timeToLiveMillis();
    }

    private Maybe<RateLimitProto.RateLimit> getRateLimits() {
        return this.cachedRateLimts.switchIfEmpty((MaybeSource)this.storageClient.read(RateLimitProto.RateLimit.parser()).doOnSuccess(this::initInMemCache)).doOnError(ignored -> this.clearInMemCache());
    }

    private void initInMemCache(RateLimitProto.RateLimit rateLimits) {
        this.cachedRateLimts = Maybe.just((Object)rateLimits);
    }

    private void clearInMemCache() {
        this.cachedRateLimts = Maybe.empty();
    }

    private RateLimitProto.Counter newCounter() {
        return (RateLimitProto.Counter)RateLimitProto.Counter.newBuilder().setValue(0L).setStartTimeEpoch(this.clock.now()).build();
    }
}

