/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal.injection.modules;

import android.app.Application;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.Subscriber;
import com.google.firebase.inappmessaging.dagger.Lazy;
import com.google.firebase.inappmessaging.dagger.Module;
import com.google.firebase.inappmessaging.dagger.Provides;
import com.google.firebase.inappmessaging.internal.ApiClient;
import com.google.firebase.inappmessaging.internal.DataCollectionHelper;
import com.google.firebase.inappmessaging.internal.GrpcClient;
import com.google.firebase.inappmessaging.internal.ProviderInstaller;
import com.google.firebase.inappmessaging.internal.SharedPreferencesUtils;
import com.google.firebase.inappmessaging.internal.TestDeviceHelper;
import com.google.firebase.inappmessaging.internal.injection.scopes.FirebaseAppScope;
import com.google.firebase.inappmessaging.internal.time.Clock;
import com.google.firebase.installations.FirebaseInstallationsApi;

@Module
public class ApiClientModule {
    private final FirebaseApp firebaseApp;
    private final FirebaseInstallationsApi firebaseInstallations;
    private final Clock clock;

    public ApiClientModule(FirebaseApp firebaseApp, FirebaseInstallationsApi firebaseInstallations, Clock clock) {
        this.firebaseApp = firebaseApp;
        this.firebaseInstallations = firebaseInstallations;
        this.clock = clock;
    }

    @Provides
    FirebaseInstallationsApi providesFirebaseInstallations() {
        return this.firebaseInstallations;
    }

    @Provides
    FirebaseApp providesFirebaseApp() {
        return this.firebaseApp;
    }

    @Provides
    SharedPreferencesUtils providesSharedPreferencesUtils() {
        return new SharedPreferencesUtils(this.firebaseApp);
    }

    @Provides
    DataCollectionHelper providesDataCollectionHelper(SharedPreferencesUtils sharedPreferencesUtils, Subscriber firebaseEventSubscriber) {
        return new DataCollectionHelper(this.firebaseApp, sharedPreferencesUtils, firebaseEventSubscriber);
    }

    @Provides
    TestDeviceHelper providesTestDeviceHelper(SharedPreferencesUtils sharedPreferencesUtils) {
        return new TestDeviceHelper(sharedPreferencesUtils);
    }

    @Provides
    @FirebaseAppScope
    ApiClient providesApiClient(Lazy<GrpcClient> grpcClient, Application application, ProviderInstaller providerInstaller) {
        return new ApiClient(grpcClient, this.firebaseApp, application, this.clock, providerInstaller);
    }
}

