/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.firebase.inappmessaging.CommonTypesProto;
import com.google.firebase.inappmessaging.internal.AbtIntegrationHelper;
import com.google.firebase.inappmessaging.internal.AnalyticsEventsManager;
import com.google.firebase.inappmessaging.internal.ApiClient;
import com.google.firebase.inappmessaging.internal.CampaignCacheClient;
import com.google.firebase.inappmessaging.internal.DataCollectionHelper;
import com.google.firebase.inappmessaging.internal.ImpressionStorageClient;
import com.google.firebase.inappmessaging.internal.InstallationIdResult;
import com.google.firebase.inappmessaging.internal.Logging;
import com.google.firebase.inappmessaging.internal.RateLimiterClient;
import com.google.firebase.inappmessaging.internal.Schedulers;
import com.google.firebase.inappmessaging.internal.TestDeviceHelper;
import com.google.firebase.inappmessaging.internal.injection.qualifiers.AppForeground;
import com.google.firebase.inappmessaging.internal.injection.qualifiers.ProgrammaticTrigger;
import com.google.firebase.inappmessaging.internal.injection.scopes.FirebaseAppScope;
import com.google.firebase.inappmessaging.internal.time.Clock;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.MessageType;
import com.google.firebase.inappmessaging.model.ProtoMarshallerClient;
import com.google.firebase.inappmessaging.model.RateLimit;
import com.google.firebase.inappmessaging.model.TriggeredInAppMessage;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.internal.firebase.inappmessaging.v1.CampaignProto;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.CampaignImpressionList;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.FetchEligibleCampaignsResponse;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.Locale;
import javax.inject.Inject;

@FirebaseAppScope
public class InAppMessageStreamManager {
    public static final String ON_FOREGROUND = "ON_FOREGROUND";
    private final ConnectableFlowable<String> appForegroundEventFlowable;
    private final ConnectableFlowable<String> programmaticTriggerEventFlowable;
    private final CampaignCacheClient campaignCacheClient;
    private final Clock clock;
    private final ApiClient apiClient;
    private final Schedulers schedulers;
    private final ImpressionStorageClient impressionStorageClient;
    private final RateLimiterClient rateLimiterClient;
    private final RateLimit appForegroundRateLimit;
    private final AnalyticsEventsManager analyticsEventsManager;
    private final TestDeviceHelper testDeviceHelper;
    private final AbtIntegrationHelper abtIntegrationHelper;
    private final FirebaseInstallationsApi firebaseInstallations;
    private final DataCollectionHelper dataCollectionHelper;

    @Inject
    public InAppMessageStreamManager(@AppForeground ConnectableFlowable<String> appForegroundEventFlowable, @ProgrammaticTrigger ConnectableFlowable<String> programmaticTriggerEventFlowable, CampaignCacheClient campaignCacheClient, Clock clock, ApiClient apiClient, AnalyticsEventsManager analyticsEventsManager, Schedulers schedulers, ImpressionStorageClient impressionStorageClient, RateLimiterClient rateLimiterClient, @AppForeground RateLimit appForegroundRateLimit, TestDeviceHelper testDeviceHelper, FirebaseInstallationsApi firebaseInstallations, DataCollectionHelper dataCollectionHelper, AbtIntegrationHelper abtIntegrationHelper) {
        this.appForegroundEventFlowable = appForegroundEventFlowable;
        this.programmaticTriggerEventFlowable = programmaticTriggerEventFlowable;
        this.campaignCacheClient = campaignCacheClient;
        this.clock = clock;
        this.apiClient = apiClient;
        this.analyticsEventsManager = analyticsEventsManager;
        this.schedulers = schedulers;
        this.impressionStorageClient = impressionStorageClient;
        this.rateLimiterClient = rateLimiterClient;
        this.appForegroundRateLimit = appForegroundRateLimit;
        this.testDeviceHelper = testDeviceHelper;
        this.dataCollectionHelper = dataCollectionHelper;
        this.firebaseInstallations = firebaseInstallations;
        this.abtIntegrationHelper = abtIntegrationHelper;
    }

    private static boolean containsTriggeringCondition(String event, CampaignProto.ThickContent content) {
        if (InAppMessageStreamManager.isAppForegroundEvent(event) && content.getIsTestCampaign()) {
            return true;
        }
        for (CommonTypesProto.TriggeringCondition condition : content.getTriggeringConditionsList()) {
            if (!InAppMessageStreamManager.hasFiamTrigger(condition, event) && !InAppMessageStreamManager.hasAnalyticsTrigger(condition, event)) continue;
            Logging.logd(String.format("The event %s is contained in the list of triggers", event));
            return true;
        }
        return false;
    }

    private static boolean hasFiamTrigger(CommonTypesProto.TriggeringCondition tc, String event) {
        return tc.getFiamTrigger().toString().equals(event);
    }

    private static boolean hasAnalyticsTrigger(CommonTypesProto.TriggeringCondition tc, String event) {
        return tc.getEvent().getName().equals(event);
    }

    private static boolean isActive(Clock clock, CampaignProto.ThickContent content) {
        long campaignEndTime;
        long campaignStartTime;
        if (content.getPayloadCase().equals((Object)CampaignProto.ThickContent.PayloadCase.VANILLA_PAYLOAD)) {
            campaignStartTime = content.getVanillaPayload().getCampaignStartTimeMillis();
            campaignEndTime = content.getVanillaPayload().getCampaignEndTimeMillis();
        } else if (content.getPayloadCase().equals((Object)CampaignProto.ThickContent.PayloadCase.EXPERIMENTAL_PAYLOAD)) {
            campaignStartTime = content.getExperimentalPayload().getCampaignStartTimeMillis();
            campaignEndTime = content.getExperimentalPayload().getCampaignEndTimeMillis();
        } else {
            return false;
        }
        long currentTime = clock.now();
        return currentTime > campaignStartTime && currentTime < campaignEndTime;
    }

    private static int compareByPriority(CampaignProto.ThickContent content1, CampaignProto.ThickContent content2) {
        if (content1.getIsTestCampaign() && !content2.getIsTestCampaign()) {
            return -1;
        }
        if (content2.getIsTestCampaign() && !content1.getIsTestCampaign()) {
            return 1;
        }
        return Integer.compare(content1.getPriority().getValue(), content2.getPriority().getValue());
    }

    public static boolean isAppForegroundEvent(CommonTypesProto.TriggeringCondition event) {
        return event.getFiamTrigger().toString().equals(ON_FOREGROUND);
    }

    public static boolean isAppForegroundEvent(String event) {
        return event.equals(ON_FOREGROUND);
    }

    private boolean shouldIgnoreCache(String event) {
        if (this.testDeviceHelper.isAppInstallFresh()) {
            return InAppMessageStreamManager.isAppForegroundEvent(event);
        }
        return this.testDeviceHelper.isDeviceInTestMode();
    }

    public Flowable<TriggeredInAppMessage> createFirebaseInAppMessageStream() {
        return Flowable.merge(this.appForegroundEventFlowable, this.analyticsEventsManager.getAnalyticsEventsFlowable(), this.programmaticTriggerEventFlowable).doOnNext(e -> Logging.logd("Event Triggered: " + e)).observeOn(this.schedulers.io()).concatMap(event -> {
            Maybe cacheRead = this.campaignCacheClient.get().doOnSuccess(r -> Logging.logd("Fetched from cache")).doOnError(e -> Logging.logw("Cache read error: " + e.getMessage())).onErrorResumeNext((MaybeSource)Maybe.empty());
            Consumer cacheWrite = response -> this.campaignCacheClient.put((FetchEligibleCampaignsResponse)response).doOnComplete(() -> Logging.logd("Wrote to cache")).doOnError(e -> Logging.logw("Cache write error: " + e.getMessage())).onErrorResumeNext(ignored -> Completable.complete()).subscribe();
            Function filterAlreadyImpressed = content -> content.getIsTestCampaign() ? Maybe.just((Object)content) : this.impressionStorageClient.isImpressed((CampaignProto.ThickContent)content).doOnError(e -> Logging.logw("Impression store read fail: " + e.getMessage())).onErrorResumeNext(Single.just((Object)false)).doOnSuccess(isImpressed -> InAppMessageStreamManager.logImpressionStatus(content, isImpressed)).filter(isImpressed -> isImpressed == false).map(isImpressed -> content);
            Function appForegroundRateLimitFilter = content -> this.getContentIfNotRateLimited((String)event, (CampaignProto.ThickContent)content);
            Function filterDisplayable = thickContent -> {
                switch (thickContent.getContent().getMessageDetailsCase()) {
                    case BANNER: 
                    case IMAGE_ONLY: 
                    case MODAL: 
                    case CARD: {
                        return Maybe.just((Object)thickContent);
                    }
                }
                Logging.logd("Filtering non-displayable message");
                return Maybe.empty();
            };
            Function selectThickContent = response -> this.getTriggeredInAppMessageMaybe((String)event, (Function<CampaignProto.ThickContent, Maybe<CampaignProto.ThickContent>>)filterAlreadyImpressed, (Function<CampaignProto.ThickContent, Maybe<CampaignProto.ThickContent>>)appForegroundRateLimitFilter, (Function<CampaignProto.ThickContent, Maybe<CampaignProto.ThickContent>>)filterDisplayable, (FetchEligibleCampaignsResponse)response);
            Maybe alreadySeenCampaigns = this.impressionStorageClient.getAllImpressions().doOnError(e -> Logging.logw("Impressions store read fail: " + e.getMessage())).defaultIfEmpty((Object)CampaignImpressionList.getDefaultInstance()).onErrorResumeNext((MaybeSource)Maybe.just((Object)CampaignImpressionList.getDefaultInstance()));
            Maybe getIID = Maybe.zip(InAppMessageStreamManager.taskToMaybe(this.firebaseInstallations.getId()), InAppMessageStreamManager.taskToMaybe(this.firebaseInstallations.getToken(false)), InstallationIdResult::create).observeOn(this.schedulers.io());
            Function serviceFetch = campaignImpressionList -> {
                if (!this.dataCollectionHelper.isAutomaticDataCollectionEnabled()) {
                    Logging.logi("Automatic data collection is disabled, not attempting campaign fetch from service.");
                    return Maybe.just((Object)InAppMessageStreamManager.cacheExpiringResponse());
                }
                return getIID.filter(InAppMessageStreamManager::validIID).map(iid -> this.apiClient.getFiams((InstallationIdResult)iid, (CampaignImpressionList)campaignImpressionList)).switchIfEmpty((MaybeSource)Maybe.just((Object)InAppMessageStreamManager.cacheExpiringResponse())).doOnSuccess(resp -> Logging.logi(String.format(Locale.US, "Successfully fetched %d messages from backend", resp.getMessagesList().size()))).doOnSuccess(resp -> this.impressionStorageClient.clearImpressions((FetchEligibleCampaignsResponse)resp).subscribe()).doOnSuccess(this.analyticsEventsManager::updateContextualTriggers).doOnSuccess(this.testDeviceHelper::processCampaignFetch).doOnError(e -> Logging.logw("Service fetch error: " + e.getMessage())).onErrorResumeNext((MaybeSource)Maybe.empty());
            };
            if (this.shouldIgnoreCache((String)event)) {
                Logging.logi(String.format("Forcing fetch from service rather than cache. Test Device: %s | App Fresh Install: %s", this.testDeviceHelper.isDeviceInTestMode(), this.testDeviceHelper.isAppInstallFresh()));
                return alreadySeenCampaigns.flatMap(serviceFetch).flatMap(selectThickContent).toFlowable();
            }
            Logging.logd("Attempting to fetch campaigns using cache");
            return cacheRead.switchIfEmpty((MaybeSource)alreadySeenCampaigns.flatMap(serviceFetch).doOnSuccess(cacheWrite)).flatMap(selectThickContent).toFlowable();
        }).observeOn(this.schedulers.mainThread());
    }

    private Maybe<CampaignProto.ThickContent> getContentIfNotRateLimited(String event, CampaignProto.ThickContent content) {
        if (!content.getIsTestCampaign() && InAppMessageStreamManager.isAppForegroundEvent(event)) {
            return this.rateLimiterClient.isRateLimited(this.appForegroundRateLimit).doOnSuccess(isRateLimited -> Logging.logi("App foreground rate limited ? : " + isRateLimited)).onErrorResumeNext(Single.just((Object)false)).filter(isRateLimited -> isRateLimited == false).map(isRateLimited -> content);
        }
        return Maybe.just((Object)content);
    }

    private static void logImpressionStatus(CampaignProto.ThickContent content, Boolean isImpressed) {
        if (content.getPayloadCase().equals((Object)CampaignProto.ThickContent.PayloadCase.VANILLA_PAYLOAD)) {
            Logging.logi(String.format("Already impressed campaign %s ? : %s", content.getVanillaPayload().getCampaignName(), isImpressed));
        } else if (content.getPayloadCase().equals((Object)CampaignProto.ThickContent.PayloadCase.EXPERIMENTAL_PAYLOAD)) {
            Logging.logi(String.format("Already impressed experiment %s ? : %s", content.getExperimentalPayload().getCampaignName(), isImpressed));
        }
    }

    private Maybe<TriggeredInAppMessage> getTriggeredInAppMessageMaybe(String event, Function<CampaignProto.ThickContent, Maybe<CampaignProto.ThickContent>> filterAlreadyImpressed, Function<CampaignProto.ThickContent, Maybe<CampaignProto.ThickContent>> appForegroundRateLimitFilter, Function<CampaignProto.ThickContent, Maybe<CampaignProto.ThickContent>> filterDisplayable, FetchEligibleCampaignsResponse response) {
        return Flowable.fromIterable(response.getMessagesList()).filter(content -> this.testDeviceHelper.isDeviceInTestMode() || InAppMessageStreamManager.isActive(this.clock, content)).filter(content -> InAppMessageStreamManager.containsTriggeringCondition(event, content)).flatMapMaybe(filterAlreadyImpressed).flatMapMaybe(appForegroundRateLimitFilter).flatMapMaybe(filterDisplayable).sorted(InAppMessageStreamManager::compareByPriority).firstElement().flatMap(content -> this.triggeredInAppMessage((CampaignProto.ThickContent)content, event));
    }

    private Maybe<TriggeredInAppMessage> triggeredInAppMessage(CampaignProto.ThickContent content, String event) {
        String campaignName;
        String campaignId;
        if (content.getPayloadCase().equals((Object)CampaignProto.ThickContent.PayloadCase.VANILLA_PAYLOAD)) {
            campaignId = content.getVanillaPayload().getCampaignId();
            campaignName = content.getVanillaPayload().getCampaignName();
        } else if (content.getPayloadCase().equals((Object)CampaignProto.ThickContent.PayloadCase.EXPERIMENTAL_PAYLOAD)) {
            campaignId = content.getExperimentalPayload().getCampaignId();
            campaignName = content.getExperimentalPayload().getCampaignName();
            if (!content.getIsTestCampaign()) {
                this.abtIntegrationHelper.setExperimentActive(content.getExperimentalPayload().getExperimentPayload());
            }
        } else {
            return Maybe.empty();
        }
        InAppMessage inAppMessage = ProtoMarshallerClient.decode(content.getContent(), campaignId, campaignName, content.getIsTestCampaign(), content.getDataBundleMap());
        if (inAppMessage.getMessageType().equals((Object)MessageType.UNSUPPORTED)) {
            return Maybe.empty();
        }
        return Maybe.just((Object)new TriggeredInAppMessage(inAppMessage, event));
    }

    private static boolean validIID(InstallationIdResult iid) {
        return !TextUtils.isEmpty((CharSequence)iid.installationId()) && !TextUtils.isEmpty((CharSequence)iid.installationTokenResult().getToken());
    }

    @VisibleForTesting
    static FetchEligibleCampaignsResponse cacheExpiringResponse() {
        return (FetchEligibleCampaignsResponse)FetchEligibleCampaignsResponse.newBuilder().setExpirationEpochTimestampMillis(1L).build();
    }

    private static <T> Maybe<T> taskToMaybe(Task<T> task) {
        return Maybe.create(emitter -> {
            task.addOnSuccessListener(result -> {
                emitter.onSuccess(result);
                emitter.onComplete();
            });
            task.addOnFailureListener(e -> {
                emitter.onError((Throwable)e);
                emitter.onComplete();
            });
        });
    }
}

