/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.layout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.firebase.inappmessaging.display.R;
import com.google.firebase.inappmessaging.display.internal.Logging;
import com.google.firebase.inappmessaging.display.internal.layout.BaseModalLayout;
import com.google.firebase.inappmessaging.display.internal.layout.util.MeasureUtils;

public class CardLayoutPortrait
extends BaseModalLayout {
    private View imageChild;
    private View titleChild;
    private View scrollChild;
    private View actionBarChild;
    private static double IMAGE_MAX_HEIGHT_PCT = 0.8;

    public CardLayoutPortrait(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.imageChild = this.findChildById(R.id.image_view);
        this.titleChild = this.findChildById(R.id.message_title);
        this.scrollChild = this.findChildById(R.id.body_scroll);
        this.actionBarChild = this.findChildById(R.id.action_bar);
        int baseLayoutWidth = this.calculateBaseWidth(widthMeasureSpec);
        int baseLayoutHeight = this.calculateBaseHeight(heightMeasureSpec);
        int maxImageHeight = this.roundToNearest((int)(IMAGE_MAX_HEIGHT_PCT * (double)baseLayoutHeight), 4);
        Logging.logd("Measuring image");
        MeasureUtils.measureFullWidth(this.imageChild, baseLayoutWidth, baseLayoutHeight);
        if (this.getDesiredHeight(this.imageChild) > maxImageHeight) {
            Logging.logd("Image exceeded maximum height, remeasuring image");
            MeasureUtils.measureFullHeight(this.imageChild, baseLayoutWidth, maxImageHeight);
        }
        int imageWidth = this.getDesiredWidth(this.imageChild);
        Logging.logd("Measuring title");
        MeasureUtils.measureFullWidth(this.titleChild, imageWidth, baseLayoutHeight);
        Logging.logd("Measuring action bar");
        MeasureUtils.measureFullWidth(this.actionBarChild, imageWidth, baseLayoutHeight);
        Logging.logd("Measuring scroll view");
        int maximumScrollHeight = baseLayoutHeight - this.getDesiredHeight(this.imageChild) - this.getDesiredHeight(this.titleChild) - this.getDesiredHeight(this.actionBarChild);
        MeasureUtils.measureFullWidth(this.scrollChild, imageWidth, maximumScrollHeight);
        int totalHeight = 0;
        int numVisible = this.getVisibleChildren().size();
        for (int i = 0; i < numVisible; ++i) {
            View child = this.getVisibleChildren().get(i);
            totalHeight += this.getDesiredHeight(child);
        }
        this.setMeasuredDimension(imageWidth, totalHeight);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int x = 0;
        int y = 0;
        int numVisible = this.getVisibleChildren().size();
        for (int i = 0; i < numVisible; ++i) {
            View child = this.getVisibleChildren().get(i);
            int childHeight = child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            int childTop = y;
            int childBottom = y + childHeight;
            int childLeft = x;
            int childRight = x + childWidth;
            Logging.logd("Layout child " + i);
            Logging.logdPair("\t(top, bottom)", childTop, childBottom);
            Logging.logdPair("\t(left, right)", childLeft, childRight);
            child.layout(childLeft, childTop, childRight, childBottom);
            Logging.logdPair("Child " + i + " wants to be ", child.getMeasuredWidth(), child.getMeasuredHeight());
            y += child.getMeasuredHeight();
        }
    }
}

