/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.injection.components;

import android.view.LayoutInflater;
import com.google.firebase.inappmessaging.display.dagger.internal.DaggerGenerated;
import com.google.firebase.inappmessaging.display.dagger.internal.DoubleCheck;
import com.google.firebase.inappmessaging.display.dagger.internal.Preconditions;
import com.google.firebase.inappmessaging.display.internal.InAppMessageLayoutConfig;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.BannerBindingWrapper;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.BannerBindingWrapper_Factory;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.CardBindingWrapper;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.CardBindingWrapper_Factory;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.ImageBindingWrapper;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.ImageBindingWrapper_Factory;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.ModalBindingWrapper;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.ModalBindingWrapper_Factory;
import com.google.firebase.inappmessaging.display.internal.injection.components.InAppMessageComponent;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterModule;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterModule_InAppMessageLayoutConfigFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterModule_ProvidesBannerMessageFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterModule_ProvidesInflaterserviceFactory;
import com.google.firebase.inappmessaging.model.InAppMessage;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerInAppMessageComponent {
    private DaggerInAppMessageComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private InflaterModule inflaterModule;

        private Builder() {
        }

        public Builder inflaterModule(InflaterModule inflaterModule) {
            this.inflaterModule = Preconditions.checkNotNull(inflaterModule);
            return this;
        }

        public InAppMessageComponent build() {
            Preconditions.checkBuilderRequirement(this.inflaterModule, InflaterModule.class);
            return new InAppMessageComponentImpl(this.inflaterModule);
        }
    }

    private static final class InAppMessageComponentImpl
    implements InAppMessageComponent {
        private final InAppMessageComponentImpl inAppMessageComponentImpl = this;
        private Provider<InAppMessageLayoutConfig> inAppMessageLayoutConfigProvider;
        private Provider<LayoutInflater> providesInflaterserviceProvider;
        private Provider<InAppMessage> providesBannerMessageProvider;
        private Provider<ImageBindingWrapper> imageBindingWrapperProvider;
        private Provider<ModalBindingWrapper> modalBindingWrapperProvider;
        private Provider<BannerBindingWrapper> bannerBindingWrapperProvider;
        private Provider<CardBindingWrapper> cardBindingWrapperProvider;

        private InAppMessageComponentImpl(InflaterModule inflaterModuleParam) {
            this.initialize(inflaterModuleParam);
        }

        private void initialize(InflaterModule inflaterModuleParam) {
            this.inAppMessageLayoutConfigProvider = DoubleCheck.provider(InflaterModule_InAppMessageLayoutConfigFactory.create(inflaterModuleParam));
            this.providesInflaterserviceProvider = DoubleCheck.provider(InflaterModule_ProvidesInflaterserviceFactory.create(inflaterModuleParam));
            this.providesBannerMessageProvider = InflaterModule_ProvidesBannerMessageFactory.create(inflaterModuleParam);
            this.imageBindingWrapperProvider = DoubleCheck.provider(ImageBindingWrapper_Factory.create(this.inAppMessageLayoutConfigProvider, this.providesInflaterserviceProvider, this.providesBannerMessageProvider));
            this.modalBindingWrapperProvider = DoubleCheck.provider(ModalBindingWrapper_Factory.create(this.inAppMessageLayoutConfigProvider, this.providesInflaterserviceProvider, this.providesBannerMessageProvider));
            this.bannerBindingWrapperProvider = DoubleCheck.provider(BannerBindingWrapper_Factory.create(this.inAppMessageLayoutConfigProvider, this.providesInflaterserviceProvider, this.providesBannerMessageProvider));
            this.cardBindingWrapperProvider = DoubleCheck.provider(CardBindingWrapper_Factory.create(this.inAppMessageLayoutConfigProvider, this.providesInflaterserviceProvider, this.providesBannerMessageProvider));
        }

        @Override
        public ImageBindingWrapper imageBindingWrapper() {
            return (ImageBindingWrapper)this.imageBindingWrapperProvider.get();
        }

        @Override
        public ModalBindingWrapper modalBindingWrapper() {
            return (ModalBindingWrapper)this.modalBindingWrapperProvider.get();
        }

        @Override
        public BannerBindingWrapper bannerBindingWrapper() {
            return (BannerBindingWrapper)this.bannerBindingWrapperProvider.get();
        }

        @Override
        public CardBindingWrapper cardBindingWrapper() {
            return (CardBindingWrapper)this.cardBindingWrapperProvider.get();
        }
    }
}

