/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.browser.customtabs.CustomTabsIntent;
import com.google.firebase.FirebaseApp;
import com.google.firebase.inappmessaging.FirebaseInAppMessaging;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplayCallbacks;
import com.google.firebase.inappmessaging.display.FiamListener;
import com.google.firebase.inappmessaging.display.R;
import com.google.firebase.inappmessaging.display.internal.BindingWrapperFactory;
import com.google.firebase.inappmessaging.display.internal.FiamAnimator;
import com.google.firebase.inappmessaging.display.internal.FiamImageLoader;
import com.google.firebase.inappmessaging.display.internal.FiamWindowManager;
import com.google.firebase.inappmessaging.display.internal.FirebaseInAppMessagingDisplayImpl;
import com.google.firebase.inappmessaging.display.internal.GlideErrorListener;
import com.google.firebase.inappmessaging.display.internal.InAppMessageLayoutConfig;
import com.google.firebase.inappmessaging.display.internal.Logging;
import com.google.firebase.inappmessaging.display.internal.RenewableTimer;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.BindingWrapper;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule;
import com.google.firebase.inappmessaging.display.internal.injection.scopes.FirebaseAppScope;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.BannerMessage;
import com.google.firebase.inappmessaging.model.CardMessage;
import com.google.firebase.inappmessaging.model.ImageData;
import com.google.firebase.inappmessaging.model.ImageOnlyMessage;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.MessageType;
import com.google.firebase.inappmessaging.model.ModalMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

@FirebaseAppScope
public class FirebaseInAppMessagingDisplay
extends FirebaseInAppMessagingDisplayImpl {
    static final long IMPRESSION_THRESHOLD_MILLIS = 5000L;
    static final long DISMISS_THRESHOLD_MILLIS = 20000L;
    static final long INTERVAL_MILLIS = 1000L;
    private final FirebaseInAppMessaging headlessInAppMessaging;
    private final Map<String, Provider<InAppMessageLayoutConfig>> layoutConfigs;
    private final FiamImageLoader imageLoader;
    private final RenewableTimer impressionTimer;
    private final RenewableTimer autoDismissTimer;
    private final FiamWindowManager windowManager;
    private final BindingWrapperFactory bindingWrapperFactory;
    private final Application application;
    private final FiamAnimator animator;
    private FiamListener fiamListener;
    private InAppMessage inAppMessage;
    private FirebaseInAppMessagingDisplayCallbacks callbacks;
    @VisibleForTesting
    @Nullable
    String currentlyBoundActivityName;

    @Inject
    FirebaseInAppMessagingDisplay(FirebaseInAppMessaging headlessInAppMessaging, Map<String, Provider<InAppMessageLayoutConfig>> layoutConfigs, FiamImageLoader imageLoader, RenewableTimer impressionTimer, RenewableTimer autoDismissTimer, FiamWindowManager windowManager, Application application, BindingWrapperFactory bindingWrapperFactory, FiamAnimator animator) {
        this.headlessInAppMessaging = headlessInAppMessaging;
        this.layoutConfigs = layoutConfigs;
        this.imageLoader = imageLoader;
        this.impressionTimer = impressionTimer;
        this.autoDismissTimer = autoDismissTimer;
        this.windowManager = windowManager;
        this.application = application;
        this.bindingWrapperFactory = bindingWrapperFactory;
        this.animator = animator;
    }

    @NonNull
    public static FirebaseInAppMessagingDisplay getInstance() {
        return (FirebaseInAppMessagingDisplay)FirebaseApp.getInstance().get(FirebaseInAppMessagingDisplay.class);
    }

    private static int getScreenOrientation(Application app) {
        return app.getResources().getConfiguration().orientation;
    }

    public void testMessage(Activity activity, InAppMessage inAppMessage, FirebaseInAppMessagingDisplayCallbacks callbacks) {
        this.setInAppMessageAndCallbacks(inAppMessage, callbacks);
        this.showActiveFiam(activity);
    }

    private void setInAppMessageAndCallbacks(InAppMessage inAppMessage, FirebaseInAppMessagingDisplayCallbacks callbacks) {
        this.inAppMessage = inAppMessage;
        this.callbacks = callbacks;
    }

    private void clearInAppMessageAndCallbacks() {
        this.setInAppMessageAndCallbacks(null, null);
    }

    public void setFiamListener(FiamListener listener) {
        this.fiamListener = listener;
    }

    public void clearFiamListener() {
        this.fiamListener = null;
    }

    @Override
    public void onActivityResumed(Activity activity) {
        super.onActivityResumed(activity);
        this.bindFiamToActivity(activity);
    }

    @Override
    public void onActivityPaused(Activity activity) {
        this.unbindFiamFromActivity(activity);
        this.headlessInAppMessaging.removeAllListeners();
        super.onActivityPaused(activity);
    }

    private void bindFiamToActivity(Activity activity) {
        if (this.currentlyBoundActivityName == null || !this.currentlyBoundActivityName.equals(activity.getLocalClassName())) {
            Logging.logi("Binding to activity: " + activity.getLocalClassName());
            this.headlessInAppMessaging.setMessageDisplayComponent((iam, cb) -> {
                if (this.inAppMessage != null || this.headlessInAppMessaging.areMessagesSuppressed()) {
                    Logging.logd("Active FIAM exists. Skipping trigger");
                    return;
                }
                this.setInAppMessageAndCallbacks(iam, cb);
                this.showActiveFiam(activity);
            });
            this.currentlyBoundActivityName = activity.getLocalClassName();
        }
        if (this.inAppMessage != null) {
            this.showActiveFiam(activity);
        }
    }

    private void unbindFiamFromActivity(Activity activity) {
        if (this.currentlyBoundActivityName != null && this.currentlyBoundActivityName.equals(activity.getLocalClassName())) {
            Logging.logi("Unbinding from activity: " + activity.getLocalClassName());
            this.headlessInAppMessaging.clearDisplayListener();
            this.removeDisplayedFiam(activity);
            this.currentlyBoundActivityName = null;
        }
    }

    @VisibleForTesting
    InAppMessage getCurrentInAppMessage() {
        return this.inAppMessage;
    }

    private void showActiveFiam(final @NonNull Activity activity) {
        BindingWrapper bindingWrapper;
        if (this.inAppMessage == null || this.headlessInAppMessaging.areMessagesSuppressed()) {
            Logging.loge("No active message found to render");
            return;
        }
        if (this.inAppMessage.getMessageType().equals((Object)MessageType.UNSUPPORTED)) {
            Logging.loge("The message being triggered is not supported by this version of the sdk.");
            return;
        }
        this.notifyFiamTrigger();
        InAppMessageLayoutConfig config = (InAppMessageLayoutConfig)this.layoutConfigs.get(InflaterConfigModule.configFor(this.inAppMessage.getMessageType(), FirebaseInAppMessagingDisplay.getScreenOrientation(this.application))).get();
        switch (this.inAppMessage.getMessageType()) {
            case BANNER: {
                bindingWrapper = this.bindingWrapperFactory.createBannerBindingWrapper(config, this.inAppMessage);
                break;
            }
            case MODAL: {
                bindingWrapper = this.bindingWrapperFactory.createModalBindingWrapper(config, this.inAppMessage);
                break;
            }
            case IMAGE_ONLY: {
                bindingWrapper = this.bindingWrapperFactory.createImageBindingWrapper(config, this.inAppMessage);
                break;
            }
            case CARD: {
                bindingWrapper = this.bindingWrapperFactory.createCardBindingWrapper(config, this.inAppMessage);
                break;
            }
            default: {
                Logging.loge("No bindings found for this message type");
                return;
            }
        }
        activity.findViewById(0x1020002).post(new Runnable(){

            @Override
            public void run() {
                FirebaseInAppMessagingDisplay.this.inflateBinding(activity, bindingWrapper);
            }
        });
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void inflateBinding(final Activity activity, final BindingWrapper bindingWrapper) {
        if (this.inAppMessage == null) {
            return;
        }
        View.OnClickListener dismissListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (FirebaseInAppMessagingDisplay.this.callbacks != null) {
                    FirebaseInAppMessagingDisplay.this.callbacks.messageDismissed(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType.CLICK);
                }
                FirebaseInAppMessagingDisplay.this.dismissFiam(activity);
            }
        };
        HashMap<Action, View.OnClickListener> actionListeners = new HashMap<Action, View.OnClickListener>();
        for (final Action action : this.extractActions(this.inAppMessage)) {
            Object actionListener;
            if (action != null && !TextUtils.isEmpty((CharSequence)action.getActionUrl())) {
                actionListener = new View.OnClickListener(){

                    public void onClick(View v) {
                        if (FirebaseInAppMessagingDisplay.this.callbacks != null) {
                            Logging.logi("Calling callback for click action");
                            FirebaseInAppMessagingDisplay.this.callbacks.messageClicked(action);
                        }
                        FirebaseInAppMessagingDisplay.this.launchUriIntent(activity, Uri.parse((String)action.getActionUrl()));
                        FirebaseInAppMessagingDisplay.this.notifyFiamClick();
                        FirebaseInAppMessagingDisplay.this.removeDisplayedFiam(activity);
                        FirebaseInAppMessagingDisplay.this.clearInAppMessageAndCallbacks();
                    }
                };
            } else {
                Logging.logi("No action url found for action. Treating as dismiss.");
                actionListener = dismissListener;
            }
            actionListeners.put(action, (View.OnClickListener)actionListener);
        }
        final ViewTreeObserver.OnGlobalLayoutListener layoutListener = bindingWrapper.inflate(actionListeners, dismissListener);
        if (layoutListener != null) {
            bindingWrapper.getImageView().getViewTreeObserver().addOnGlobalLayoutListener(layoutListener);
        }
        this.loadNullableImage(activity, bindingWrapper, this.extractImageData(this.inAppMessage), new FiamImageLoader.Callback(){

            @Override
            public void onSuccess() {
                if (!bindingWrapper.getConfig().backgroundEnabled().booleanValue()) {
                    bindingWrapper.getRootView().setOnTouchListener(new View.OnTouchListener(){

                        public boolean onTouch(View v, MotionEvent event) {
                            if (event.getAction() == 4) {
                                if (FirebaseInAppMessagingDisplay.this.callbacks != null) {
                                    FirebaseInAppMessagingDisplay.this.callbacks.messageDismissed(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType.UNKNOWN_DISMISS_TYPE);
                                }
                                FirebaseInAppMessagingDisplay.this.dismissFiam(activity);
                                return true;
                            }
                            return false;
                        }
                    });
                }
                FirebaseInAppMessagingDisplay.this.impressionTimer.start(new RenewableTimer.Callback(){

                    @Override
                    public void onFinish() {
                        if (FirebaseInAppMessagingDisplay.this.inAppMessage != null && FirebaseInAppMessagingDisplay.this.callbacks != null) {
                            Logging.logi("Impression timer onFinish for: " + FirebaseInAppMessagingDisplay.this.inAppMessage.getCampaignMetadata().getCampaignId());
                            FirebaseInAppMessagingDisplay.this.callbacks.impressionDetected();
                        }
                    }
                }, 5000L, 1000L);
                if (bindingWrapper.getConfig().autoDismiss().booleanValue()) {
                    FirebaseInAppMessagingDisplay.this.autoDismissTimer.start(new RenewableTimer.Callback(){

                        @Override
                        public void onFinish() {
                            if (FirebaseInAppMessagingDisplay.this.inAppMessage != null && FirebaseInAppMessagingDisplay.this.callbacks != null) {
                                FirebaseInAppMessagingDisplay.this.callbacks.messageDismissed(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType.AUTO);
                            }
                            FirebaseInAppMessagingDisplay.this.dismissFiam(activity);
                        }
                    }, 20000L, 1000L);
                }
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FirebaseInAppMessagingDisplay.this.windowManager.show(bindingWrapper, activity);
                        if (bindingWrapper.getConfig().animate().booleanValue()) {
                            FirebaseInAppMessagingDisplay.this.animator.slideIntoView(FirebaseInAppMessagingDisplay.this.application, (View)bindingWrapper.getRootView(), FiamAnimator.Position.TOP);
                        }
                    }
                });
            }

            @Override
            public void onError(Exception e) {
                Logging.loge("Image download failure ");
                if (layoutListener != null) {
                    bindingWrapper.getImageView().getViewTreeObserver().removeGlobalOnLayoutListener(layoutListener);
                }
                FirebaseInAppMessagingDisplay.this.cancelTimers();
                FirebaseInAppMessagingDisplay.this.clearInAppMessageAndCallbacks();
            }
        });
    }

    private List<Action> extractActions(InAppMessage message) {
        ArrayList<Action> actions = new ArrayList<Action>();
        switch (message.getMessageType()) {
            case BANNER: {
                actions.add(((BannerMessage)message).getAction());
                break;
            }
            case CARD: {
                actions.add(((CardMessage)message).getPrimaryAction());
                actions.add(((CardMessage)message).getSecondaryAction());
                break;
            }
            case IMAGE_ONLY: {
                actions.add(((ImageOnlyMessage)message).getAction());
                break;
            }
            case MODAL: {
                actions.add(((ModalMessage)message).getAction());
                break;
            }
            default: {
                actions.add(Action.builder().build());
            }
        }
        return actions;
    }

    private ImageData extractImageData(InAppMessage message) {
        if (message.getMessageType() == MessageType.CARD) {
            ImageData portraitImageData = ((CardMessage)message).getPortraitImageData();
            ImageData landscapeImageData = ((CardMessage)message).getLandscapeImageData();
            if (FirebaseInAppMessagingDisplay.getScreenOrientation(this.application) == 1) {
                return this.isValidImageData(portraitImageData) ? portraitImageData : landscapeImageData;
            }
            return this.isValidImageData(landscapeImageData) ? landscapeImageData : portraitImageData;
        }
        return message.getImageData();
    }

    private boolean isValidImageData(@Nullable ImageData imageData) {
        return imageData != null && !TextUtils.isEmpty((CharSequence)imageData.getImageUrl());
    }

    private void loadNullableImage(Activity activity, BindingWrapper fiam, ImageData imageData, FiamImageLoader.Callback callback) {
        if (this.isValidImageData(imageData)) {
            this.imageLoader.load(imageData.getImageUrl()).addErrorListener(new GlideErrorListener(this.inAppMessage, this.callbacks)).tag(activity.getClass()).placeholder(R.drawable.image_placeholder).into(fiam.getImageView(), callback);
        } else {
            callback.onSuccess();
        }
    }

    private void dismissFiam(Activity activity) {
        Logging.logd("Dismissing fiam");
        this.notifyFiamDismiss();
        this.removeDisplayedFiam(activity);
        this.clearInAppMessageAndCallbacks();
    }

    private void removeDisplayedFiam(Activity activity) {
        if (this.windowManager.isFiamDisplayed()) {
            this.imageLoader.cancelTag(activity.getClass());
            this.windowManager.destroy(activity);
            this.cancelTimers();
        }
    }

    private void cancelTimers() {
        this.impressionTimer.cancel();
        this.autoDismissTimer.cancel();
    }

    private void notifyFiamTrigger() {
        if (this.fiamListener != null) {
            this.fiamListener.onFiamTrigger();
        }
    }

    private void notifyFiamClick() {
        if (this.fiamListener != null) {
            this.fiamListener.onFiamClick();
        }
    }

    private void notifyFiamDismiss() {
        if (this.fiamListener != null) {
            this.fiamListener.onFiamDismiss();
        }
    }

    private void launchUriIntent(Activity activity, Uri uri) {
        if (this.ishttpOrHttpsUri(uri) && this.supportsCustomTabs(activity)) {
            CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
            Intent intent = customTabsIntent.intent;
            intent.addFlags(0x40000000);
            intent.addFlags(0x10000000);
            customTabsIntent.launchUrl((Context)activity, uri);
        } else {
            Intent browserIntent = new Intent("android.intent.action.VIEW", uri);
            ResolveInfo info = activity.getPackageManager().resolveActivity(browserIntent, 0);
            browserIntent.addFlags(0x40000000);
            browserIntent.addFlags(0x10000000);
            if (info != null) {
                activity.startActivity(browserIntent);
            } else {
                Logging.loge("Device cannot resolve intent for: android.intent.action.VIEW");
            }
        }
    }

    private boolean supportsCustomTabs(Activity activity) {
        Intent customTabIntent = new Intent("android.support.customtabs.action.CustomTabsService");
        customTabIntent.setPackage("com.android.chrome");
        List resolveInfos = activity.getPackageManager().queryIntentServices(customTabIntent, 0);
        return resolveInfos != null && !resolveInfos.isEmpty();
    }

    private boolean ishttpOrHttpsUri(Uri uri) {
        if (uri == null) {
            return false;
        }
        String scheme = uri.getScheme();
        return scheme != null && (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https"));
    }
}

