// Copyright 2018 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.firebase.inappmessaging.display.internal.injection.keys;

/**
 * Strings for each combination of InAppMessage and orientation.
 *
 * @hide
 */
public class LayoutConfigKey {

  public static final String MODAL_PORTRAIT = "MODAL_PORTRAIT";
  public static final String MODAL_LANDSCAPE = "MODAL_LANDSCAPE";
  public static final String CARD_PORTRAIT = "CARD_PORTRAIT";
  public static final String CARD_LANDSCAPE = "CARD_LANDSCAPE";
  public static final String IMAGE_ONLY_PORTRAIT = "IMAGE_ONLY_PORTRAIT";
  public static final String IMAGE_ONLY_LANDSCAPE = "IMAGE_ONLY_LANDSCAPE";
  public static final String BANNER_PORTRAIT = "BANNER_PORTRAIT";
  public static final String BANNER_LANDSCAPE = "BANNER_LANDSCAPE";
  public static final String UNSUPPORTED = "UNSUPPORTED";
}
