/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.layout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.firebase.inappmessaging.display.R;
import com.google.firebase.inappmessaging.display.internal.Logging;
import com.google.firebase.inappmessaging.display.internal.layout.BaseModalLayout;
import com.google.firebase.inappmessaging.display.internal.layout.util.MeasureUtils;
import java.util.Arrays;
import java.util.List;

public class CardLayoutLandscape
extends BaseModalLayout {
    private View imageChild;
    private View titleChild;
    private View scrollChild;
    private View actionBarChild;
    private static double IMAGE_MAX_WIDTH_PCT = 0.6;

    public CardLayoutLandscape(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.imageChild = this.findChildById(R.id.image_view);
        this.titleChild = this.findChildById(R.id.message_title);
        this.scrollChild = this.findChildById(R.id.body_scroll);
        this.actionBarChild = this.findChildById(R.id.action_bar);
        List<View> rightCol = Arrays.asList(this.titleChild, this.scrollChild, this.actionBarChild);
        int baseLayoutWidth = this.calculateBaseWidth(widthMeasureSpec);
        int baseLayoutHeight = this.calculateBaseHeight(heightMeasureSpec);
        int maxImageWidth = this.roundToNearest((int)(IMAGE_MAX_WIDTH_PCT * (double)baseLayoutWidth), 4);
        Logging.logd("Measuring image");
        MeasureUtils.measureFullHeight(this.imageChild, baseLayoutWidth, baseLayoutHeight);
        if (this.getDesiredWidth(this.imageChild) > maxImageWidth) {
            Logging.logd("Image exceeded maximum width, remeasuring image");
            MeasureUtils.measureFullWidth(this.imageChild, maxImageWidth, baseLayoutHeight);
        }
        int imageHeight = this.getDesiredHeight(this.imageChild);
        int leftColumnWidth = this.getDesiredWidth(this.imageChild);
        int rightColumnMaxWidth = baseLayoutWidth - leftColumnWidth;
        Logging.logdPair("Max col widths (l, r)", leftColumnWidth, rightColumnMaxWidth);
        Logging.logd("Measuring title");
        MeasureUtils.measureAtMost(this.titleChild, rightColumnMaxWidth, imageHeight);
        Logging.logd("Measuring action bar");
        MeasureUtils.measureAtMost(this.actionBarChild, rightColumnMaxWidth, imageHeight);
        Logging.logd("Measuring scroll view");
        int scrollHeight = imageHeight - this.getDesiredHeight(this.titleChild) - this.getDesiredHeight(this.actionBarChild);
        MeasureUtils.measureFullHeight(this.scrollChild, rightColumnMaxWidth, scrollHeight);
        int rightColumnWidth = 0;
        for (View view : rightCol) {
            rightColumnWidth = Math.max(this.getDesiredWidth(view), rightColumnWidth);
        }
        Logging.logdPair("Measured columns (l, r)", leftColumnWidth, rightColumnWidth);
        int totalWidth = leftColumnWidth + rightColumnWidth;
        Logging.logdPair("Measured dims", totalWidth, imageHeight);
        this.setMeasuredDimension(totalWidth, imageHeight);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int CONTAINER_LEFT = 0;
        int CONTAINER_TOP = 0;
        int CONTAINER_RIGHT = this.getMeasuredWidth();
        int CONTAINER_BOTTOM = this.getMeasuredHeight();
        Logging.logd("Layout image");
        int imageLeft = CONTAINER_LEFT;
        int imageTop = CONTAINER_TOP;
        int imageRight = this.getDesiredWidth(this.imageChild);
        int imageBottom = this.getDesiredHeight(this.imageChild);
        this.layoutChild(this.imageChild, imageLeft, imageTop, imageRight, imageBottom);
        int rightColLeft = imageRight;
        Logging.logd("Layout title");
        int titleLeft = rightColLeft;
        int titleTop = CONTAINER_TOP;
        int titleRight = CONTAINER_RIGHT;
        int titleBottom = this.getDesiredHeight(this.titleChild);
        this.layoutChild(this.titleChild, titleLeft, titleTop, titleRight, titleBottom);
        Logging.logd("Layout scroll");
        int scrollLeft = rightColLeft;
        int scrollTop = titleBottom;
        int scrollBottom = scrollTop + this.getDesiredHeight(this.scrollChild);
        int scrollRight = CONTAINER_RIGHT;
        this.layoutChild(this.scrollChild, scrollLeft, scrollTop, scrollRight, scrollBottom);
        Logging.logd("Layout action bar");
        int actionBarLeft = rightColLeft;
        int actionBarTop = CONTAINER_BOTTOM - this.getDesiredHeight(this.actionBarChild);
        int actionBarRight = CONTAINER_RIGHT;
        int actionBarBottom = CONTAINER_BOTTOM;
        this.layoutChild(this.actionBarChild, actionBarLeft, actionBarTop, actionBarRight, actionBarBottom);
    }
}

