/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.injection.components;

import android.app.Application;
import android.util.DisplayMetrics;
import com.google.firebase.inappmessaging.display.dagger.internal.DoubleCheck;
import com.google.firebase.inappmessaging.display.dagger.internal.MapBuilder;
import com.google.firebase.inappmessaging.display.dagger.internal.Preconditions;
import com.google.firebase.inappmessaging.display.internal.BindingWrapperFactory;
import com.google.firebase.inappmessaging.display.internal.BindingWrapperFactory_Factory;
import com.google.firebase.inappmessaging.display.internal.FiamWindowManager;
import com.google.firebase.inappmessaging.display.internal.FiamWindowManager_Factory;
import com.google.firebase.inappmessaging.display.internal.InAppMessageLayoutConfig;
import com.google.firebase.inappmessaging.display.internal.injection.components.UniversalComponent;
import com.google.firebase.inappmessaging.display.internal.injection.modules.ApplicationModule;
import com.google.firebase.inappmessaging.display.internal.injection.modules.ApplicationModule_ProvidesApplicationFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule_ProvidesBannerLandscapeLayoutConfigFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule_ProvidesBannerPortraitLayoutConfigFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule_ProvidesCardLandscapeConfigFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule_ProvidesCardPortraitConfigFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule_ProvidesDisplayMetricsFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule_ProvidesLandscapeImageLayoutConfigFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule_ProvidesModalLandscapeConfigFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule_ProvidesModalPortraitConfigFactory;
import com.google.firebase.inappmessaging.display.internal.injection.modules.InflaterConfigModule_ProvidesPortraitImageLayoutConfigFactory;
import java.util.Map;
import javax.inject.Provider;

public final class DaggerUniversalComponent
implements UniversalComponent {
    private final InflaterConfigModule inflaterConfigModule;
    private Provider<Application> providesApplicationProvider;
    private Provider<FiamWindowManager> fiamWindowManagerProvider;
    private Provider<BindingWrapperFactory> bindingWrapperFactoryProvider;
    private Provider<DisplayMetrics> providesDisplayMetricsProvider;
    private Provider<InAppMessageLayoutConfig> providesPortraitImageLayoutConfigProvider;
    private Provider<InAppMessageLayoutConfig> providesLandscapeImageLayoutConfigProvider;
    private Provider<InAppMessageLayoutConfig> providesModalLandscapeConfigProvider;
    private Provider<InAppMessageLayoutConfig> providesModalPortraitConfigProvider;
    private Provider<InAppMessageLayoutConfig> providesCardLandscapeConfigProvider;
    private Provider<InAppMessageLayoutConfig> providesCardPortraitConfigProvider;
    private Provider<InAppMessageLayoutConfig> providesBannerPortraitLayoutConfigProvider;
    private Provider<InAppMessageLayoutConfig> providesBannerLandscapeLayoutConfigProvider;

    private DaggerUniversalComponent(ApplicationModule applicationModuleParam, InflaterConfigModule inflaterConfigModuleParam) {
        this.inflaterConfigModule = inflaterConfigModuleParam;
        this.initialize(applicationModuleParam, inflaterConfigModuleParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(ApplicationModule applicationModuleParam, InflaterConfigModule inflaterConfigModuleParam) {
        this.providesApplicationProvider = DoubleCheck.provider(ApplicationModule_ProvidesApplicationFactory.create(applicationModuleParam));
        this.fiamWindowManagerProvider = DoubleCheck.provider(FiamWindowManager_Factory.create());
        this.bindingWrapperFactoryProvider = DoubleCheck.provider(BindingWrapperFactory_Factory.create(this.providesApplicationProvider));
        this.providesDisplayMetricsProvider = InflaterConfigModule_ProvidesDisplayMetricsFactory.create(inflaterConfigModuleParam, this.providesApplicationProvider);
        this.providesPortraitImageLayoutConfigProvider = InflaterConfigModule_ProvidesPortraitImageLayoutConfigFactory.create(inflaterConfigModuleParam, this.providesDisplayMetricsProvider);
        this.providesLandscapeImageLayoutConfigProvider = InflaterConfigModule_ProvidesLandscapeImageLayoutConfigFactory.create(inflaterConfigModuleParam, this.providesDisplayMetricsProvider);
        this.providesModalLandscapeConfigProvider = InflaterConfigModule_ProvidesModalLandscapeConfigFactory.create(inflaterConfigModuleParam, this.providesDisplayMetricsProvider);
        this.providesModalPortraitConfigProvider = InflaterConfigModule_ProvidesModalPortraitConfigFactory.create(inflaterConfigModuleParam, this.providesDisplayMetricsProvider);
        this.providesCardLandscapeConfigProvider = InflaterConfigModule_ProvidesCardLandscapeConfigFactory.create(inflaterConfigModuleParam, this.providesDisplayMetricsProvider);
        this.providesCardPortraitConfigProvider = InflaterConfigModule_ProvidesCardPortraitConfigFactory.create(inflaterConfigModuleParam, this.providesDisplayMetricsProvider);
        this.providesBannerPortraitLayoutConfigProvider = InflaterConfigModule_ProvidesBannerPortraitLayoutConfigFactory.create(inflaterConfigModuleParam, this.providesDisplayMetricsProvider);
        this.providesBannerLandscapeLayoutConfigProvider = InflaterConfigModule_ProvidesBannerLandscapeLayoutConfigFactory.create(inflaterConfigModuleParam, this.providesDisplayMetricsProvider);
    }

    @Override
    public Application providesApplication() {
        return (Application)this.providesApplicationProvider.get();
    }

    @Override
    public DisplayMetrics displayMetrics() {
        return InflaterConfigModule_ProvidesDisplayMetricsFactory.providesDisplayMetrics(this.inflaterConfigModule, (Application)this.providesApplicationProvider.get());
    }

    @Override
    public FiamWindowManager fiamWindowManager() {
        return (FiamWindowManager)this.fiamWindowManagerProvider.get();
    }

    @Override
    public BindingWrapperFactory inflaterClient() {
        return (BindingWrapperFactory)this.bindingWrapperFactoryProvider.get();
    }

    @Override
    public Map<String, Provider<InAppMessageLayoutConfig>> myKeyStringMap() {
        return MapBuilder.newMapBuilder(8).put("IMAGE_ONLY_PORTRAIT", this.providesPortraitImageLayoutConfigProvider).put("IMAGE_ONLY_LANDSCAPE", this.providesLandscapeImageLayoutConfigProvider).put("MODAL_LANDSCAPE", this.providesModalLandscapeConfigProvider).put("MODAL_PORTRAIT", this.providesModalPortraitConfigProvider).put("CARD_LANDSCAPE", this.providesCardLandscapeConfigProvider).put("CARD_PORTRAIT", this.providesCardPortraitConfigProvider).put("BANNER_PORTRAIT", this.providesBannerPortraitLayoutConfigProvider).put("BANNER_LANDSCAPE", this.providesBannerLandscapeLayoutConfigProvider).build();
    }

    public static final class Builder {
        private ApplicationModule applicationModule;
        private InflaterConfigModule inflaterConfigModule;

        private Builder() {
        }

        public Builder applicationModule(ApplicationModule applicationModule) {
            this.applicationModule = Preconditions.checkNotNull(applicationModule);
            return this;
        }

        public Builder inflaterConfigModule(InflaterConfigModule inflaterConfigModule) {
            this.inflaterConfigModule = Preconditions.checkNotNull(inflaterConfigModule);
            return this;
        }

        public UniversalComponent build() {
            Preconditions.checkBuilderRequirement(this.applicationModule, ApplicationModule.class);
            if (this.inflaterConfigModule == null) {
                this.inflaterConfigModule = new InflaterConfigModule();
            }
            return new DaggerUniversalComponent(this.applicationModule, this.inflaterConfigModule);
        }
    }
}

