/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdInternalReceiver;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zze;
import java.io.IOException;

public class FirebaseInstanceIdService
extends zzb {
    private static BroadcastReceiver baK;
    private static final Object baL;
    private static boolean baM;
    private boolean baN = false;

    @Override
    protected int zzaa(Intent intent) {
        this.baN = Log.isLoggable((String)"FirebaseInstanceId", (int)3);
        if (intent.getStringExtra("error") != null || intent.getStringExtra("registration_id") != null) {
            String string = this.zzac(intent);
            if (this.baN) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Register result in service ".concat(string2) : new String("Register result in service ")));
            }
            this.zzsi(string).zzcxb().zzu(intent);
            this.zzbmb();
            return 2;
        }
        return super.zzaa(intent);
    }

    @Override
    public void zzm(Intent intent) {
        String string = intent.getAction();
        if (string == null) {
            string = "";
        }
        switch (string) {
            case "ACTION_TOKEN_REFRESH_RETRY": {
                this.zza(intent, false);
                return;
            }
        }
        this.zzab(intent);
    }

    @Override
    protected Intent zzz(Intent intent) {
        return FirebaseInstanceIdInternalReceiver.zzcwy();
    }

    public void zzab(Intent intent) {
        String string = this.zzac(intent);
        zzd zzd2 = this.zzsi(string);
        String string2 = intent.getStringExtra("CMD");
        if (this.baN) {
            String string3 = String.valueOf(intent.getExtras());
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Service command ").append(string).append(" ").append(string2).append(" ").append(string3).toString());
        }
        if (null != intent.getStringExtra("unregistered")) {
            zzd2.zzcxa().zzkk(string == null ? "" : string);
            zzd2.zzcxb().zzu(intent);
            return;
        }
        if ("gcm.googleapis.com/refresh".equals(intent.getStringExtra("from"))) {
            zzd2.zzcxa().zzkk(string);
            this.zza(intent, false);
            return;
        }
        if ("RST".equals(string2)) {
            zzd2.zzbmu();
            this.zza(intent, true);
        } else if ("RST_FULL".equals(string2)) {
            if (!zzd2.zzcxa().isEmpty()) {
                zzd2.zzcxa().zzbna();
                this.zza(intent, true);
            }
        } else if ("SYNC".equals(string2)) {
            zzd2.zzcxa().zzkk(string);
            this.zza(intent, false);
        } else if ("PING".equals(string2)) {
            // empty if block
        }
    }

    private String zzac(Intent intent) {
        String string = intent.getStringExtra("subtype");
        return string == null ? "" : string;
    }

    private zzd zzsi(String string) {
        if (string == null) {
            return zzd.zzb((Context)this, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString("subtype", string);
        return zzd.zzb((Context)this, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(Intent intent, boolean bl) {
        Object object = baL;
        synchronized (object) {
            baM = false;
        }
        object = FirebaseInstanceId.getInstance();
        zze zze2 = ((FirebaseInstanceId)object).zzcwx();
        if (((FirebaseInstanceId)object).zzcwv() == null) {
            try {
                String string = ((FirebaseInstanceId)object).zzcww();
                if (string != null) {
                    if (this.baN) {
                        Log.d((String)"FirebaseInstanceId", (String)"get master token succeeded");
                    }
                    FirebaseInstanceIdService.zza((Context)this, (FirebaseInstanceId)object);
                    this.onTokenRefresh();
                    return;
                }
                this.zzd(intent, "returned token is null");
            }
            catch (IOException iOException) {
                this.zzd(intent, iOException.getMessage());
            }
            catch (SecurityException securityException) {
                Log.e((String)"FirebaseInstanceId", (String)"Unable to get master token", (Throwable)securityException);
                return;
            }
            return;
        }
        String string = zze2.zzcxc();
        while (string != null) {
            String[] stringArray = string.split("!");
            if (stringArray.length == 2) {
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                try {
                    switch (string2) {
                        case "S": {
                            FirebaseInstanceId.getInstance().zzsg(string3);
                            if (!this.baN) break;
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                            break;
                        }
                        case "U": {
                            FirebaseInstanceId.getInstance().zzsh(string3);
                            if (!this.baN) break;
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        }
                    }
                }
                catch (IOException iOException) {
                    this.zzd(intent, iOException.getMessage());
                    return;
                }
            }
            zze2.zzsj(string);
            string = zze2.zzcxc();
        }
        Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzd(Intent intent, String string) {
        boolean bl = FirebaseInstanceIdService.zzel((Context)this);
        final int n = this.zzb(intent, bl);
        Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(47 + String.valueOf(string).length()).append("background sync failed: ").append(string).append(", retry in ").append(n).append("s").toString());
        Object object = baL;
        synchronized (object) {
            this.zzads(n);
            baM = true;
        }
        if (!bl) {
            if (this.baN) {
                Log.d((String)"FirebaseInstanceId", (String)"device not connected. Connectivity change received registered");
            }
            if (baK == null) {
                baK = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        if (FirebaseInstanceIdService.zzel(context)) {
                            if (FirebaseInstanceIdService.this.baN) {
                                Log.d((String)"FirebaseInstanceId", (String)"connectivity changed. starting background sync.");
                            }
                            FirebaseInstanceIdService.this.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
                            context.sendBroadcast(FirebaseInstanceIdService.zzadr(n));
                        }
                    }
                };
            }
            this.getApplicationContext().registerReceiver(baK, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Context context, FirebaseInstanceId firebaseInstanceId) {
        Object object = baL;
        synchronized (object) {
            if (baM) {
                return;
            }
        }
        if (firebaseInstanceId.zzcwv() != null && firebaseInstanceId.zzcwx().zzcxc() == null) {
            return;
        }
        FirebaseInstanceIdService.zzek(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzek(Context context) {
        Object object = baL;
        synchronized (object) {
            if (!baM) {
                context.sendBroadcast(FirebaseInstanceIdService.zzadr(0));
                baM = true;
            }
        }
    }

    private static Intent zzadr(int n) {
        Context context = FirebaseApp.getInstance().getApplicationContext();
        Intent intent = new Intent("ACTION_TOKEN_REFRESH_RETRY");
        intent.putExtra("next_retry_delay_in_seconds", n);
        return FirebaseInstanceIdInternalReceiver.zzh(context, intent);
    }

    private void zzads(int n) {
        AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)FirebaseInstanceIdService.zzadr(n * 2), (int)0x10000000);
        alarmManager.set(3, SystemClock.elapsedRealtime() + (long)(n * 1000), pendingIntent);
    }

    private int zzb(Intent intent, boolean bl) {
        int n = intent == null ? 10 : intent.getIntExtra("next_retry_delay_in_seconds", 0);
        if (n < 10 && !bl) {
            n = 30;
        } else if (n < 10) {
            n = 10;
        } else if (n > 28800) {
            n = 28800;
        }
        return n;
    }

    private static boolean zzel(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    @WorkerThread
    public void onTokenRefresh() {
    }

    static {
        baL = new Object();
        baM = false;
    }
}

