/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.firebase.iid.zze;
import com.google.firebase.iid.zzg;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public final class zzi
implements ServiceConnection {
    private final Context zzag;
    private final Intent zzah;
    private final ScheduledExecutorService zzai;
    private final Queue<zze> zzaj = new ArrayDeque<zze>();
    private zzg zzak;
    @GuardedBy(value="this")
    private boolean zzal = false;

    public zzi(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory("Firebase-FirebaseInstanceIdServiceConnection")));
    }

    @VisibleForTesting
    private zzi(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zzag = context.getApplicationContext();
        this.zzah = new Intent(string).setPackage(this.zzag.getPackageName());
        this.zzai = scheduledExecutorService;
    }

    public final synchronized void zza(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"new intent queued in the bind-strategy delivery");
        }
        this.zzaj.add(new zze(intent, pendingResult, this.zzai));
        this.zzf();
    }

    private final synchronized void zzf() {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"flush queue called");
        }
        while (!this.zzaj.isEmpty()) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"found intent to be delivered");
            }
            if (this.zzak != null && this.zzak.isBinderAlive()) {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"binder is alive, sending the intent.");
                }
                zze zze2 = this.zzaj.poll();
                this.zzak.zza(zze2);
                continue;
            }
            zzi zzi2 = this;
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                boolean bl = !zzi2.zzal;
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!zzi2.zzal) {
                zzi2.zzal = true;
                try {
                    if (ConnectionTracker.getInstance().bindService(zzi2.zzag, zzi2.zzah, (ServiceConnection)zzi2, 65)) {
                        return;
                    }
                    Log.e((String)"EnhancedIntentService", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"EnhancedIntentService", (String)"Exception while binding the service", (Throwable)securityException);
                }
                zzi2.zzal = false;
                zzi2.zzg();
            }
            return;
        }
    }

    @GuardedBy(value="this")
    private final void zzg() {
        while (!this.zzaj.isEmpty()) {
            this.zzaj.poll().finish();
        }
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        String string;
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            string = String.valueOf(componentName);
            Log.d((String)"EnhancedIntentService", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
        }
        this.zzal = false;
        if (!(iBinder instanceof zzg)) {
            string = String.valueOf(iBinder);
            Log.e((String)"EnhancedIntentService", (String)new StringBuilder(28 + String.valueOf(string).length()).append("Invalid service connection: ").append(string).toString());
            this.zzg();
            return;
        }
        this.zzak = (zzg)iBinder;
        this.zzf();
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"EnhancedIntentService", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zzf();
    }
}

