/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.legacy.content.WakefulBroadcastReceiver;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;

public final class zzaw {
    private static zzaw zzdf;
    @GuardedBy(value="this")
    @Nullable
    private String zzdg = null;
    private Boolean zzdh = null;
    private Boolean zzdi = null;
    @VisibleForTesting
    private final Queue<Intent> zzdj = new ArrayDeque<Intent>();

    public static synchronized zzaw zzak() {
        if (zzdf == null) {
            zzdf = new zzaw();
        }
        return zzdf;
    }

    private zzaw() {
    }

    public final Intent zzal() {
        return this.zzdj.poll();
    }

    public final int zzc(Context context, Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Starting service");
        }
        this.zzdj.offer(intent);
        Intent intent2 = new Intent("com.google.firebase.MESSAGING_EVENT");
        intent2.setPackage(context.getPackageName());
        return this.zzd(context, intent2);
    }

    private final int zzd(Context context, Intent intent) {
        String string = this.zze(context, intent);
        if (string != null) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Restricting intent to a specific service: ".concat(string2) : new String("Restricting intent to a specific service: ")));
            }
            intent.setClassName(context.getPackageName(), string);
        }
        try {
            ComponentName componentName;
            if (this.zzd(context)) {
                componentName = WakefulBroadcastReceiver.startWakefulService((Context)context, (Intent)intent);
            } else {
                componentName = context.startService(intent);
                Log.d((String)"FirebaseInstanceId", (String)"Missing wake lock permission, service start may be delayed");
            }
            if (componentName == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Error while delivering the message: ServiceIntent not found.");
                return 404;
            }
            return -1;
        }
        catch (SecurityException securityException) {
            Log.e((String)"FirebaseInstanceId", (String)"Error while delivering the message to the serviceIntent", (Throwable)securityException);
            return 401;
        }
        catch (IllegalStateException illegalStateException) {
            String string3 = String.valueOf(illegalStateException);
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(45 + String.valueOf(string3).length()).append("Failed to start service while in background: ").append(string3).toString());
            return 402;
        }
    }

    @Nullable
    private final synchronized String zze(Context context, Intent intent) {
        if (this.zzdg != null) {
            return this.zzdg;
        }
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to resolve target intent service, skipping classname enforcement");
            return null;
        }
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        if (!context.getPackageName().equals(serviceInfo.packageName) || serviceInfo.name == null) {
            String string = serviceInfo.packageName;
            String string2 = serviceInfo.name;
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(94 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ").append(string).append("/").append(string2).toString());
            return null;
        }
        if (serviceInfo.name.startsWith(".")) {
            String string = String.valueOf(context.getPackageName());
            String string3 = String.valueOf(serviceInfo.name);
            this.zzdg = string3.length() != 0 ? string.concat(string3) : new String(string);
        } else {
            this.zzdg = serviceInfo.name;
        }
        return this.zzdg;
    }

    final boolean zzd(Context context) {
        if (this.zzdh == null) {
            this.zzdh = context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0;
        }
        if (!this.zzdh.booleanValue() && Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Missing Permission: android.permission.WAKE_LOCK this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.zzdh;
    }

    final boolean zze(Context context) {
        if (this.zzdi == null) {
            this.zzdi = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
        }
        if (!this.zzdh.booleanValue() && Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Missing Permission: android.permission.ACCESS_NETWORK_STATE this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.zzdi;
    }
}

