/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.firebase_messaging.zze;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzaf;
import com.google.firebase.iid.zzag;
import com.google.firebase.iid.zzah;
import com.google.firebase.iid.zzaj;
import com.google.firebase.iid.zzam;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzae
implements ServiceConnection {
    @GuardedBy(value="this")
    int state = 0;
    final Messenger zzcd = new Messenger((Handler)new zze(Looper.getMainLooper(), new zzad(this)));
    zzah zzce;
    @GuardedBy(value="this")
    final Queue<zzaj<?>> zzcf = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzaj<?>> zzcg = new SparseArray();
    final /* synthetic */ zzac zzch;

    private zzae(zzac zzac2) {
        this.zzch = zzac2;
    }

    final synchronized boolean zzb(zzaj zzaj2) {
        switch (this.state) {
            case 0: {
                this.zzcf.add(zzaj2);
                zzae zzae2 = this;
                Preconditions.checkState((zzae2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzae2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzac.zza(zzae2.zzch), intent, (ServiceConnection)zzae2, 1)) {
                    zzae2.zza(0, "Unable to bind to service");
                } else {
                    zzac.zzb(zzae2.zzch).schedule(new zzag(zzae2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzcf.add(zzaj2);
                return true;
            }
            case 2: {
                this.zzcf.add(zzaj2);
                this.zzy();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzaj zzaj2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzae zzae2 = this;
        synchronized (zzae2) {
            zzaj2 = (zzaj)this.zzcg.get(n);
            if (zzaj2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zzcg.remove(n);
            this.zzz();
        }
        Bundle bundle = message.getData();
        zzaj zzaj3 = zzaj2;
        if (bundle.getBoolean("unsupported", false)) {
            zzaj3.zza(new zzam(4, "Not supported by GmsCore"));
        } else {
            zzaj3.zzb(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zza(0, "Null service connection");
            return;
        }
        try {
            this.zzce = new zzah(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zza(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzy();
    }

    private final void zzy() {
        zzac.zzb(this.zzch).execute(new zzaf(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zza(2, "Service disconnected");
    }

    final synchronized void zza(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                ConnectionTracker.getInstance().unbindService(zzac.zza(this.zzch), (ServiceConnection)this);
                zzam zzam2 = new zzam(n, string);
                zzae zzae2 = this;
                Iterator iterator = zzae2.zzcf.iterator();
                while (iterator.hasNext()) {
                    ((zzaj)iterator.next()).zza(zzam2);
                }
                zzae2.zzcf.clear();
                for (int i = 0; i < zzae2.zzcg.size(); ++i) {
                    ((zzaj)zzae2.zzcg.valueAt(i)).zza(zzam2);
                }
                zzae2.zzcg.clear();
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzz() {
        if (this.state == 2 && this.zzcf.isEmpty() && this.zzcg.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            ConnectionTracker.getInstance().unbindService(zzac.zza(this.zzch), (ServiceConnection)this);
        }
    }

    final synchronized void zzaa() {
        if (this.state == 1) {
            this.zza(1, "Timed out while binding");
        }
    }

    final synchronized void zza(int n) {
        zzaj zzaj2 = (zzaj)this.zzcg.get(n);
        if (zzaj2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zzcg.remove(n);
            zzaj2.zza(new zzam(3, "Timed out waiting for response"));
            this.zzz();
        }
    }

    /* synthetic */ zzae(zzac zzac2, zzab zzab2) {
        this(zzac2);
    }
}

