/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.zzan;
import com.google.firebase.iid.zzaw;
import com.google.firebase.iid.zzay;
import com.google.firebase.iid.zzaz;
import com.google.firebase.iid.zzba;
import java.io.IOException;

final class zzax
implements Runnable {
    private final long zzdk;
    private final PowerManager.WakeLock zzdl;
    private final FirebaseInstanceId zzdm;
    private final zzaz zzay;

    @VisibleForTesting
    zzax(FirebaseInstanceId firebaseInstanceId, zzan zzan2, zzaz zzaz2, long l) {
        this.zzdm = firebaseInstanceId;
        this.zzay = zzaz2;
        this.zzdk = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zzdl = powerManager.newWakeLock(1, "fiid-sync");
        this.zzdl.setReferenceCounted(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressLint(value={"Wakelock"})
    public final void run() {
        block8: {
            block7: {
                try {
                    if (zzaw.zzak().zzd(this.getContext())) {
                        this.zzdl.acquire();
                    }
                    this.zzdm.zza(true);
                    if (this.zzdm.zzo()) break block7;
                    this.zzdm.zza(false);
                    if (!zzaw.zzak().zzd(this.getContext())) return;
                }
                catch (Throwable throwable) {
                    if (!zzaw.zzak().zzd(this.getContext())) throw throwable;
                    this.zzdl.release();
                    throw throwable;
                }
                this.zzdl.release();
                return;
            }
            if (!zzaw.zzak().zze(this.getContext()) || this.zzan()) break block8;
            new zzba(this).zzaq();
            if (!zzaw.zzak().zzd(this.getContext())) return;
            this.zzdl.release();
            return;
        }
        if (this.zzam() && this.zzay.zzc(this.zzdm)) {
            this.zzdm.zza(false);
        } else {
            this.zzdm.zza(this.zzdk);
        }
        if (!zzaw.zzak().zzd(this.getContext())) return;
        this.zzdl.release();
    }

    @VisibleForTesting
    private final boolean zzam() {
        zzay zzay2 = this.zzdm.zzk();
        if (!this.zzdm.zzr() && !this.zzdm.zza(zzay2)) {
            return true;
        }
        try {
            String string = this.zzdm.zzl();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzay2 == null || zzay2 != null && !string.equals(zzay2.zzbv)) {
                String string2 = string;
                zzax zzax2 = this;
                Intent intent = new Intent("com.google.firebase.messaging.NEW_TOKEN");
                intent.putExtra("token", string2);
                Intent intent2 = intent;
                Context context = zzax2.getContext();
                Intent intent3 = intent2;
                String string3 = "com.google.firebase.MESSAGING_EVENT";
                Context context2 = context;
                Intent intent4 = new Intent(context2, FirebaseInstanceIdReceiver.class);
                intent4.setAction(string3);
                intent4.putExtra("wrapped_intent", (Parcelable)intent3);
                context.sendBroadcast(intent4);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    final Context getContext() {
        return this.zzdm.zzi().getApplicationContext();
    }

    final boolean zzan() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

