/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.os.Build;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.MessagingChannel;
import com.google.firebase.iid.zzam;
import com.google.firebase.iid.zzas;
import com.google.firebase.iid.zzh;
import com.google.firebase.iid.zzs;
import com.google.firebase.iid.zzt;
import com.google.firebase.iid.zzv;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.Executor;

final class zzr
implements MessagingChannel {
    private final FirebaseApp zzau;
    private final zzam zzav;
    private final zzas zzbp;
    private final Executor executor;
    private final UserAgentPublisher zzbq;

    zzr(FirebaseApp firebaseApp, zzam zzam2, Executor executor, UserAgentPublisher userAgentPublisher) {
        this(firebaseApp, zzam2, executor, new zzas(firebaseApp.getApplicationContext(), zzam2), userAgentPublisher);
    }

    @VisibleForTesting
    private zzr(FirebaseApp firebaseApp, zzam zzam2, Executor executor, zzas zzas2, UserAgentPublisher userAgentPublisher) {
        this.zzau = firebaseApp;
        this.zzav = zzam2;
        this.zzbp = zzas2;
        this.executor = executor;
        this.zzbq = userAgentPublisher;
    }

    @Override
    public final boolean isAvailable() {
        return this.zzav.zzac() != 0;
    }

    @Override
    public final boolean isChannelBuilt() {
        return true;
    }

    @Override
    public final Task<Void> buildChannel(String string, String string2) {
        return Tasks.forResult(null);
    }

    @Override
    public final boolean needsRefresh() {
        return false;
    }

    @Override
    public final Task<String> getToken(String string, String string2, String string3, String string4) {
        Task<Bundle> task = this.zza(string, string3, string4, new Bundle());
        return this.zzc(task);
    }

    @Override
    public final Task<Void> deleteToken(String string, String string2, String string3, String string4) {
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        Task<Bundle> task = this.zza(string, string3, string4, bundle);
        return this.zzb(this.zzc(task));
    }

    @Override
    public final Task<Void> deleteInstanceId(String string) {
        Bundle bundle = new Bundle();
        bundle.putString("iid-operation", "delete");
        bundle.putString("delete", "1");
        Task<Bundle> task = this.zza(string, "*", "*", bundle);
        return this.zzb(this.zzc(task));
    }

    @Override
    public final Task<Void> ackMessage(String string) {
        return null;
    }

    @Override
    public final Task<Void> subscribeToTopic(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string3);
        bundle.putString("gcm.topic", string5.length() != 0 ? string4.concat(string5) : new String(string4));
        String string6 = string2;
        String string7 = String.valueOf("/topics/");
        String string8 = String.valueOf(string3);
        String string9 = string8.length() != 0 ? string7.concat(string8) : new String(string7);
        Task<Bundle> task = this.zza(string, string6, string9, bundle);
        return this.zzb(this.zzc(task));
    }

    @Override
    public final Task<Void> unsubscribeFromTopic(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string3);
        bundle.putString("gcm.topic", string5.length() != 0 ? string4.concat(string5) : new String(string4));
        bundle.putString("delete", "1");
        String string6 = string2;
        String string7 = String.valueOf("/topics/");
        String string8 = String.valueOf(string3);
        String string9 = string8.length() != 0 ? string7.concat(string8) : new String(string7);
        Task<Bundle> task = this.zza(string, string6, string9, bundle);
        return this.zzb(this.zzc(task));
    }

    private final Task<Bundle> zza(String string, String string2, String string3, Bundle bundle) {
        Bundle bundle2 = bundle;
        String string4 = string3;
        String string5 = string2;
        String string6 = string;
        zzr zzr2 = this;
        bundle2.putString("scope", string4);
        bundle2.putString("sender", string5);
        bundle2.putString("subtype", string5);
        bundle2.putString("appid", string6);
        bundle2.putString("gmp_app_id", zzr2.zzau.getOptions().getApplicationId());
        bundle2.putString("gmsv", Integer.toString(zzr2.zzav.zzaf()));
        bundle2.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle2.putString("app_ver", zzr2.zzav.zzad());
        bundle2.putString("app_ver_name", zzr2.zzav.zzae());
        bundle2.putString("cliv", "fiid-12451000");
        bundle2.putString("Firebase-Client", zzr2.zzbq.getUserAgent());
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.executor.execute(new zzt(this, bundle, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    private static String zza(Bundle bundle) throws IOException {
        if (bundle == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = bundle.getString("registration_id");
        if (string != null) {
            return string;
        }
        String string2 = bundle.getString("unregistered");
        if (string2 != null) {
            return string2;
        }
        String string3 = bundle.getString("error");
        if ("RST".equals(string3)) {
            throw new IOException("INSTANCE_ID_RESET");
        }
        if (string3 != null) {
            throw new IOException(string3);
        }
        String string4 = String.valueOf(bundle);
        Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(21 + String.valueOf(string4).length()).append("Unexpected response: ").append(string4).toString(), (Throwable)new Throwable());
        throw new IOException("SERVICE_NOT_AVAILABLE");
    }

    private final <T> Task<Void> zzb(Task<T> task) {
        return task.continueWith(zzh.zzd(), (Continuation)new zzs(this));
    }

    private final Task<String> zzc(Task<Bundle> task) {
        return task.continueWith(this.executor, (Continuation)new zzv(this));
    }

    final /* synthetic */ void zza(Bundle bundle, TaskCompletionSource taskCompletionSource) {
        try {
            Bundle bundle2 = this.zzbp.zzc(bundle);
            taskCompletionSource.setResult((Object)bundle2);
            return;
        }
        catch (IOException iOException) {
            taskCompletionSource.setException((Exception)iOException);
            return;
        }
    }

    static /* synthetic */ String zza(zzr zzr2, Bundle bundle) throws IOException {
        return zzr.zza(bundle);
    }
}

